/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.RepositoryServiceRegistry;
import org.pentaho.di.repository.pur.UnifiedRepositoryLockService;
import org.pentaho.di.repository.pur.model.EERepositoryObject;
import org.pentaho.di.repository.pur.model.RepositoryLock;
import org.pentaho.di.ui.repository.pur.services.ILockService;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyUnifiedRepositoryDirectory
extends RepositoryDirectory {
    private RepositoryFile self;
    private IUnifiedRepository repository;
    private RepositoryServiceRegistry registry;
    private List<RepositoryDirectoryInterface> subdirectories;
    private List<RepositoryElementMetaInterface> fileChildren;
    private RepositoryDirectoryInterface parent;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public LazyUnifiedRepositoryDirectory(RepositoryFile self, RepositoryDirectoryInterface parent, IUnifiedRepository repository, RepositoryServiceRegistry registry) {
        this.self = self;
        this.parent = parent;
        this.repository = repository;
        this.registry = registry;
    }

    private String getParentPath(String absolutePath) {
        int parentEndIndex = absolutePath.endsWith("/") ? absolutePath.lastIndexOf("/", absolutePath.length() - 2) : absolutePath.lastIndexOf("/");
        if (parentEndIndex < 0) {
            return null;
        }
        return absolutePath.substring(0, parentEndIndex);
    }

    public RepositoryDirectory findDirectory(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        String absolutePath = path.startsWith("/") ? (this.self.getPath().endsWith("/") ? this.self.getPath() + path.substring(1) : this.self.getPath() + path) : (this.self.getPath().endsWith("/") ? this.self.getPath() + path : this.self.getPath() + "/" + path);
        RepositoryFile file = this.repository.getFile(absolutePath);
        if (file == null || !file.isFolder()) {
            return null;
        }
        if (this.isRoot() && "/".equals(absolutePath)) {
            return this;
        }
        String parentPath = this.getParentPath(absolutePath);
        if (this.self.getPath().endsWith("/") ? parentPath.equals(this.self.getPath().substring(0, this.self.getPath().length() - 1)) : parentPath.equals(this.self.getPath())) {
            return new LazyUnifiedRepositoryDirectory(file, (RepositoryDirectoryInterface)this, this.repository, this.registry);
        }
        return new LazyUnifiedRepositoryDirectory(file, (RepositoryDirectoryInterface)this.findDirectory(parentPath), this.repository, this.registry);
    }

    public RepositoryDirectory findChild(String name) {
        return this.findDirectory(name);
    }

    public RepositoryDirectory findDirectory(String[] path) {
        return this.findDirectory(StringUtils.join((Object[])path, (String)"/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryDirectoryInterface> getChildren() {
        if (this.subdirectories == null) {
            List<RepositoryDirectoryInterface> list = this.subdirectories = new ArrayList<RepositoryDirectoryInterface>();
            synchronized (list) {
                List<RepositoryFile> children = this.getAllURChildrenFiles();
                for (RepositoryFile child : children) {
                    LazyUnifiedRepositoryDirectory dir = new LazyUnifiedRepositoryDirectory(child, (RepositoryDirectoryInterface)this, this.repository, this.registry);
                    dir.setObjectId((ObjectId)new StringObjectId(child.getId().toString()));
                    this.addSubdirectory((RepositoryDirectoryInterface)dir);
                }
            }
        }
        return this.subdirectories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryElementMetaInterface> getRepositoryObjects() {
        if (this.fileChildren == null) {
            List<RepositoryElementMetaInterface> list = this.fileChildren = new ArrayList<RepositoryElementMetaInterface>();
            synchronized (list) {
                UnifiedRepositoryLockService lockService = (UnifiedRepositoryLockService)this.registry.getService(ILockService.class);
                RepositoryFileTree tree = this.repository.getTree(new RepositoryRequest(this.self.getPath(), Boolean.valueOf(true), Integer.valueOf(1), null));
                for (RepositoryFileTree tchild : tree.getChildren()) {
                    RepositoryFile child = tchild.getFile();
                    if (child.isFolder()) continue;
                    RepositoryLock lock = null;
                    try {
                        lock = lockService.getLock(child);
                        RepositoryObjectType objectType = PurRepository.getObjectType(child.getName());
                        EERepositoryObject repositoryObject = new EERepositoryObject(child, (RepositoryDirectoryInterface)this, null, objectType, null, lock, false);
                        repositoryObject.setVersioningEnabled(tchild.getVersioningEnabled());
                        repositoryObject.setVersionCommentEnabled(tchild.getVersionCommentEnabled());
                        this.fileChildren.add(repositoryObject);
                    }
                    catch (KettleException e) {
                        this.logger.error("Error converting Unified Repository file to PDI RepositoryObject: " + child.getPath() + ". File will be skipped", (Throwable)e);
                    }
                }
            }
        }
        return this.fileChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepositoryObjects(List<RepositoryElementMetaInterface> list) {
        List<RepositoryElementMetaInterface> list2 = this.fileChildren;
        synchronized (list2) {
            this.fileChildren.clear();
            this.fileChildren.addAll(list);
        }
    }

    public boolean isVisible() {
        return !this.isRoot() && !this.self.isHidden();
    }

    public int getNrSubdirectories() {
        List<RepositoryFile> childrenFiles = this.getAllURChildrenFiles();
        return childrenFiles.size();
    }

    public RepositoryDirectory getSubdirectory(int i) {
        if (this.subdirectories == null) {
            this.getChildren();
        }
        if (i >= this.subdirectories.size() || i < 0) {
            return null;
        }
        RepositoryDirectoryInterface directoryInterface = this.subdirectories.get(i);
        if (directoryInterface instanceof RepositoryDirectory) {
            return (RepositoryDirectory)directoryInterface;
        }
        throw new IllegalStateException("Bad Repository interface expects RepositoryDirectoryInterface to be an instance of RepositoryDirectory. This class is not: " + directoryInterface.getClass().getName());
    }

    private List<RepositoryFile> getAllURChildrenFiles() {
        RepositoryRequest repositoryRequest = new RepositoryRequest();
        repositoryRequest.setShowHidden(true);
        repositoryRequest.setTypes(RepositoryRequest.FILES_TYPE_FILTER.FOLDERS);
        repositoryRequest.setPath(this.self.getId().toString());
        List children = this.repository.getChildren(repositoryRequest);
        RepositoryFile etcFile = null;
        if (this.isRoot()) {
            etcFile = this.repository.getFile(ClientRepositoryPaths.getEtcFolderPath());
        }
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            RepositoryFile next = (RepositoryFile)iterator.next();
            if (!next.isFolder()) {
                iterator.remove();
            }
            if (!this.isRoot() || !next.equals((Object)etcFile)) continue;
            iterator.remove();
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<RepositoryElementMetaInterface> list;
        if (this.fileChildren != null) {
            list = this.fileChildren;
            synchronized (list) {
                this.fileChildren.clear();
            }
        }
        if (this.subdirectories != null) {
            list = this.subdirectories;
            synchronized (list) {
                this.subdirectories.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubdirectory(RepositoryDirectoryInterface repositoryDirectoryInterface) {
        if (this.subdirectories == null) {
            this.subdirectories = new ArrayList<RepositoryDirectoryInterface>();
        }
        List<RepositoryDirectoryInterface> list = this.subdirectories;
        synchronized (list) {
            this.subdirectories.add(repositoryDirectoryInterface);
        }
    }

    public String getName() {
        return this.self.getName();
    }

    public String getPath() {
        return this.self.getPath();
    }

    public ObjectId getObjectId() {
        return new StringObjectId(this.self.getId().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(List<RepositoryDirectoryInterface> list) {
        if (this.subdirectories == null) {
            this.subdirectories = new ArrayList<RepositoryDirectoryInterface>();
        }
        if (!this.subdirectories.equals(list)) {
            List<RepositoryDirectoryInterface> list2 = this.subdirectories;
            synchronized (list2) {
                this.subdirectories.clear();
                this.subdirectories.addAll(list);
            }
        }
    }

    public String[] getPathArray() {
        return this.getPath().split("/");
    }

    public ObjectId[] getDirectoryIDs() {
        List<RepositoryFile> children = this.getAllURChildrenFiles();
        ObjectId[] objectIds = new ObjectId[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            objectIds[i] = new StringObjectId(children.get(i).getId().toString());
        }
        return objectIds;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public RepositoryDirectoryInterface findRoot() {
        LazyUnifiedRepositoryDirectory current = this;
        RepositoryDirectoryInterface parent = null;
        while ((parent = current.getParent()) != null) {
            current = parent;
        }
        return current;
    }

    public void setParent(RepositoryDirectoryInterface repositoryDirectoryInterface) {
        this.parent = repositoryDirectoryInterface;
    }

    public RepositoryDirectoryInterface getParent() {
        return this.parent;
    }

    public void setObjectId(ObjectId objectId) {
    }

    public void setName(String s) {
    }

    public String getPathObjectCombination(String transName) {
        if (this.isRoot()) {
            return this.getPath() + transName;
        }
        return this.getPath() + "/" + transName;
    }
}

