/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.AbstractDelegate;
import org.pentaho.di.repository.pur.ITransformer;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.SharedObjectAssembler;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;

public class PartitionDelegate
extends AbstractDelegate
implements ITransformer,
SharedObjectAssembler<PartitionSchema>,
Serializable {
    private static final long serialVersionUID = -6069812592810099251L;
    private static final String NODE_ROOT = "partitionSchema";
    private static final String PROP_DYNAMIC_DEFINITION = "DYNAMIC_DEFINITION";
    private static final String PROP_PARTITIONS_PER_SLAVE = "PARTITIONS_PER_SLAVE";
    private static final String NODE_ATTRIBUTES = "attributes";
    private static final String PROP_NB_PARTITION_SCHEMA = "NB_PARTITION_SCHEMA";
    private PurRepository repo;

    public PartitionDelegate(PurRepository repo) {
        this.repo = repo;
    }

    @Override
    public RepositoryElementInterface dataNodeToElement(DataNode rootNode) throws KettleException {
        PartitionSchema partitionSchema = new PartitionSchema();
        this.dataNodeToElement(rootNode, (RepositoryElementInterface)partitionSchema);
        return partitionSchema;
    }

    @Override
    public void dataNodeToElement(DataNode rootNode, RepositoryElementInterface element) throws KettleException {
        PartitionSchema partitionSchema = (PartitionSchema)element;
        partitionSchema.setDynamicallyDefined(rootNode.getProperty(PROP_DYNAMIC_DEFINITION).getBoolean());
        partitionSchema.setNumberOfPartitionsPerSlave(this.getString(rootNode, PROP_PARTITIONS_PER_SLAVE));
        DataNode attrNode = rootNode.getNode(NODE_ATTRIBUTES);
        long partitionSchemaSize = attrNode.getProperty(PROP_NB_PARTITION_SCHEMA).getLong();
        int i = 0;
        while ((long)i < partitionSchemaSize) {
            DataProperty property = attrNode.getProperty(String.valueOf(i));
            partitionSchema.getPartitionIDs().add(Const.NVL((String)property.getString(), (String)""));
            ++i;
        }
    }

    @Override
    public DataNode elementToDataNode(RepositoryElementInterface element) throws KettleException {
        PartitionSchema partitionSchema = (PartitionSchema)element;
        DataNode rootNode = new DataNode(NODE_ROOT);
        ObjectId partitionId = this.repo.getPartitionSchemaID(partitionSchema.getName());
        if (partitionId != null && !partitionSchema.getObjectId().equals(partitionId)) {
            throw new KettleException("Failed to save object to repository. Object [" + partitionSchema.getName() + "] already exists.");
        }
        rootNode.setProperty(PROP_DYNAMIC_DEFINITION, partitionSchema.isDynamicallyDefined());
        rootNode.setProperty(PROP_PARTITIONS_PER_SLAVE, partitionSchema.getNumberOfPartitionsPerSlave());
        DataNode attrNode = rootNode.addNode(NODE_ATTRIBUTES);
        attrNode.setProperty(PROP_NB_PARTITION_SCHEMA, (long)partitionSchema.getPartitionIDs().size());
        for (int i = 0; i < partitionSchema.getPartitionIDs().size(); ++i) {
            attrNode.setProperty(String.valueOf(i), (String)partitionSchema.getPartitionIDs().get(i));
        }
        return rootNode;
    }

    @Override
    public PartitionSchema assemble(RepositoryFile file, NodeRepositoryFileData data, VersionSummary version) throws KettleException {
        PartitionSchema partitionSchema = (PartitionSchema)this.dataNodeToElement(data.getNode());
        partitionSchema.setName(file.getTitle());
        partitionSchema.setObjectId((ObjectId)new StringObjectId(file.getId().toString()));
        partitionSchema.setObjectRevision(this.repo.createObjectRevision(version));
        partitionSchema.clearChanged();
        return partitionSchema;
    }
}

