/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.ZKFailoverController;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.proto.HAZKInfoProtos;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class DFSZKFailoverController
extends ZKFailoverController {
    private static final Log LOG = LogFactory.getLog(DFSZKFailoverController.class);
    private final AccessControlList adminAcl;
    private final NNHAServiceTarget localNNTarget;

    protected HAServiceTarget dataToTarget(byte[] data) {
        HAZKInfoProtos.ActiveNodeInfo proto;
        try {
            proto = HAZKInfoProtos.ActiveNodeInfo.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Invalid data in ZK: " + StringUtils.byteToHexString((byte[])data));
        }
        NNHAServiceTarget ret = new NNHAServiceTarget(this.conf, proto.getNameserviceId(), proto.getNamenodeId());
        InetSocketAddress addressFromProtobuf = new InetSocketAddress(proto.getHostname(), proto.getPort());
        if (!addressFromProtobuf.equals(ret.getAddress())) {
            throw new RuntimeException("Mismatched address stored in ZK for " + (Object)((Object)ret) + ": Stored protobuf was " + proto + ", address from our own " + "configuration for this NameNode was " + ret.getAddress());
        }
        ret.setZkfcPort(proto.getZkfcPort());
        return ret;
    }

    protected byte[] targetToData(HAServiceTarget target) {
        InetSocketAddress addr = target.getAddress();
        return HAZKInfoProtos.ActiveNodeInfo.newBuilder().setHostname(addr.getHostName()).setPort(addr.getPort()).setZkfcPort(target.getZKFCAddress().getPort()).setNameserviceId(this.localNNTarget.getNameServiceId()).setNamenodeId(this.localNNTarget.getNameNodeId()).build().toByteArray();
    }

    protected InetSocketAddress getRpcAddressToBindTo() {
        int zkfcPort = DFSZKFailoverController.getZkfcPort(this.conf);
        return new InetSocketAddress(this.localTarget.getAddress().getAddress(), zkfcPort);
    }

    protected PolicyProvider getPolicyProvider() {
        return new HDFSPolicyProvider();
    }

    static int getZkfcPort(Configuration conf) {
        return conf.getInt("dfs.ha.zkfc.port", 8019);
    }

    public static DFSZKFailoverController create(Configuration conf) {
        String nsId;
        Configuration localNNConf = DFSHAAdmin.addSecurityConfiguration(conf);
        if (!HAUtil.isHAEnabled(localNNConf, nsId = DFSUtil.getNamenodeNameServiceId(conf))) {
            throw new HadoopIllegalArgumentException("HA is not enabled for this namenode.");
        }
        String nnId = HAUtil.getNameNodeId(localNNConf, nsId);
        if (nnId == null) {
            String msg = "Could not get the namenode ID of this node. You may run zkfc on the node other than namenode.";
            throw new HadoopIllegalArgumentException(msg);
        }
        NameNode.initializeGenericKeys(localNNConf, nsId, nnId);
        DFSUtil.setGenericConf(localNNConf, nsId, nnId, ZKFC_CONF_KEYS);
        NNHAServiceTarget localTarget = new NNHAServiceTarget(localNNConf, nsId, nnId);
        return new DFSZKFailoverController(localNNConf, localTarget);
    }

    private DFSZKFailoverController(Configuration conf, NNHAServiceTarget localTarget) {
        super(conf, (HAServiceTarget)localTarget);
        this.localNNTarget = localTarget;
        this.adminAcl = new AccessControlList(conf.get("dfs.cluster.administrators", " "));
        LOG.info((Object)("Failover controller configured for NameNode " + (Object)((Object)localTarget)));
    }

    protected void initRPC() throws IOException {
        super.initRPC();
        this.localNNTarget.setZkfcPort(this.rpcServer.getAddress().getPort());
    }

    public void loginAsFCUser() throws IOException {
        InetSocketAddress socAddr = NameNode.getAddress(this.conf);
        SecurityUtil.login((Configuration)this.conf, (String)"dfs.namenode.keytab.file", (String)"dfs.namenode.kerberos.principal", (String)socAddr.getHostName());
    }

    protected String getScopeInsideParentNode() {
        return this.localNNTarget.getNameServiceId();
    }

    public static void main(String[] args) throws Exception {
        StringUtils.startupShutdownMessage(DFSZKFailoverController.class, (String[])args, (Log)LOG);
        if (DFSUtil.parseHelpArgument(args, "Usage: java zkfc [ -formatZK [-force] [-nonInteractive] ]", System.out, true)) {
            System.exit(0);
        }
        GenericOptionsParser parser = new GenericOptionsParser((Configuration)new HdfsConfiguration(), args);
        DFSZKFailoverController zkfc = DFSZKFailoverController.create(parser.getConfiguration());
        int retCode = 0;
        try {
            retCode = zkfc.run(parser.getRemainingArgs());
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Got a fatal error, exiting now", t);
        }
        System.exit(retCode);
    }

    protected void checkRpcAdminAccess() throws IOException, AccessControlException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation zkfcUgi = UserGroupInformation.getLoginUser();
        if (this.adminAcl.isUserAllowed(ugi) || ugi.getShortUserName().equals(zkfcUgi.getShortUserName())) {
            LOG.info((Object)("Allowed RPC access from " + ugi + " at " + Server.getRemoteAddress()));
            return;
        }
        String msg = "Disallowed RPC access from " + ugi + " at " + Server.getRemoteAddress() + ". Not listed in " + "dfs.cluster.administrators";
        LOG.warn((Object)msg);
        throw new AccessControlException(msg);
    }
}

