/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.util.ArrayList;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.ForkNodeDef;
import org.apache.oozie.workflow.lite.JoinNodeDef;
import org.apache.oozie.workflow.lite.KillNodeDef;
import org.apache.oozie.workflow.lite.NodeHandler;
import org.apache.oozie.workflow.lite.StartNodeDef;

public abstract class ControlNodeHandler
extends NodeHandler {
    public static final String FORK_COUNT_PREFIX = "workflow.fork.";

    public abstract void touch(NodeHandler.Context var1) throws WorkflowException;

    @Override
    public boolean enter(NodeHandler.Context context) throws WorkflowException {
        boolean doTouch;
        Class<?> nodeClass = context.getNodeDef().getClass();
        if (nodeClass.equals(StartNodeDef.class)) {
            if (!context.getSignalValue().equals(":start:")) {
                throw new WorkflowException(ErrorCode.E0715, context.getSignalValue());
            }
            doTouch = true;
        } else if (nodeClass.equals(EndNodeDef.class)) {
            doTouch = true;
        } else if (nodeClass.equals(KillNodeDef.class)) {
            doTouch = true;
        } else if (nodeClass.equals(ForkNodeDef.class)) {
            doTouch = true;
        } else if (nodeClass.equals(JoinNodeDef.class)) {
            String parentExecutionPath = context.getParentExecutionPath(context.getExecutionPath());
            String forkCount = context.getVar(FORK_COUNT_PREFIX + parentExecutionPath);
            if (forkCount == null) {
                throw new WorkflowException(ErrorCode.E0720, context.getNodeDef().getName());
            }
            int count = Integer.parseInt(forkCount) - 1;
            if (count > 0) {
                context.setVar(FORK_COUNT_PREFIX + parentExecutionPath, "" + count);
                context.deleteExecutionPath();
            } else {
                context.setVar(FORK_COUNT_PREFIX + parentExecutionPath, null);
            }
            doTouch = count == 0;
        } else {
            throw new IllegalStateException("Invalid node type: " + nodeClass);
        }
        if (doTouch) {
            this.touch(context);
        }
        return false;
    }

    @Override
    public String exit(NodeHandler.Context context) throws WorkflowException {
        Class<?> nodeClass = context.getNodeDef().getClass();
        if (nodeClass.equals(StartNodeDef.class)) {
            return context.getNodeDef().getTransitions().get(0);
        }
        if (nodeClass.equals(EndNodeDef.class)) {
            context.completeJob();
            return null;
        }
        if (nodeClass.equals(KillNodeDef.class)) {
            context.killJob();
            return null;
        }
        if (nodeClass.equals(ForkNodeDef.class)) {
            throw new UnsupportedOperationException();
        }
        if (nodeClass.equals(JoinNodeDef.class)) {
            throw new UnsupportedOperationException();
        }
        throw new IllegalStateException("Invalid node type: " + nodeClass);
    }

    @Override
    public void loopDetection(NodeHandler.Context context) throws WorkflowException {
        Class<?> nodeClass = context.getNodeDef().getClass();
        if (!(nodeClass.equals(StartNodeDef.class) || nodeClass.equals(EndNodeDef.class) || nodeClass.equals(KillNodeDef.class) || nodeClass.equals(ForkNodeDef.class))) {
            if (nodeClass.equals(JoinNodeDef.class)) {
                String flag = ControlNodeHandler.getLoopFlag(context.getNodeDef().getName());
                if (context.getVar(flag) != null) {
                    throw new WorkflowException(ErrorCode.E0709, context.getNodeDef().getName());
                }
                String parentExecutionPath = context.getParentExecutionPath(context.getExecutionPath());
                String forkCount = context.getVar(FORK_COUNT_PREFIX + parentExecutionPath);
                if (forkCount == null) {
                    throw new WorkflowException(ErrorCode.E0720, context.getNodeDef().getName());
                }
                int count = Integer.parseInt(forkCount) - 1;
                if (count == 0) {
                    context.setVar(flag, "true");
                }
            } else {
                throw new IllegalStateException("Invalid node type: " + nodeClass);
            }
        }
    }

    @Override
    public List<String> multiExit(NodeHandler.Context context) throws WorkflowException {
        Class<?> nodeClass = context.getNodeDef().getClass();
        if (nodeClass.equals(StartNodeDef.class)) {
            return super.multiExit(context);
        }
        if (nodeClass.equals(EndNodeDef.class)) {
            return super.multiExit(context);
        }
        if (nodeClass.equals(KillNodeDef.class)) {
            return super.multiExit(context);
        }
        if (nodeClass.equals(ForkNodeDef.class)) {
            List<String> transitions = context.getNodeDef().getTransitions();
            context.setVar(FORK_COUNT_PREFIX + context.getExecutionPath(), "" + transitions.size());
            ArrayList<String> fullTransitions = new ArrayList<String>(transitions.size());
            for (String transition : transitions) {
                String childExecutionPath = context.createExecutionPath(transition);
                String fullTransition = context.createFullTransition(childExecutionPath, transition);
                fullTransitions.add(fullTransition);
            }
            return fullTransitions;
        }
        if (nodeClass.equals(JoinNodeDef.class)) {
            String parentExecutionPath = context.getParentExecutionPath(context.getExecutionPath());
            context.deleteExecutionPath();
            String transition = context.getNodeDef().getTransitions().get(0);
            String fullTransition = context.createFullTransition(parentExecutionPath, transition);
            ArrayList<String> transitions = new ArrayList<String>(1);
            transitions.add(fullTransition);
            return transitions;
        }
        throw new IllegalStateException("Invalid node type: " + nodeClass);
    }

    @Override
    public void kill(NodeHandler.Context context) {
        Class<?> nodeClass = context.getNodeDef().getClass();
        if (!(nodeClass.equals(StartNodeDef.class) || nodeClass.equals(EndNodeDef.class) || nodeClass.equals(KillNodeDef.class) || nodeClass.equals(ForkNodeDef.class) || nodeClass.equals(JoinNodeDef.class))) {
            throw new IllegalStateException("Invalid node type: " + nodeClass);
        }
    }

    @Override
    public void fail(NodeHandler.Context context) {
        Class<?> nodeClass = context.getNodeDef().getClass();
        if (!(nodeClass.equals(StartNodeDef.class) || nodeClass.equals(EndNodeDef.class) || nodeClass.equals(KillNodeDef.class) || nodeClass.equals(ForkNodeDef.class) || nodeClass.equals(JoinNodeDef.class))) {
            throw new IllegalStateException("Invalid node type: " + nodeClass);
        }
    }
}

