/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;

public class RepositoryImpl
implements Repository {
    private URI uri;
    private boolean valid;
    private Features features;

    public RepositoryImpl(URI uri) {
        this.uri = uri;
    }

    @Override
    public String getName() {
        return this.features.getName();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public URI[] getRepositories() throws Exception {
        this.load();
        URI[] result = new URI[this.features.getRepository().size()];
        for (int i = 0; i < this.features.getRepository().size(); ++i) {
            String uri = this.features.getRepository().get(i);
            uri = uri.trim();
            result[i] = URI.create(uri);
        }
        return result;
    }

    @Override
    public Feature[] getFeatures() throws Exception {
        this.load();
        return this.features.getFeature().toArray(new Feature[0]);
    }

    public void load() throws IOException {
        if (this.features == null) {
            try {
                InputStream inputStream = this.uri.toURL().openStream();
                inputStream = new FilterInputStream(inputStream){

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedIOException();
                        }
                        return super.read(b, off, len);
                    }
                };
                try {
                    this.features = JaxbUtil.unmarshal(inputStream, false);
                }
                finally {
                    inputStream.close();
                }
                this.valid = true;
            }
            catch (IllegalArgumentException e) {
                throw (IOException)new IOException(e.getMessage() + " : " + this.uri).initCause(e);
            }
            catch (Exception e) {
                throw (IOException)new IOException(e.getMessage() + " : " + this.uri).initCause(e);
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }
}

