/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.util.ParameterHelper;

public class FlashChartRequestMapper
extends SimpleParameterProvider {
    private IParameterProvider request;
    private final HashMap chartParams = new HashMap();
    private final Set keySet = new HashSet();

    public FlashChartRequestMapper(IParameterProvider request) {
        this.request = request;
        Iterator it = request.getParameterNames();
        while (it.hasNext()) {
            this.keySet.add(it.next());
        }
        boolean isChart = "prochart".equals(request.getStringParameter("client", null));
        if (isChart) {
            String value;
            String seriesName;
            String value2;
            String catName = request.getStringParameter("categoryName", null);
            if (catName != null && (value2 = request.getStringParameter("category", null)) != null) {
                this.chartParams.put(catName, value2);
                this.keySet.add(catName);
                this.keySet.remove("category");
                this.keySet.remove("categoryName");
            }
            if ((seriesName = request.getStringParameter("seriesName", null)) != null && (value = request.getStringParameter("series", null)) != null) {
                this.chartParams.put(seriesName, value);
                this.keySet.add(seriesName);
                this.keySet.remove("series");
                this.keySet.remove("seriesName");
            }
        }
    }

    @Override
    public String getStringParameter(String name, String defaultValue) {
        Object value = this.chartParams.get(name);
        if (value != null) {
            return value.toString();
        }
        return this.request.getStringParameter(name, defaultValue);
    }

    @Override
    public long getLongParameter(String name, long defaultValue) {
        String value = (String)this.chartParams.get(name);
        if (value != null) {
            return ParameterHelper.parameterToLong(value, defaultValue);
        }
        return this.request.getLongParameter(name, defaultValue);
    }

    @Override
    public Date getDateParameter(String name, Date defaultValue) {
        String value = (String)this.chartParams.get(name);
        if (value != null) {
            return ParameterHelper.parameterToDate(value, defaultValue);
        }
        return this.request.getDateParameter(name, defaultValue);
    }

    @Override
    public BigDecimal getDecimalParameter(String name, BigDecimal defaultValue) {
        String value = (String)this.chartParams.get(name);
        if (value != null) {
            return ParameterHelper.parameterToDecimal(value, defaultValue);
        }
        return this.request.getDecimalParameter(name, defaultValue);
    }

    @Override
    public Iterator getParameterNames() {
        return this.keySet.iterator();
    }

    @Override
    public Object getParameter(String name) {
        Object value = this.chartParams.get(name);
        if (value != null) {
            return value;
        }
        return this.request.getParameter(name);
    }
}

