/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl.handlers;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginFileHandler;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginHandlingException;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpringFileHandler
implements PluginFileHandler {
    public static final String LIB_PATTERN = ".+\\/lib\\/.+\\.jar";
    public static final String PLUGIN_SPRING_XML = ".+\\/plugin.spring.xml";
    private final Pattern beanPattern = Pattern.compile(".*id=\"([^\\.]+\\.[^\"]+)\".+[(\\r\\n|\\r|\\n)]*");

    @Override
    public boolean handles(String fileName) {
        return fileName.matches(LIB_PATTERN) || fileName.matches(PLUGIN_SPRING_XML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String relativePath, File file, PluginMetadata pluginMetadata) throws PluginHandlingException {
        if (relativePath.matches(LIB_PATTERN)) {
            FileInputStream fin = null;
            ZipInputStream jarInputStream = null;
            try {
                ZipEntry nextEntry;
                fin = new FileInputStream(file);
                jarInputStream = new JarInputStream(fin);
                while ((nextEntry = ((JarInputStream)jarInputStream).getNextEntry()) != null) {
                    String contents;
                    String name = nextEntry.getName();
                    if (!name.matches(".+\\.xml")) continue;
                    try (ByteArrayOutputStream byteArrayOutputStream = null;){
                        int read;
                        byteArrayOutputStream = new ByteArrayOutputStream((int)Math.min(Integer.MAX_VALUE, Math.max(0L, nextEntry.getSize())));
                        byte[] buffer = new byte[1024];
                        while ((read = jarInputStream.read(buffer)) > 0) {
                            byteArrayOutputStream.write(buffer, 0, read);
                        }
                        contents = byteArrayOutputStream.toString("UTF-8");
                    }
                    if (!contents.contains("http://www.springframework.org/schema/beans")) continue;
                    FileWriter fileWriter = pluginMetadata.getFileWriter("META-INF/spring/" + name);
                    fileWriter.append(contents);
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    jarInputStream.close();
                    fin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (relativePath.matches(PLUGIN_SPRING_XML)) {
            try (BufferedReader fileReader = new BufferedReader(new FileReader(file));
                 FileWriter fileWriter = pluginMetadata.getFileWriter("META-INF/spring/plugin.spring.xml");){
                String[] lines;
                int read;
                ((Reader)fileReader).mark(0);
                StringWriter stringWriter = new StringWriter(4098);
                while ((read = ((Reader)fileReader).read()) != -1) {
                    stringWriter.write(read);
                }
                String contents = stringWriter.toString();
                fileWriter.write(contents);
                for (String s : lines = contents.split("\\n")) {
                    Matcher matcher = this.beanPattern.matcher(s);
                    if (!matcher.matches()) continue;
                    String beanId = matcher.group(1);
                    Document blueprint = pluginMetadata.getBlueprint();
                    Element service = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "service");
                    service.setAttribute("interface", "javax.servlet.Servlet");
                    Element props = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "service-properties");
                    Element entry = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "entry");
                    String[] split = beanId.split("\\.");
                    entry.setAttribute("key", "alias");
                    entry.setAttribute("value", "/content/analyzer/" + split[1]);
                    props.appendChild(entry);
                    entry = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "entry");
                    entry.setAttribute("key", "servlet-name");
                    entry.setAttribute("value", beanId);
                    service.appendChild(props);
                    Element bean = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "bean");
                    bean.setAttribute("class", "org.pentaho.platform.pdi.ContentGeneratorServlet");
                    Element argument = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "argument");
                    argument.setAttribute("ref", "spring");
                    bean.appendChild(argument);
                    argument = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "argument");
                    argument.setAttribute("value", beanId);
                    bean.appendChild(argument);
                    service.appendChild(bean);
                    blueprint.getDocumentElement().appendChild(service);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

