/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl;

import java.util.List;
import java.util.Map;
import org.json.simple.JSONValue;

public class JSONUtil {
    public String prettyPrintMapStringListString(Map<String, List<String>> map) {
        StringBuilder sb = new StringBuilder();
        this.appendOpen(sb);
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            this.writeKeyAndSeparator(sb, entry.getKey(), 2);
            this.writeListOfStrings(sb, entry.getValue(), 4);
            sb.append(",\n");
        }
        if (map.size() > 0) {
            sb.setLength(sb.length() - 2);
        }
        this.appendClose(sb);
        return sb.toString();
    }

    public String prettyPrintMapStringString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        this.appendOpen(sb);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.writeKeyAndSeparator(sb, entry.getKey(), 2);
            sb.append(JSONValue.toJSONString((Object)entry.getValue()));
            sb.append(",\n");
        }
        if (map.size() > 0) {
            sb.setLength(sb.length() - 2);
        }
        this.appendClose(sb);
        return sb.toString();
    }

    private void appendOpen(StringBuilder stringBuilder) {
        stringBuilder.append("{\n");
    }

    private void appendClose(StringBuilder stringBuilder) {
        stringBuilder.append("\n}\n");
    }

    private void writeKeyAndSeparator(StringBuilder stringBuilder, String key, int spaceBefore) {
        for (int i = 0; i < spaceBefore; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(JSONValue.toJSONString((Object)key));
        stringBuilder.append(" : ");
    }

    private void writeListOfStrings(StringBuilder stringBuilder, List<String> list, int spaceBefore) {
        stringBuilder.append("[ \n");
        for (String entry : list) {
            for (int i = 0; i < spaceBefore; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(JSONValue.toJSONString((Object)entry));
            stringBuilder.append(",\n");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        stringBuilder.append(" ]");
    }
}

