/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.replacestring;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.replacestring.ReplaceString;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="ReplaceString.Injection.", groups={"FIELDS"})
public class ReplaceStringMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ReplaceStringMeta.class;
    @Injection(name="FIELD_IN_STREAM", group="FIELDS")
    private String[] fieldInStream;
    @Injection(name="FIELD_OUT_STREAM", group="FIELDS")
    private String[] fieldOutStream;
    @Injection(name="USE_REGEX", group="FIELDS")
    private int[] useRegEx;
    @Injection(name="REPLACE_STRING", group="FIELDS")
    private String[] replaceString;
    @Injection(name="REPLACE_BY", group="FIELDS")
    private String[] replaceByString;
    @Injection(name="EMPTY_STRING", group="FIELDS")
    private boolean[] setEmptyString;
    @Injection(name="REPLACE_WITH_FIELD", group="FIELDS")
    private String[] replaceFieldByString;
    @Injection(name="REPLACE_WHOLE_WORD", group="FIELDS")
    private int[] wholeWord;
    @Injection(name="CASE_SENSITIVE", group="FIELDS")
    private int[] caseSensitive;
    public static final String[] caseSensitiveCode = new String[]{"no", "yes"};
    public static final String[] caseSensitiveDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final int CASE_SENSITIVE_NO = 0;
    public static final int CASE_SENSITIVE_YES = 1;
    public static final String[] wholeWordDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] wholeWordCode = new String[]{"no", "yes"};
    public static final int WHOLE_WORD_NO = 0;
    public static final int WHOLE_WORD_YES = 1;
    public static final String[] useRegExDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] useRegExCode = new String[]{"no", "yes"};
    public static final int USE_REGEX_NO = 0;
    public static final int USE_REGEX_YES = 1;

    public String[] getFieldInStream() {
        return this.fieldInStream;
    }

    public void setFieldInStream(String[] keyStream) {
        this.fieldInStream = keyStream;
    }

    public int[] getCaseSensitive() {
        return this.caseSensitive;
    }

    public int[] getWholeWord() {
        return this.wholeWord;
    }

    public void setWholeWord(int[] wholeWord) {
        this.wholeWord = wholeWord;
    }

    public int[] getUseRegEx() {
        return this.useRegEx;
    }

    public void setUseRegEx(int[] useRegEx) {
        this.useRegEx = useRegEx;
    }

    public boolean[] isSetEmptyString() {
        return this.setEmptyString;
    }

    public void setEmptyString(boolean[] setEmptyString) {
        this.setEmptyString = setEmptyString;
    }

    public String[] getFieldOutStream() {
        return this.fieldOutStream;
    }

    public void setFieldOutStream(String[] keyStream) {
        this.fieldOutStream = keyStream;
    }

    public String[] getReplaceString() {
        return this.replaceString;
    }

    public void setReplaceString(String[] replaceString) {
        this.replaceString = replaceString;
    }

    public String[] getReplaceByString() {
        return this.replaceByString;
    }

    public void setReplaceByString(String[] replaceByString) {
        this.replaceByString = replaceByString;
    }

    public String[] getFieldReplaceByString() {
        return this.replaceFieldByString;
    }

    public void setFieldReplaceByString(String[] replaceFieldByString) {
        this.replaceFieldByString = replaceFieldByString;
    }

    public void setCaseSensitive(int[] caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys) {
        this.fieldInStream = new String[nrkeys];
        this.fieldOutStream = new String[nrkeys];
        this.useRegEx = new int[nrkeys];
        this.replaceString = new String[nrkeys];
        this.replaceByString = new String[nrkeys];
        this.setEmptyString = new boolean[nrkeys];
        this.replaceFieldByString = new String[nrkeys];
        this.wholeWord = new int[nrkeys];
        this.caseSensitive = new int[nrkeys];
    }

    @Override
    public Object clone() {
        ReplaceStringMeta retval = (ReplaceStringMeta)super.clone();
        int nrkeys = this.fieldInStream.length;
        retval.allocate(nrkeys);
        System.arraycopy(this.fieldInStream, 0, retval.fieldInStream, 0, nrkeys);
        System.arraycopy(this.fieldOutStream, 0, retval.fieldOutStream, 0, nrkeys);
        System.arraycopy(this.useRegEx, 0, retval.useRegEx, 0, nrkeys);
        System.arraycopy(this.replaceString, 0, retval.replaceString, 0, nrkeys);
        System.arraycopy(this.replaceByString, 0, retval.replaceByString, 0, nrkeys);
        System.arraycopy(this.setEmptyString, 0, retval.setEmptyString, 0, nrkeys);
        System.arraycopy(this.replaceFieldByString, 0, retval.replaceFieldByString, 0, nrkeys);
        System.arraycopy(this.wholeWord, 0, retval.wholeWord, 0, nrkeys);
        System.arraycopy(this.caseSensitive, 0, retval.caseSensitive, 0, nrkeys);
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"field");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"field", (int)i);
                this.fieldInStream[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"in_stream_name"), (String)"");
                this.fieldOutStream[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"out_stream_name"), (String)"");
                this.useRegEx[i] = ReplaceStringMeta.getCaseSensitiveByCode(Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"use_regex"), (String)""));
                this.replaceString[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"replace_string"), (String)"");
                this.replaceByString[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"replace_by_string"), (String)"");
                String emptyString = XMLHandler.getTagValue((Node)fnode, (String)"set_empty_string");
                this.setEmptyString[i] = !Utils.isEmpty((CharSequence)emptyString) && "Y".equalsIgnoreCase(emptyString);
                this.replaceFieldByString[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"replace_field_by_string"), (String)"");
                this.wholeWord[i] = ReplaceStringMeta.getWholeWordByCode(Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"whole_word"), (String)""));
                this.caseSensitive[i] = ReplaceStringMeta.getCaseSensitiveByCode(Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"case_sensitive"), (String)""));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"ReplaceStringMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.fieldInStream = null;
        this.fieldOutStream = null;
        int nrkeys = 0;
        this.allocate(nrkeys);
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldInStream.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"in_stream_name", (String)this.fieldInStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"out_stream_name", (String)this.fieldOutStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"use_regex", (String)ReplaceStringMeta.getUseRegExCode(this.useRegEx[i])));
            retval.append("        ").append(XMLHandler.addTagValue((String)"replace_string", (String)this.replaceString[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"replace_by_string", (String)this.replaceByString[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"set_empty_string", (boolean)this.setEmptyString[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"replace_field_by_string", (String)this.replaceFieldByString[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"whole_word", (String)ReplaceStringMeta.getWholeWordCode(this.wholeWord[i])));
            retval.append("        ").append(XMLHandler.addTagValue((String)"case_sensitive", (String)ReplaceStringMeta.getCaseSensitiveCode(this.caseSensitive[i])));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrkeys = rep.countNrStepAttributes(id_step, "in_stream_name");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                this.fieldInStream[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "in_stream_name"), (String)"");
                this.fieldOutStream[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "out_stream_name"), (String)"");
                this.useRegEx[i] = ReplaceStringMeta.getCaseSensitiveByCode(Const.NVL((String)rep.getStepAttributeString(id_step, i, "use_regex"), (String)""));
                this.replaceString[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "replace_string"), (String)"");
                this.replaceByString[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "replace_by_string"), (String)"");
                this.setEmptyString[i] = rep.getStepAttributeBoolean(id_step, i, "set_empty_string", false);
                this.replaceFieldByString[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "replace_field_by_string"), (String)"");
                this.wholeWord[i] = ReplaceStringMeta.getWholeWordByCode(Const.NVL((String)rep.getStepAttributeString(id_step, i, "whole_world"), (String)""));
                this.caseSensitive[i] = ReplaceStringMeta.getCaseSensitiveByCode(Const.NVL((String)rep.getStepAttributeString(id_step, i, "case_sensitive"), (String)""));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ReplaceStringMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldInStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "in_stream_name", this.fieldInStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "out_stream_name", this.fieldOutStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "use_regex", ReplaceStringMeta.getUseRegExCode(this.useRegEx[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "replace_string", this.replaceString[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "replace_by_string", this.replaceByString[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "set_empty_string", this.setEmptyString[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "replace_field_by_string", this.replaceFieldByString[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "whole_world", ReplaceStringMeta.getWholeWordCode(this.wholeWord[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "case_sensitive", ReplaceStringMeta.getCaseSensitiveCode(this.caseSensitive[i]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ReplaceStringMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        int nrFields = this.fieldInStream == null ? 0 : this.fieldInStream.length;
        for (int i = 0; i < nrFields; ++i) {
            ValueMetaString valueMeta;
            String fieldName = space.environmentSubstitute(this.fieldOutStream[i]);
            if (!Utils.isEmpty((CharSequence)this.fieldOutStream[i])) {
                valueMeta = new ValueMetaString(fieldName);
                valueMeta.setOrigin(name);
                ValueMetaInterface sourceField = inputRowMeta.searchValueMeta(this.fieldInStream[i]);
                if (sourceField != null) {
                    valueMeta.setStringEncoding(sourceField.getStringEncoding());
                }
                inputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
                continue;
            }
            valueMeta = inputRowMeta.searchValueMeta(this.fieldInStream[i]);
            if (valueMeta == null) continue;
            valueMeta.setStorageType(0);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        String error_message = "";
        boolean first = true;
        boolean error_found = false;
        if (prev == null) {
            error_message = error_message + BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.NoInputReceived", (String[])new String[0]) + Const.CR;
            CheckResult cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            int idx;
            ValueMetaInterface v;
            String field;
            int i;
            for (i = 0; i < this.fieldInStream.length; ++i) {
                field = this.fieldInStream[i];
                v = prev.searchValueMeta(field);
                if (v != null) continue;
                if (first) {
                    first = false;
                    error_message = error_message + BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.MissingInStreamFields", (String[])new String[0]) + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + field + Const.CR;
            }
            CheckResult cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.FoundInStreamFields", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            first = true;
            error_found = false;
            for (i = 0; i < this.fieldInStream.length; ++i) {
                field = this.fieldInStream[i];
                v = prev.searchValueMeta(field);
                if (v == null || v.getType() == 2) continue;
                if (first) {
                    first = false;
                    error_message = error_message + BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.OperationOnNonStringFields", (String[])new String[0]) + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + field + Const.CR;
            }
            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.AllOperationsOnStringFields", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            if (this.fieldInStream.length > 0) {
                for (idx = 0; idx < this.fieldInStream.length; ++idx) {
                    if (!Utils.isEmpty((CharSequence)this.fieldInStream[idx])) continue;
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.InStreamFieldMissing", (String[])new String[]{new Integer(idx + 1).toString()}), (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            for (idx = 0; idx < this.fieldInStream.length; ++idx) {
                for (int jdx = 0; jdx < this.fieldInStream.length; ++jdx) {
                    if (!this.fieldInStream[idx].equals(this.fieldInStream[jdx]) || idx == jdx || idx >= jdx) continue;
                    error_message = BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.FieldInputError", (String[])new String[]{this.fieldInStream[idx]});
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ReplaceString(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ReplaceStringData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    private static String getCaseSensitiveCode(int i) {
        if (i < 0 || i >= caseSensitiveCode.length) {
            return caseSensitiveCode[0];
        }
        return caseSensitiveCode[i];
    }

    private static String getWholeWordCode(int i) {
        if (i < 0 || i >= wholeWordCode.length) {
            return wholeWordCode[0];
        }
        return wholeWordCode[i];
    }

    private static String getUseRegExCode(int i) {
        if (i < 0 || i >= useRegExCode.length) {
            return useRegExCode[0];
        }
        return useRegExCode[i];
    }

    public static String getCaseSensitiveDesc(int i) {
        if (i < 0 || i >= caseSensitiveDesc.length) {
            return caseSensitiveDesc[0];
        }
        return caseSensitiveDesc[i];
    }

    public static String getWholeWordDesc(int i) {
        if (i < 0 || i >= wholeWordDesc.length) {
            return wholeWordDesc[0];
        }
        return wholeWordDesc[i];
    }

    public static String getUseRegExDesc(int i) {
        if (i < 0 || i >= useRegExDesc.length) {
            return useRegExDesc[0];
        }
        return useRegExDesc[i];
    }

    private static int getCaseSensitiveByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < caseSensitiveCode.length; ++i) {
            if (!caseSensitiveCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getWholeWordByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < wholeWordCode.length; ++i) {
            if (!wholeWordCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getRegExByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < useRegExCode.length; ++i) {
            if (!useRegExCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static int getCaseSensitiveByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < caseSensitiveDesc.length; ++i) {
            if (!caseSensitiveDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ReplaceStringMeta.getCaseSensitiveByCode(tt);
    }

    public static int getWholeWordByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < wholeWordDesc.length; ++i) {
            if (!wholeWordDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ReplaceStringMeta.getWholeWordByCode(tt);
    }

    public static int getUseRegExByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < useRegExDesc.length; ++i) {
            if (!useRegExDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ReplaceStringMeta.getRegExByCode(tt);
    }
}

