/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.groupby;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.groupby.GroupBy;
import org.pentaho.di.trans.steps.groupby.GroupByData;
import org.pentaho.di.trans.steps.groupby.GroupByMetaInjection;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class GroupByMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GroupByMeta.class;
    public static final int TYPE_GROUP_NONE = 0;
    public static final int TYPE_GROUP_SUM = 1;
    public static final int TYPE_GROUP_AVERAGE = 2;
    public static final int TYPE_GROUP_MEDIAN = 3;
    public static final int TYPE_GROUP_PERCENTILE = 4;
    public static final int TYPE_GROUP_MIN = 5;
    public static final int TYPE_GROUP_MAX = 6;
    public static final int TYPE_GROUP_COUNT_ALL = 7;
    public static final int TYPE_GROUP_CONCAT_COMMA = 8;
    public static final int TYPE_GROUP_FIRST = 9;
    public static final int TYPE_GROUP_LAST = 10;
    public static final int TYPE_GROUP_FIRST_INCL_NULL = 11;
    public static final int TYPE_GROUP_LAST_INCL_NULL = 12;
    public static final int TYPE_GROUP_CUMULATIVE_SUM = 13;
    public static final int TYPE_GROUP_CUMULATIVE_AVERAGE = 14;
    public static final int TYPE_GROUP_STANDARD_DEVIATION = 15;
    public static final int TYPE_GROUP_CONCAT_STRING = 16;
    public static final int TYPE_GROUP_COUNT_DISTINCT = 17;
    public static final int TYPE_GROUP_COUNT_ANY = 18;
    public static final String[] typeGroupCode = new String[]{"-", "SUM", "AVERAGE", "MEDIAN", "PERCENTILE", "MIN", "MAX", "COUNT_ALL", "CONCAT_COMMA", "FIRST", "LAST", "FIRST_INCL_NULL", "LAST_INCL_NULL", "CUM_SUM", "CUM_AVG", "STD_DEV", "CONCAT_STRING", "COUNT_DISTINCT", "COUNT_ANY"};
    public static final String[] typeGroupLongDesc = new String[]{"-", BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.SUM", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.AVERAGE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.MEDIAN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.PERCENTILE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.MIN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.MAX", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_ALL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_COMMA", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.FIRST", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.LAST", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.FIRST_INCL_NULL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.LAST_INCL_NULL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CUMUMALTIVE_SUM", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CUMUMALTIVE_AVERAGE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.STANDARD_DEVIATION", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_STRING", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.COUNT_DISTINCT", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.COUNT_ANY", (String[])new String[0])};
    private boolean passAllRows;
    private String directory;
    private String prefix;
    private boolean aggregateIgnored;
    private String aggregateIgnoredField;
    private String[] groupField;
    private String[] aggregateField;
    private String[] subjectField;
    private int[] aggregateType;
    private String[] valueField;
    private boolean addingLineNrInGroup;
    private String lineNrInGroupField;
    private boolean alwaysGivingBackOneRow;

    public String[] getAggregateField() {
        return this.aggregateField;
    }

    public void setAggregateField(String[] aggregateField) {
        this.aggregateField = aggregateField;
    }

    public boolean isAggregateIgnored() {
        return this.aggregateIgnored;
    }

    public void setAggregateIgnored(boolean aggregateIgnored) {
        this.aggregateIgnored = aggregateIgnored;
    }

    public String getAggregateIgnoredField() {
        return this.aggregateIgnoredField;
    }

    public void setAggregateIgnoredField(String aggregateIgnoredField) {
        this.aggregateIgnoredField = aggregateIgnoredField;
    }

    public int[] getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(int[] aggregateType) {
        this.aggregateType = aggregateType;
    }

    public String[] getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String[] groupField) {
        this.groupField = groupField;
    }

    public boolean passAllRows() {
        return this.passAllRows;
    }

    public void setPassAllRows(boolean passAllRows) {
        this.passAllRows = passAllRows;
    }

    public String[] getSubjectField() {
        return this.subjectField;
    }

    public void setSubjectField(String[] subjectField) {
        this.subjectField = subjectField;
    }

    public String[] getValueField() {
        return this.valueField;
    }

    public void setValueField(String[] valueField) {
        this.valueField = valueField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int sizegroup, int nrfields) {
        this.groupField = new String[sizegroup];
        this.aggregateField = new String[nrfields];
        this.subjectField = new String[nrfields];
        this.aggregateType = new int[nrfields];
        this.valueField = new String[nrfields];
    }

    @Override
    public Object clone() {
        GroupByMeta retval = (GroupByMeta)super.clone();
        int szGroup = 0;
        int szFields = 0;
        if (this.groupField != null) {
            szGroup = this.groupField.length;
        }
        if (this.valueField != null) {
            szFields = this.valueField.length;
        }
        retval.allocate(szGroup, szFields);
        System.arraycopy(this.groupField, 0, retval.groupField, 0, szGroup);
        System.arraycopy(this.aggregateField, 0, retval.aggregateField, 0, szFields);
        System.arraycopy(this.subjectField, 0, retval.subjectField, 0, szFields);
        System.arraycopy(this.aggregateType, 0, retval.aggregateType, 0, szFields);
        System.arraycopy(this.valueField, 0, retval.valueField, 0, szFields);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.passAllRows = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"all_rows"));
            this.aggregateIgnored = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"ignore_aggregate"));
            this.aggregateIgnoredField = XMLHandler.getTagValue((Node)stepnode, (String)"field_ignore");
            this.directory = XMLHandler.getTagValue((Node)stepnode, (String)"directory");
            this.prefix = XMLHandler.getTagValue((Node)stepnode, (String)"prefix");
            this.addingLineNrInGroup = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"add_linenr"));
            this.lineNrInGroupField = XMLHandler.getTagValue((Node)stepnode, (String)"linenr_fieldname");
            Node groupn = XMLHandler.getSubNode((Node)stepnode, (String)"group");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int sizegroup = XMLHandler.countNodes((Node)groupn, (String)"field");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(sizegroup, nrfields);
            for (int i = 0; i < sizegroup; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)groupn, (String)"field", (int)i);
                this.groupField[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
            boolean hasNumberOfValues = false;
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.aggregateField[i] = XMLHandler.getTagValue((Node)fnode, (String)"aggregate");
                this.subjectField[i] = XMLHandler.getTagValue((Node)fnode, (String)"subject");
                this.aggregateType[i] = GroupByMeta.getType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                if (this.aggregateType[i] == 7 || this.aggregateType[i] == 17 || this.aggregateType[i] == 18) {
                    hasNumberOfValues = true;
                }
                this.valueField[i] = XMLHandler.getTagValue((Node)fnode, (String)"valuefield");
            }
            String giveBackRow = XMLHandler.getTagValue((Node)stepnode, (String)"give_back_row");
            this.alwaysGivingBackOneRow = Utils.isEmpty((CharSequence)giveBackRow) ? hasNumberOfValues : "Y".equalsIgnoreCase(giveBackRow);
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"GroupByMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public static final int getType(String desc) {
        int i;
        for (i = 0; i < typeGroupCode.length; ++i) {
            if (!typeGroupCode[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        for (i = 0; i < typeGroupLongDesc.length; ++i) {
            if (!typeGroupLongDesc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeDesc(int i) {
        if (i < 0 || i >= typeGroupCode.length) {
            return null;
        }
        return typeGroupCode[i];
    }

    public static final String getTypeDescLong(int i) {
        if (i < 0 || i >= typeGroupLongDesc.length) {
            return null;
        }
        return typeGroupLongDesc[i];
    }

    @Override
    public void setDefault() {
        this.directory = "%%java.io.tmpdir%%";
        this.prefix = "grp";
        this.passAllRows = false;
        this.aggregateIgnored = false;
        this.aggregateIgnoredField = null;
        int sizeGroup = 0;
        int numberOfFields = 0;
        this.allocate(sizeGroup, numberOfFields);
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) {
        int i;
        RowMeta fields = new RowMeta();
        if (!this.passAllRows) {
            for (i = 0; i < this.groupField.length; ++i) {
                ValueMetaInterface valueMeta = rowMeta.searchValueMeta(this.groupField[i]);
                if (valueMeta == null) continue;
                fields.addValueMeta(valueMeta);
            }
        } else {
            fields.addRowMeta(rowMeta);
        }
        for (i = 0; i < this.subjectField.length; ++i) {
            ValueMetaInterface subj = rowMeta.searchValueMeta(this.subjectField[i]);
            if (subj == null && this.aggregateType[i] != 18) continue;
            String valueName = this.aggregateField[i];
            int valueType = 0;
            int length = -1;
            int precision = -1;
            switch (this.aggregateType[i]) {
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    valueType = subj.getType();
                    break;
                }
                case 7: 
                case 17: 
                case 18: {
                    valueType = 5;
                    break;
                }
                case 8: {
                    valueType = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 15: {
                    valueType = 1;
                    break;
                }
                case 16: {
                    valueType = 2;
                    break;
                }
            }
            if (this.aggregateType[i] == 14 && valueType == 5) {
                valueType = 1;
                precision = -1;
                length = -1;
            } else if (this.aggregateType[i] == 7 || this.aggregateType[i] == 17 || this.aggregateType[i] == 18) {
                length = 10;
                precision = 0;
            } else if (this.aggregateType[i] == 1 && valueType != 5 && valueType != 1 && valueType != 6) {
                valueType = 1;
                precision = -1;
                length = -1;
            }
            if (valueType == 0) continue;
            ValueMeta v = new ValueMeta(valueName, valueType);
            v.setOrigin(origin);
            v.setLength(length, precision);
            fields.addValueMeta((ValueMetaInterface)v);
        }
        if (this.passAllRows && this.addingLineNrInGroup && !Utils.isEmpty((CharSequence)this.lineNrInGroupField)) {
            ValueMetaInteger lineNr = new ValueMetaInteger(this.lineNrInGroupField);
            lineNr.setLength(10, 0);
            lineNr.setOrigin(origin);
            fields.addValueMeta((ValueMetaInterface)lineNr);
        }
        rowMeta.clear();
        rowMeta.addRowMeta((RowMetaInterface)fields);
    }

    @Override
    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder(500);
        retval.append("      ").append(XMLHandler.addTagValue((String)"all_rows", (boolean)this.passAllRows));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ignore_aggregate", (boolean)this.aggregateIgnored));
        retval.append("      ").append(XMLHandler.addTagValue((String)"field_ignore", (String)this.aggregateIgnoredField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"prefix", (String)this.prefix));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_linenr", (boolean)this.addingLineNrInGroup));
        retval.append("      ").append(XMLHandler.addTagValue((String)"linenr_fieldname", (String)this.lineNrInGroupField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"give_back_row", (boolean)this.alwaysGivingBackOneRow));
        retval.append("      <group>").append(Const.CR);
        for (i = 0; i < this.groupField.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.groupField[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </group>").append(Const.CR);
        retval.append("      <fields>").append(Const.CR);
        for (i = 0; i < this.subjectField.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"aggregate", (String)this.aggregateField[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"subject", (String)this.subjectField[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"type", (String)GroupByMeta.getTypeDesc(this.aggregateType[i])));
            retval.append("          ").append(XMLHandler.addTagValue((String)"valuefield", (String)this.valueField[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.passAllRows = rep.getStepAttributeBoolean(id_step, "all_rows");
            this.aggregateIgnored = rep.getStepAttributeBoolean(id_step, "ignore_aggregate");
            this.aggregateIgnoredField = rep.getStepAttributeString(id_step, "field_ignore");
            this.directory = rep.getStepAttributeString(id_step, "directory");
            this.prefix = rep.getStepAttributeString(id_step, "prefix");
            this.addingLineNrInGroup = rep.getStepAttributeBoolean(id_step, "add_linenr");
            this.lineNrInGroupField = rep.getStepAttributeString(id_step, "linenr_fieldname");
            int groupsize = rep.countNrStepAttributes(id_step, "group_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "aggregate_name");
            this.allocate(groupsize, nrvalues);
            for (int i = 0; i < groupsize; ++i) {
                this.groupField[i] = rep.getStepAttributeString(id_step, i, "group_name");
            }
            boolean hasNumberOfValues = false;
            for (int i = 0; i < nrvalues; ++i) {
                this.aggregateField[i] = rep.getStepAttributeString(id_step, i, "aggregate_name");
                this.subjectField[i] = rep.getStepAttributeString(id_step, i, "aggregate_subject");
                this.aggregateType[i] = GroupByMeta.getType(rep.getStepAttributeString(id_step, i, "aggregate_type"));
                if (this.aggregateType[i] == 7 || this.aggregateType[i] == 17 || this.aggregateType[i] == 18) {
                    hasNumberOfValues = true;
                }
                this.valueField[i] = rep.getStepAttributeString(id_step, i, "aggregate_value_field");
            }
            this.alwaysGivingBackOneRow = rep.getStepAttributeBoolean(id_step, 0, "give_back_row", hasNumberOfValues);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GroupByMeta.Exception.UnexpectedErrorInReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "all_rows", this.passAllRows);
            rep.saveStepAttribute(id_transformation, id_step, "ignore_aggregate", this.aggregateIgnored);
            rep.saveStepAttribute(id_transformation, id_step, "field_ignore", this.aggregateIgnoredField);
            rep.saveStepAttribute(id_transformation, id_step, "directory", this.directory);
            rep.saveStepAttribute(id_transformation, id_step, "prefix", this.prefix);
            rep.saveStepAttribute(id_transformation, id_step, "add_linenr", this.addingLineNrInGroup);
            rep.saveStepAttribute(id_transformation, id_step, "linenr_fieldname", this.lineNrInGroupField);
            rep.saveStepAttribute(id_transformation, id_step, "give_back_row", this.alwaysGivingBackOneRow);
            for (i = 0; i < this.groupField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "group_name", this.groupField[i]);
            }
            for (i = 0; i < this.subjectField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_name", this.aggregateField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_subject", this.subjectField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_type", GroupByMeta.getTypeDesc(this.aggregateType[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_value_field", this.valueField[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GroupByMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GroupByMeta.CheckResult.ReceivingInfoOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GroupByMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GroupBy(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GroupByData();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isAddingLineNrInGroup() {
        return this.addingLineNrInGroup;
    }

    public void setAddingLineNrInGroup(boolean addingLineNrInGroup) {
        this.addingLineNrInGroup = addingLineNrInGroup;
    }

    public String getLineNrInGroupField() {
        return this.lineNrInGroupField;
    }

    public void setLineNrInGroupField(String lineNrInGroupField) {
        this.lineNrInGroupField = lineNrInGroupField;
    }

    public boolean isAlwaysGivingBackOneRow() {
        return this.alwaysGivingBackOneRow;
    }

    public void setAlwaysGivingBackOneRow(boolean alwaysGivingBackOneRow) {
        this.alwaysGivingBackOneRow = alwaysGivingBackOneRow;
    }

    @Override
    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return new GroupByMetaInjection(this);
    }

    @Override
    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal};
    }
}

