/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dbproc;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dbproc.DBProc;
import org.pentaho.di.trans.steps.dbproc.DBProcData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class DBProcMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = DBProcMeta.class;
    private DatabaseMeta database;
    private String procedure;
    private String[] argument;
    private String[] argumentDirection;
    private int[] argumentType;
    private String resultName;
    private int resultType;
    private boolean autoCommit;

    public String[] getArgument() {
        return this.argument;
    }

    public void setArgument(String[] argument) {
        this.argument = argument;
    }

    public String[] getArgumentDirection() {
        return this.argumentDirection;
    }

    public void setArgumentDirection(String[] argumentDirection) {
        this.argumentDirection = argumentDirection;
    }

    public int[] getArgumentType() {
        return this.argumentType;
    }

    public void setArgumentType(int[] argumentType) {
        this.argumentType = argumentType;
    }

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName;
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrargs) {
        this.argument = new String[nrargs];
        this.argumentDirection = new String[nrargs];
        this.argumentType = new int[nrargs];
    }

    @Override
    public Object clone() {
        DBProcMeta retval = (DBProcMeta)super.clone();
        int nrargs = this.argument.length;
        retval.allocate(nrargs);
        System.arraycopy(this.argument, 0, retval.argument, 0, nrargs);
        System.arraycopy(this.argumentDirection, 0, retval.argumentDirection, 0, nrargs);
        System.arraycopy(this.argumentType, 0, retval.argumentType, 0, nrargs);
        return retval;
    }

    @Override
    public void setDefault() {
        this.database = null;
        int nrargs = 0;
        this.allocate(nrargs);
        for (int i = 0; i < nrargs; ++i) {
            this.argument[i] = "arg" + i;
            this.argumentDirection[i] = "IN";
            this.argumentType[i] = 1;
        }
        this.resultName = "result";
        this.resultType = 1;
        this.autoCommit = true;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (!Utils.isEmpty((CharSequence)this.resultName)) {
            ValueMeta v = new ValueMeta(this.resultName, this.resultType);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        for (int i = 0; i < this.argument.length; ++i) {
            if (!this.argumentDirection[i].equalsIgnoreCase("OUT")) continue;
            ValueMeta v = new ValueMeta(this.argument[i], this.argumentType[i]);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.database == null ? "" : this.database.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"procedure", (String)this.procedure));
        retval.append("    <lookup>").append(Const.CR);
        for (int i = 0; i < this.argument.length; ++i) {
            retval.append("      <arg>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.argument[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"direction", (String)this.argumentDirection[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.argumentType[i])));
            retval.append("      </arg>").append(Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        retval.append("    <result>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.resultName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.resultType)));
        retval.append("    </result>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"auto_commit", (boolean)this.autoCommit));
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.database = DatabaseMeta.findDatabase(databases, (String)con);
            this.procedure = XMLHandler.getTagValue((Node)stepnode, (String)"procedure");
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrargs = XMLHandler.countNodes((Node)lookup, (String)"arg");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                Node anode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"arg", (int)i);
                this.argument[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
                this.argumentDirection[i] = XMLHandler.getTagValue((Node)anode, (String)"direction");
                this.argumentType[i] = ValueMeta.getType((String)XMLHandler.getTagValue((Node)anode, (String)"type"));
            }
            this.resultName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"name");
            this.resultType = ValueMeta.getType((String)XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"type"));
            this.autoCommit = !"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"auto_commit"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"DBProcMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.database = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.procedure = rep.getStepAttributeString(id_step, "procedure");
            int nrargs = rep.countNrStepAttributes(id_step, "arg_name");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                this.argument[i] = rep.getStepAttributeString(id_step, i, "arg_name");
                this.argumentDirection[i] = rep.getStepAttributeString(id_step, i, "arg_direction");
                this.argumentType[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "arg_type"));
            }
            this.resultName = rep.getStepAttributeString(id_step, "result_name");
            this.resultType = ValueMeta.getType((String)rep.getStepAttributeString(id_step, "result_type"));
            this.autoCommit = rep.getStepAttributeBoolean(id_step, 0, "auto_commit", true);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DBProcMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.database);
            rep.saveStepAttribute(id_transformation, id_step, "procedure", this.procedure);
            for (int i = 0; i < this.argument.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "arg_name", this.argument[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "arg_direction", this.argumentDirection[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "arg_type", ValueMeta.getTypeDesc((int)this.argumentType[i]));
            }
            rep.saveStepAttribute(id_transformation, id_step, "result_name", this.resultName);
            rep.saveStepAttribute(id_transformation, id_step, "result_type", ValueMeta.getTypeDesc((int)this.resultType));
            rep.saveStepAttribute(id_transformation, id_step, "auto_commit", this.autoCommit);
            if (this.database != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.database.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DBProcMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        block10: {
            String error_message = "";
            if (this.database != null) {
                Database db = new Database((LoggingObjectInterface)transMeta, this.database);
                try {
                    db.connect();
                    if (prev != null && prev.size() > 0) {
                        boolean first = true;
                        error_message = "";
                        boolean error_found = false;
                        for (int i = 0; i < this.argument.length; ++i) {
                            ValueMetaInterface v = prev.searchValueMeta(this.argument[i]);
                            if (v == null) {
                                if (first) {
                                    first = false;
                                    error_message = error_message + BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.MissingArguments", (String[])new String[0]) + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + this.argument[i] + Const.CR;
                                continue;
                            }
                            if (v.getType() == this.argumentType[i] || v.isNumeric() && ValueMeta.isNumeric((int)this.argumentType[i])) continue;
                            error_found = true;
                            error_message = error_message + "\t\t" + this.argument[i] + BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.WrongTypeArguments", (String[])new String[]{v.getTypeDesc(), ValueMeta.getTypeDesc((int)this.argumentType[i])}) + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.AllArgumentsOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        break block10;
                    }
                    error_message = BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.CouldNotReadFields", (String[])new String[0]) + Const.CR;
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                catch (KettleException e) {
                    error_message = BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                error_message = BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.InvalidConnection", (String[])new String[0]);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DBProcMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new DBProc(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DBProcData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.database != null) {
            return new DatabaseMeta[]{this.database};
        }
        return super.getUsedDatabaseConnections();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

