/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.calculator;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.trans.steps.calculator.CalculatorMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class CalculatorMetaFunction
implements Cloneable {
    private static Class<?> PKG = CalculatorMeta.class;
    public static final String XML_TAG = "calculation";
    public static final int CALC_NONE = 0;
    public static final int CALC_CONSTANT = 1;
    public static final int CALC_COPY_OF_FIELD = 2;
    public static final int CALC_ADD = 3;
    public static final int CALC_SUBTRACT = 4;
    public static final int CALC_MULTIPLY = 5;
    public static final int CALC_DIVIDE = 6;
    public static final int CALC_SQUARE = 7;
    public static final int CALC_SQUARE_ROOT = 8;
    public static final int CALC_PERCENT_1 = 9;
    public static final int CALC_PERCENT_2 = 10;
    public static final int CALC_PERCENT_3 = 11;
    public static final int CALC_COMBINATION_1 = 12;
    public static final int CALC_COMBINATION_2 = 13;
    public static final int CALC_ROUND_1 = 14;
    public static final int CALC_ROUND_2 = 15;
    public static final int CALC_ROUND_STD_1 = 16;
    public static final int CALC_ROUND_STD_2 = 17;
    public static final int CALC_CEIL = 18;
    public static final int CALC_FLOOR = 19;
    public static final int CALC_NVL = 20;
    public static final int CALC_ADD_DAYS = 21;
    public static final int CALC_YEAR_OF_DATE = 22;
    public static final int CALC_MONTH_OF_DATE = 23;
    public static final int CALC_DAY_OF_YEAR = 24;
    public static final int CALC_DAY_OF_MONTH = 25;
    public static final int CALC_DAY_OF_WEEK = 26;
    public static final int CALC_WEEK_OF_YEAR = 27;
    public static final int CALC_WEEK_OF_YEAR_ISO8601 = 28;
    public static final int CALC_YEAR_OF_DATE_ISO8601 = 29;
    public static final int CALC_BYTE_TO_HEX_ENCODE = 30;
    public static final int CALC_HEX_TO_BYTE_DECODE = 31;
    public static final int CALC_CHAR_TO_HEX_ENCODE = 32;
    public static final int CALC_HEX_TO_CHAR_DECODE = 33;
    public static final int CALC_CRC32 = 34;
    public static final int CALC_ADLER32 = 35;
    public static final int CALC_MD5 = 36;
    public static final int CALC_SHA1 = 37;
    public static final int CALC_LEVENSHTEIN_DISTANCE = 38;
    public static final int CALC_METAPHONE = 39;
    public static final int CALC_DOUBLE_METAPHONE = 40;
    public static final int CALC_ABS = 41;
    public static final int CALC_REMOVE_TIME_FROM_DATE = 42;
    public static final int CALC_DATE_DIFF = 43;
    public static final int CALC_ADD3 = 44;
    public static final int CALC_INITCAP = 45;
    public static final int CALC_UPPER_CASE = 46;
    public static final int CALC_LOWER_CASE = 47;
    public static final int CALC_MASK_XML = 48;
    public static final int CALC_USE_CDATA = 49;
    public static final int CALC_REMOVE_CR = 50;
    public static final int CALC_REMOVE_LF = 51;
    public static final int CALC_REMOVE_CRLF = 52;
    public static final int CALC_REMOVE_TAB = 53;
    public static final int CALC_GET_ONLY_DIGITS = 54;
    public static final int CALC_REMOVE_DIGITS = 55;
    public static final int CALC_STRING_LEN = 56;
    public static final int CALC_LOAD_FILE_CONTENT_BINARY = 57;
    public static final int CALC_ADD_TIME_TO_DATE = 58;
    public static final int CALC_QUARTER_OF_DATE = 59;
    public static final int CALC_SUBSTITUTE_VARIABLE = 60;
    public static final int CALC_UNESCAPE_XML = 61;
    public static final int CALC_ESCAPE_HTML = 62;
    public static final int CALC_UNESCAPE_HTML = 63;
    public static final int CALC_ESCAPE_SQL = 64;
    public static final int CALC_DATE_WORKING_DIFF = 65;
    public static final int CALC_ADD_MONTHS = 66;
    public static final int CALC_CHECK_XML_FILE_WELL_FORMED = 67;
    public static final int CALC_CHECK_XML_WELL_FORMED = 68;
    public static final int CALC_GET_FILE_ENCODING = 69;
    public static final int CALC_DAMERAU_LEVENSHTEIN = 70;
    public static final int CALC_NEEDLEMAN_WUNSH = 71;
    public static final int CALC_JARO = 72;
    public static final int CALC_JARO_WINKLER = 73;
    public static final int CALC_SOUNDEX = 74;
    public static final int CALC_REFINED_SOUNDEX = 75;
    public static final int CALC_ADD_HOURS = 76;
    public static final int CALC_ADD_MINUTES = 77;
    public static final int CALC_DATE_DIFF_MSEC = 78;
    public static final int CALC_DATE_DIFF_SEC = 79;
    public static final int CALC_DATE_DIFF_MN = 80;
    public static final int CALC_DATE_DIFF_HR = 81;
    public static final int CALC_HOUR_OF_DAY = 82;
    public static final int CALC_MINUTE_OF_HOUR = 83;
    public static final int CALC_SECOND_OF_MINUTE = 84;
    public static final int CALC_ROUND_CUSTOM_1 = 85;
    public static final int CALC_ROUND_CUSTOM_2 = 86;
    public static final int CALC_ADD_SECONDS = 87;
    public static final int CALC_REMAINDER = 88;
    public static final String[] calc_desc = new String[]{"-", "CONSTANT", "COPY_FIELD", "ADD", "SUBTRACT", "MULTIPLY", "DIVIDE", "SQUARE", "SQUARE_ROOT", "PERCENT_1", "PERCENT_2", "PERCENT_3", "COMBINATION_1", "COMBINATION_2", "ROUND_1", "ROUND_2", "ROUND_STD_1", "ROUND_STD_2", "CEIL", "FLOOR", "NVL", "ADD_DAYS", "YEAR_OF_DATE", "MONTH_OF_DATE", "DAY_OF_YEAR", "DAY_OF_MONTH", "DAY_OF_WEEK", "WEEK_OF_YEAR", "WEEK_OF_YEAR_ISO8601", "YEAR_OF_DATE_ISO8601", "BYTE_TO_HEX_ENCODE", "HEX_TO_BYTE_DECODE", "CHAR_TO_HEX_ENCODE", "HEX_TO_CHAR_DECODE", "CRC32", "ADLER32", "MD5", "SHA1", "LEVENSHTEIN_DISTANCE", "METAPHONE", "DOUBLE_METAPHONE", "ABS", "REMOVE_TIME_FROM_DATE", "DATE_DIFF", "ADD3", "INIT_CAP", "UPPER_CASE", "LOWER_CASE", "MASK_XML", "USE_CDATA", "REMOVE_CR", "REMOVE_LF", "REMOVE_CRLF", "REMOVE_TAB", "GET_ONLY_DIGITS", "REMOVE_DIGITS", "STRING_LEN", "LOAD_FILE_CONTENT_BINARY", "ADD_TIME_TO_DATE", "QUARTER_OF_DATE", "SUBSTITUTE_VARIABLE", "UNESCAPE_XML", "ESCAPE_HTML", "UNESCAPE_HTML", "ESCAPE_SQL", "DATE_WORKING_DIFF", "ADD_MONTHS", "CHECK_XML_FILE_WELL_FORMED", "CHECK_XML_WELL_FORMED", "GET_FILE_ENCODING", "DAMERAU_LEVENSHTEIN", "NEEDLEMAN_WUNSH", "JARO", "JARO_WINKLER", "SOUNDEX", "REFINED_SOUNDEX", "ADD_HOURS", "ADD_MINUTES", "DATE_DIFF_MSEC", "DATE_DIFF_SEC", "DATE_DIFF_MN", "DATE_DIFF_HR", "HOUR_OF_DAY", "MINUTE_OF_HOUR", "SECOND_OF_MINUTE", "ROUND_CUSTOM_1", "ROUND_CUSTOM_2", "ADD_SECONDS", "REMAINDER"};
    public static final String[] calcLongDesc = new String[]{"-", BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.SetFieldToConstant", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.CreateCopyOfField", (String[])new String[0]), "A + B", "A - B", "A * B", "A / B", "A * A", BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.SQRT", (String[])new String[0]), "100 * A / B", "A - ( A * B / 100 )", "A + ( A * B / 100 )", "A + B * C", BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.Hypotenuse", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.Round", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.Round2", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.RoundStd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.RoundStd2", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.Ceil", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.Floor", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.NVL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DatePlusDays", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.YearOfDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.MonthOfDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DayOfYear", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DayOfMonth", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DayOfWeek", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.WeekOfYear", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.WeekOfYearISO8601", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.YearOfDateISO8601", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.ByteToHexEncode", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.HexToByteDecode", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.CharToHexEncode", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.HexToCharDecode", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.CRC32", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.Adler32", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.MD5", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.SHA1", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.LevenshteinDistance", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.Metaphone", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DoubleMetaphone", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.Abs", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.RemoveTimeFromDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DateDiff", (String[])new String[0]), "A + B + C", BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.InitCap", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.UpperCase", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.LowerCase", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.MaskXML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.UseCDATA", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.RemoveCR", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.RemoveLF", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.RemoveCRLF", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.RemoveTAB", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.GetOnlyDigits", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.RemoveDigits", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.StringLen", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.LoadFileContentInBinary", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.AddTimeToDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.QuarterOfDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.SubstituteVariable", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.UnescapeXML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.EscapeHTML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.UnescapeHTML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.EscapeSQL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DateDiffWorking", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DatePlusMonths", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.CheckXmlFileWellFormed", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.CheckXmlWellFormed", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.GetFileEncoding", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DamerauLevenshtein", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.NeedlemanWunsch", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.Jaro", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.JaroWinkler", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.SoundEx", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.RefinedSoundEx", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DatePlusHours", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DatePlusMinutes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DateDiffMsec", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DateDiffSec", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DateDiffMn", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.DateDiffHr", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.HourOfDay", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.MinuteOfHour", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.SecondOfMinute", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.RoundCustom", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.RoundCustom2", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.AddSeconds", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorMetaFunction.CalcFunctions.Remainder", (String[])new String[0])};
    public static final int[] calcDefaultResultType = new int[calc_desc.length];
    private String fieldName;
    private int calcType;
    private String fieldA;
    private String fieldB;
    private String fieldC;
    private int valueType;
    private int valueLength;
    private int valuePrecision;
    private String conversionMask;
    private String decimalSymbol;
    private String groupingSymbol;
    private String currencySymbol;
    private boolean removedFromResult;

    public CalculatorMetaFunction(String fieldName, int calcType, String fieldA, String fieldB, String fieldC, int valueType, int valueLength, int valuePrecision, boolean removedFromResult, String conversionMask, String decimalSymbol, String groupingSymbol, String currencySymbol) {
        this.fieldName = fieldName;
        this.calcType = calcType;
        this.fieldA = fieldA;
        this.fieldB = fieldB;
        this.fieldC = fieldC;
        this.valueType = valueType;
        this.valueLength = valueLength;
        this.valuePrecision = valuePrecision;
        this.removedFromResult = removedFromResult;
        this.conversionMask = conversionMask;
        this.decimalSymbol = decimalSymbol;
        this.groupingSymbol = groupingSymbol;
        this.currencySymbol = currencySymbol;
    }

    public CalculatorMetaFunction() {
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            CalculatorMetaFunction mf = (CalculatorMetaFunction)obj;
            return this.getXML().equals(mf.getXML());
        }
        return false;
    }

    public Object clone() {
        try {
            CalculatorMetaFunction retval = (CalculatorMetaFunction)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("    ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("      ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldName));
        xml.append("      ").append(XMLHandler.addTagValue((String)"calc_type", (String)this.getCalcTypeDesc()));
        xml.append("      ").append(XMLHandler.addTagValue((String)"field_a", (String)this.fieldA));
        xml.append("      ").append(XMLHandler.addTagValue((String)"field_b", (String)this.fieldB));
        xml.append("      ").append(XMLHandler.addTagValue((String)"field_c", (String)this.fieldC));
        xml.append("      ").append(XMLHandler.addTagValue((String)"value_type", (String)ValueMetaFactory.getValueMetaName((int)this.valueType)));
        xml.append("      ").append(XMLHandler.addTagValue((String)"value_length", (int)this.valueLength));
        xml.append("      ").append(XMLHandler.addTagValue((String)"value_precision", (int)this.valuePrecision));
        xml.append("      ").append(XMLHandler.addTagValue((String)"remove", (boolean)this.removedFromResult));
        xml.append("      ").append(XMLHandler.addTagValue((String)"conversion_mask", (String)this.conversionMask));
        xml.append("      ").append(XMLHandler.addTagValue((String)"decimal_symbol", (String)this.decimalSymbol));
        xml.append("      ").append(XMLHandler.addTagValue((String)"grouping_symbol", (String)this.groupingSymbol));
        xml.append("      ").append(XMLHandler.addTagValue((String)"currency_symbol", (String)this.currencySymbol));
        xml.append("    ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return xml.toString();
    }

    public CalculatorMetaFunction(Node calcnode) {
        this.fieldName = XMLHandler.getTagValue((Node)calcnode, (String)"field_name");
        this.calcType = CalculatorMetaFunction.getCalcFunctionType(XMLHandler.getTagValue((Node)calcnode, (String)"calc_type"));
        this.fieldA = XMLHandler.getTagValue((Node)calcnode, (String)"field_a");
        this.fieldB = XMLHandler.getTagValue((Node)calcnode, (String)"field_b");
        this.fieldC = XMLHandler.getTagValue((Node)calcnode, (String)"field_c");
        this.valueType = ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_type"));
        this.valueLength = Const.toInt((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_length"), (int)-1);
        this.valuePrecision = Const.toInt((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_precision"), (int)-1);
        this.removedFromResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)calcnode, (String)"remove"));
        this.conversionMask = XMLHandler.getTagValue((Node)calcnode, (String)"conversion_mask");
        this.decimalSymbol = XMLHandler.getTagValue((Node)calcnode, (String)"decimal_symbol");
        this.groupingSymbol = XMLHandler.getTagValue((Node)calcnode, (String)"grouping_symbol");
        this.currencySymbol = XMLHandler.getTagValue((Node)calcnode, (String)"currency_symbol");
        if (XMLHandler.getSubNode((Node)calcnode, (String)"conversion_mask") == null) {
            this.fixBackwardCompatibility();
        }
    }

    private void fixBackwardCompatibility() {
        if (this.valueType == 5) {
            if (Utils.isEmpty((CharSequence)this.conversionMask)) {
                this.conversionMask = "0";
            }
            if (Utils.isEmpty((CharSequence)this.decimalSymbol)) {
                this.decimalSymbol = ".";
            }
            if (Utils.isEmpty((CharSequence)this.groupingSymbol)) {
                this.groupingSymbol = ",";
            }
        }
        if (this.valueType == 1) {
            if (Utils.isEmpty((CharSequence)this.conversionMask)) {
                this.conversionMask = "0.0";
            }
            if (Utils.isEmpty((CharSequence)this.decimalSymbol)) {
                this.decimalSymbol = ".";
            }
            if (Utils.isEmpty((CharSequence)this.groupingSymbol)) {
                this.groupingSymbol = ",";
            }
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step, int nr) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, nr, "field_name", this.fieldName);
        rep.saveStepAttribute(id_transformation, id_step, nr, "calc_type", this.getCalcTypeDesc());
        rep.saveStepAttribute(id_transformation, id_step, nr, "field_a", this.fieldA);
        rep.saveStepAttribute(id_transformation, id_step, nr, "field_b", this.fieldB);
        rep.saveStepAttribute(id_transformation, id_step, nr, "field_c", this.fieldC);
        rep.saveStepAttribute(id_transformation, id_step, nr, "value_type", ValueMetaFactory.getValueMetaName((int)this.valueType));
        rep.saveStepAttribute(id_transformation, id_step, nr, "value_length", this.valueLength);
        rep.saveStepAttribute(id_transformation, id_step, nr, "value_precision", this.valuePrecision);
        rep.saveStepAttribute(id_transformation, id_step, nr, "remove", this.removedFromResult);
        rep.saveStepAttribute(id_transformation, id_step, nr, "conversion_mask", this.conversionMask);
        rep.saveStepAttribute(id_transformation, id_step, nr, "decimal_symbol", this.decimalSymbol);
        rep.saveStepAttribute(id_transformation, id_step, nr, "grouping_symbol", this.groupingSymbol);
        rep.saveStepAttribute(id_transformation, id_step, nr, "currency_symbol", this.currencySymbol);
    }

    public CalculatorMetaFunction(Repository rep, ObjectId id_step, int nr) throws KettleException {
        KettleDatabaseRepository repository;
        this.fieldName = rep.getStepAttributeString(id_step, nr, "field_name");
        this.calcType = CalculatorMetaFunction.getCalcFunctionType(rep.getStepAttributeString(id_step, nr, "calc_type"));
        this.fieldA = rep.getStepAttributeString(id_step, nr, "field_a");
        this.fieldB = rep.getStepAttributeString(id_step, nr, "field_b");
        this.fieldC = rep.getStepAttributeString(id_step, nr, "field_c");
        this.valueType = ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, nr, "value_type"));
        this.valueLength = (int)rep.getStepAttributeInteger(id_step, nr, "value_length");
        this.valuePrecision = (int)rep.getStepAttributeInteger(id_step, nr, "value_precision");
        this.removedFromResult = rep.getStepAttributeBoolean(id_step, nr, "remove");
        this.conversionMask = rep.getStepAttributeString(id_step, nr, "conversion_mask");
        this.decimalSymbol = rep.getStepAttributeString(id_step, nr, "decimal_symbol");
        this.groupingSymbol = rep.getStepAttributeString(id_step, nr, "grouping_symbol");
        this.currencySymbol = rep.getStepAttributeString(id_step, nr, "currency_symbol");
        if (rep instanceof KettleDatabaseRepository && (repository = (KettleDatabaseRepository)rep).findStepAttributeID(id_step, nr, "conversion_mask") != null) {
            this.fixBackwardCompatibility();
        }
    }

    public static int getCalcFunctionType(String desc) {
        int i;
        for (i = 1; i < calc_desc.length; ++i) {
            if (!calc_desc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        for (i = 1; i < calcLongDesc.length; ++i) {
            if (!calcLongDesc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static String getCalcFunctionDesc(int type) {
        if (type < 0 || type >= calc_desc.length) {
            return null;
        }
        return calc_desc[type];
    }

    public static String getCalcFunctionLongDesc(int type) {
        if (type < 0 || type >= calcLongDesc.length) {
            return null;
        }
        return calcLongDesc[type];
    }

    public static int getCalcFunctionDefaultResultType(int type) {
        if (type < 0 || type >= calcDefaultResultType.length) {
            return 0;
        }
        return calcDefaultResultType[type];
    }

    public int getCalcType() {
        return this.calcType;
    }

    public void setCalcType(int calcType) {
        this.calcType = calcType;
    }

    public String getCalcTypeDesc() {
        return CalculatorMetaFunction.getCalcFunctionDesc(this.calcType);
    }

    public String getCalcTypeLongDesc() {
        return CalculatorMetaFunction.getCalcFunctionLongDesc(this.calcType);
    }

    public String getFieldA() {
        return this.fieldA;
    }

    public void setFieldA(String fieldA) {
        this.fieldA = fieldA;
    }

    public String getFieldB() {
        return this.fieldB;
    }

    public void setFieldB(String fieldB) {
        this.fieldB = fieldB;
    }

    public String getFieldC() {
        return this.fieldC;
    }

    public void setFieldC(String fieldC) {
        this.fieldC = fieldC;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public void setValueLength(int valueLength) {
        this.valueLength = valueLength;
    }

    public int getValuePrecision() {
        return this.valuePrecision;
    }

    public void setValuePrecision(int valuePrecision) {
        this.valuePrecision = valuePrecision;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public boolean isRemovedFromResult() {
        return this.removedFromResult;
    }

    public void setRemovedFromResult(boolean removedFromResult) {
        this.removedFromResult = removedFromResult;
    }

    public String getConversionMask() {
        return this.conversionMask;
    }

    public void setConversionMask(String conversionMask) {
        this.conversionMask = conversionMask;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(String groupingSymbol) {
        this.groupingSymbol = groupingSymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    static {
        CalculatorMetaFunction.calcDefaultResultType[0] = 0;
        CalculatorMetaFunction.calcDefaultResultType[1] = 2;
        CalculatorMetaFunction.calcDefaultResultType[2] = 0;
        CalculatorMetaFunction.calcDefaultResultType[3] = 1;
        CalculatorMetaFunction.calcDefaultResultType[4] = 1;
        CalculatorMetaFunction.calcDefaultResultType[5] = 1;
        CalculatorMetaFunction.calcDefaultResultType[6] = 1;
        CalculatorMetaFunction.calcDefaultResultType[7] = 1;
        CalculatorMetaFunction.calcDefaultResultType[8] = 1;
        CalculatorMetaFunction.calcDefaultResultType[9] = 1;
        CalculatorMetaFunction.calcDefaultResultType[10] = 1;
        CalculatorMetaFunction.calcDefaultResultType[11] = 1;
        CalculatorMetaFunction.calcDefaultResultType[12] = 1;
        CalculatorMetaFunction.calcDefaultResultType[13] = 1;
        CalculatorMetaFunction.calcDefaultResultType[14] = 5;
        CalculatorMetaFunction.calcDefaultResultType[15] = 1;
        CalculatorMetaFunction.calcDefaultResultType[16] = 5;
        CalculatorMetaFunction.calcDefaultResultType[17] = 1;
        CalculatorMetaFunction.calcDefaultResultType[18] = 5;
        CalculatorMetaFunction.calcDefaultResultType[19] = 5;
        CalculatorMetaFunction.calcDefaultResultType[20] = 0;
        CalculatorMetaFunction.calcDefaultResultType[21] = 3;
        CalculatorMetaFunction.calcDefaultResultType[22] = 5;
        CalculatorMetaFunction.calcDefaultResultType[23] = 5;
        CalculatorMetaFunction.calcDefaultResultType[24] = 5;
        CalculatorMetaFunction.calcDefaultResultType[25] = 5;
        CalculatorMetaFunction.calcDefaultResultType[26] = 5;
        CalculatorMetaFunction.calcDefaultResultType[27] = 5;
        CalculatorMetaFunction.calcDefaultResultType[28] = 5;
        CalculatorMetaFunction.calcDefaultResultType[29] = 5;
        CalculatorMetaFunction.calcDefaultResultType[30] = 2;
        CalculatorMetaFunction.calcDefaultResultType[31] = 2;
        CalculatorMetaFunction.calcDefaultResultType[32] = 2;
        CalculatorMetaFunction.calcDefaultResultType[33] = 2;
        CalculatorMetaFunction.calcDefaultResultType[34] = 5;
        CalculatorMetaFunction.calcDefaultResultType[35] = 5;
        CalculatorMetaFunction.calcDefaultResultType[36] = 2;
        CalculatorMetaFunction.calcDefaultResultType[37] = 2;
        CalculatorMetaFunction.calcDefaultResultType[38] = 5;
        CalculatorMetaFunction.calcDefaultResultType[39] = 2;
        CalculatorMetaFunction.calcDefaultResultType[40] = 2;
        CalculatorMetaFunction.calcDefaultResultType[41] = 5;
        CalculatorMetaFunction.calcDefaultResultType[42] = 3;
        CalculatorMetaFunction.calcDefaultResultType[43] = 5;
        CalculatorMetaFunction.calcDefaultResultType[44] = 1;
        CalculatorMetaFunction.calcDefaultResultType[45] = 2;
        CalculatorMetaFunction.calcDefaultResultType[46] = 2;
        CalculatorMetaFunction.calcDefaultResultType[47] = 2;
        CalculatorMetaFunction.calcDefaultResultType[48] = 2;
        CalculatorMetaFunction.calcDefaultResultType[49] = 2;
        CalculatorMetaFunction.calcDefaultResultType[50] = 2;
        CalculatorMetaFunction.calcDefaultResultType[51] = 2;
        CalculatorMetaFunction.calcDefaultResultType[52] = 2;
        CalculatorMetaFunction.calcDefaultResultType[53] = 2;
        CalculatorMetaFunction.calcDefaultResultType[54] = 2;
        CalculatorMetaFunction.calcDefaultResultType[55] = 2;
        CalculatorMetaFunction.calcDefaultResultType[56] = 5;
        CalculatorMetaFunction.calcDefaultResultType[57] = 8;
        CalculatorMetaFunction.calcDefaultResultType[58] = 3;
        CalculatorMetaFunction.calcDefaultResultType[59] = 5;
        CalculatorMetaFunction.calcDefaultResultType[60] = 2;
        CalculatorMetaFunction.calcDefaultResultType[61] = 2;
        CalculatorMetaFunction.calcDefaultResultType[62] = 2;
        CalculatorMetaFunction.calcDefaultResultType[63] = 2;
        CalculatorMetaFunction.calcDefaultResultType[64] = 2;
        CalculatorMetaFunction.calcDefaultResultType[65] = 5;
        CalculatorMetaFunction.calcDefaultResultType[66] = 3;
        CalculatorMetaFunction.calcDefaultResultType[67] = 4;
        CalculatorMetaFunction.calcDefaultResultType[68] = 4;
        CalculatorMetaFunction.calcDefaultResultType[69] = 2;
        CalculatorMetaFunction.calcDefaultResultType[70] = 5;
        CalculatorMetaFunction.calcDefaultResultType[71] = 5;
        CalculatorMetaFunction.calcDefaultResultType[72] = 1;
        CalculatorMetaFunction.calcDefaultResultType[73] = 1;
        CalculatorMetaFunction.calcDefaultResultType[74] = 2;
        CalculatorMetaFunction.calcDefaultResultType[75] = 2;
        CalculatorMetaFunction.calcDefaultResultType[76] = 3;
        CalculatorMetaFunction.calcDefaultResultType[77] = 3;
        CalculatorMetaFunction.calcDefaultResultType[78] = 5;
        CalculatorMetaFunction.calcDefaultResultType[79] = 5;
        CalculatorMetaFunction.calcDefaultResultType[80] = 5;
        CalculatorMetaFunction.calcDefaultResultType[81] = 5;
        CalculatorMetaFunction.calcDefaultResultType[82] = 5;
        CalculatorMetaFunction.calcDefaultResultType[83] = 5;
        CalculatorMetaFunction.calcDefaultResultType[84] = 5;
        CalculatorMetaFunction.calcDefaultResultType[85] = 1;
        CalculatorMetaFunction.calcDefaultResultType[86] = 1;
        CalculatorMetaFunction.calcDefaultResultType[87] = 3;
        CalculatorMetaFunction.calcDefaultResultType[88] = 1;
    }
}

