/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import com.cloudera.org.codehaus.jackson.map.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolumeSet;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Step;

public class PlanCommand
extends Command {
    private double thresholdPercentage = 1.0;
    private int bandwidth = 0;
    private int maxError = 0;

    public PlanCommand(Configuration conf) {
        super(conf);
        this.addValidCommandParameters("uri", "Name Node URI or file URI for cluster");
        this.addValidCommandParameters("out", "Output file");
        this.addValidCommandParameters("bandwidth", "Maximum Bandwidth to be used while copying.");
        this.addValidCommandParameters("thresholdPercentage", "Percentage skew that we tolerate before diskbalancer starts working.");
        this.addValidCommandParameters("maxerror", "Max errors to tolerate between 2 disks");
        this.addValidCommandParameters("v", "Run plan command in verbose mode.");
    }

    @Override
    public void execute(CommandLine cmd) throws Exception {
        LOG.debug("Processing Plan Command.");
        Preconditions.checkState((boolean)cmd.hasOption("plan"));
        this.verifyCommandOptions("plan", cmd);
        if (cmd.getOptionValue("plan") == null) {
            throw new IllegalArgumentException("A node name is required to create a plan.");
        }
        if (cmd.hasOption("bandwidth")) {
            this.bandwidth = Integer.parseInt(cmd.getOptionValue("bandwidth"));
        }
        if (cmd.hasOption("maxerror")) {
            this.maxError = Integer.parseInt(cmd.getOptionValue("maxerror"));
        }
        this.readClusterInfo(cmd);
        String output = null;
        if (cmd.hasOption("out")) {
            output = cmd.getOptionValue("out");
        }
        this.setOutputPath(output);
        DiskBalancerDataNode node = this.getNode(cmd.getOptionValue("plan"));
        if (node == null) {
            throw new IllegalArgumentException("Unable to find the specified node. " + cmd.getOptionValue("plan"));
        }
        this.thresholdPercentage = this.getThresholdPercentage(cmd);
        LOG.debug("threshold Percentage is {}", (Object)this.thresholdPercentage);
        this.setNodesToProcess(node);
        this.populatePathNames(node);
        List<NodePlan> plans = this.getCluster().computePlan(this.thresholdPercentage);
        this.setPlanParams(plans);
        LOG.info("Writing plan to : {}", (Object)this.getOutputPath());
        System.out.printf("Writing plan to : %s%n", this.getOutputPath());
        try (FSDataOutputStream beforeStream = this.create(String.format("%s.before.json", cmd.getOptionValue("plan")));){
            beforeStream.write(this.getCluster().toJson().getBytes(StandardCharsets.UTF_8));
        }
        var6_6 = null;
        try (FSDataOutputStream planStream = this.create(String.format("%s.plan.json", cmd.getOptionValue("plan")));){
            planStream.write(this.getPlan(plans).getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        if (cmd.hasOption("v")) {
            PlanCommand.printToScreen(plans);
        }
    }

    private void populatePathNames(DiskBalancerDataNode node) throws IOException {
        String dnAddress = node.getDataNodeIP() + ":" + node.getDataNodePort();
        ClientDatanodeProtocol dnClient = this.getDataNodeProxy(dnAddress);
        String volumeNameJson = dnClient.getDiskBalancerSetting("DiskBalancerVolumeName");
        ObjectMapper mapper = new ObjectMapper();
        Map volumeMap = mapper.readValue(volumeNameJson, HashMap.class);
        for (DiskBalancerVolumeSet set : node.getVolumeSets().values()) {
            for (DiskBalancerVolume vol : set.getVolumes()) {
                if (!volumeMap.containsKey(vol.getUuid())) continue;
                vol.setPath((String)volumeMap.get(vol.getUuid()));
            }
        }
    }

    @Override
    protected String getHelp() {
        return "This commands creates a disk balancer plan for given datanode";
    }

    private double getThresholdPercentage(CommandLine cmd) {
        Double value = 0.0;
        if (cmd.hasOption("thresholdPercentage")) {
            value = Double.parseDouble(cmd.getOptionValue("thresholdPercentage"));
        }
        if (value <= 0.0 || value > 100.0) {
            value = this.getConf().getDouble("dfs.disk.balancer.max.disk.throughputInMBperSec", 10.0);
        }
        return value;
    }

    private static void printToScreen(List<NodePlan> plans) {
        System.out.println("\nPlan :\n");
        System.out.println(StringUtils.repeat((String)"=", (int)80));
        System.out.println("Source Disk\t\t Dest.Disk\t\t Move Size\t Type\n ");
        for (NodePlan plan : plans) {
            for (Step step : plan.getVolumeSetPlans()) {
                System.out.println(String.format("%s\t%s\t%s\t%s", step.getSourceVolume().getPath(), step.getDestinationVolume().getPath(), step.getSizeString(step.getBytesToMove()), step.getDestinationVolume().getStorageType()));
            }
        }
        System.out.println(StringUtils.repeat((String)"=", (int)80));
    }

    private void setPlanParams(List<NodePlan> plans) {
        for (NodePlan plan : plans) {
            for (Step step : plan.getVolumeSetPlans()) {
                if (this.bandwidth > 0) {
                    LOG.debug("Setting bandwidth to {}", (Object)this.bandwidth);
                    step.setBandwidth(this.bandwidth);
                }
                if (this.maxError <= 0) continue;
                LOG.debug("Setting max error to {}", (Object)this.maxError);
                step.setMaxDiskErrors(this.maxError);
            }
        }
    }

    private String getPlan(List<NodePlan> plan) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(plan);
    }
}

