/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerException;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.apache.htrace.fasterxml.jackson.databind.ObjectMapper;

public class ExecuteCommand
extends Command {
    public ExecuteCommand(Configuration conf) {
        super(conf);
        this.addValidCommandParameters("execute", "Executes a given plan.");
        this.addValidCommandParameters("node", "Name of the target node.");
    }

    @Override
    public void execute(CommandLine cmd) throws Exception {
        LOG.info("Executing \"execute plan\" command");
        Preconditions.checkState((boolean)cmd.hasOption("execute"));
        this.verifyCommandOptions("execute", cmd);
        String planFile = cmd.getOptionValue("execute");
        Preconditions.checkArgument((planFile != null && !planFile.isEmpty() ? 1 : 0) != 0, (Object)"Invalid plan file specified.");
        String planData = null;
        try (FSDataInputStream plan = this.open(planFile);){
            planData = IOUtils.toString((InputStream)plan);
        }
        this.submitPlan(planData);
    }

    private void submitPlan(String planData) throws IOException {
        Preconditions.checkNotNull((Object)planData);
        NodePlan plan = this.readPlan(planData);
        String dataNodeAddress = plan.getNodeName() + ":" + plan.getPort();
        Preconditions.checkNotNull((Object)dataNodeAddress);
        ClientDatanodeProtocol dataNode = this.getDataNodeProxy(dataNodeAddress);
        String planHash = DigestUtils.sha512Hex((String)planData);
        try {
            dataNode.submitDiskBalancerPlan(planHash, 1L, planData, false);
        }
        catch (DiskBalancerException ex) {
            LOG.error("Submitting plan on  {} failed. Result: {}, Message: {}", new Object[]{plan.getNodeName(), ex.getResult().toString(), ex.getMessage()});
            throw ex;
        }
    }

    private NodePlan readPlan(String planData) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (NodePlan)mapper.readValue(planData, NodePlan.class);
    }

    @Override
    protected String getHelp() {
        return "Execute command takes a plan and runs it against the node. e.g. hdfs diskbalancer -execute <nodename.plan.json> ";
    }
}

