/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.pentaho.amazon.AmazonS3FileSystemBootstrap;
import org.pentaho.amazon.AmazonSpoonPlugin;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.s3.vfs.S3FileObject;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class S3VfsFileChooserDialog
extends CustomVfsUiPanel {
    private static Class<?> PKG = AmazonSpoonPlugin.class;
    private LogChannel log = new LogChannel((Object)this);
    private Label wlAccessKey;
    private TextVar wAccessKey;
    private GridData fdlAccessKey;
    private GridData fdAccessKey;
    private Label wlSecretKey;
    private TextVar wSecretKey;
    private GridData fdlSecretKey;
    private GridData fdSecretKey;
    private Label wPlaceHolderLabel;
    private GridData fdlPlaceHolderLabel;
    private Button wConnectionButton;
    private GridData fdConnectionButton;
    FileObject defaultInitialFile = null;
    FileObject localRootFile = null;
    String localOpenFromFolder = null;
    FileObject s3RootFile = null;
    String s3OpenFromFolder = null;
    FileObject rootFile = null;
    FileObject initialFile = null;
    VfsFileChooserDialog vfsFileChooserDialog = null;
    private String accessKey;
    private String secretKey;
    private StaticUserAuthenticator userAuthenticator = null;

    public S3VfsFileChooserDialog(VfsFileChooserDialog vfsFileChooserDialog, FileObject rootFile, FileObject initialFile) {
        super("s3", AmazonS3FileSystemBootstrap.getS3FileSystemDisplayText(), vfsFileChooserDialog, 0);
        this.vfsFileChooserDialog = vfsFileChooserDialog;
        this.rootFile = rootFile;
        this.initialFile = initialFile;
        this.setLayout((Layout)new GridLayout());
        this.createConnectionPanel();
        this.initializeConnectionPanel();
    }

    private void createConnectionPanel() {
        Group connectionGroup = new Group((Composite)this, 16);
        connectionGroup.setText(BaseMessages.getString(PKG, (String)"S3VfsFileChooserDialog.ConnectionGroup.Label", (String[])new String[0]));
        GridLayout connectionGroupLayout = new GridLayout();
        connectionGroupLayout.marginWidth = 5;
        connectionGroupLayout.marginHeight = 5;
        connectionGroupLayout.verticalSpacing = 5;
        connectionGroupLayout.horizontalSpacing = 5;
        GridData gData = new GridData(4, 4, true, false);
        connectionGroup.setLayoutData((Object)gData);
        connectionGroup.setLayout((Layout)connectionGroupLayout);
        Composite textFieldPanel = new Composite((Composite)connectionGroup, 0);
        GridData gridData = new GridData(4, 4, true, false);
        textFieldPanel.setLayoutData((Object)gridData);
        textFieldPanel.setLayout((Layout)new GridLayout(3, false));
        this.wlAccessKey = new Label(textFieldPanel, 131072);
        this.wlAccessKey.setText(BaseMessages.getString(PKG, (String)"S3VfsFileChooserDialog.AccessKey.Label", (String[])new String[0]));
        this.fdlAccessKey = new GridData();
        this.fdlAccessKey.widthHint = 75;
        this.wlAccessKey.setLayoutData((Object)this.fdlAccessKey);
        this.wAccessKey = new TextVar(this.getVariableSpace(), textFieldPanel, 0x404804);
        this.fdAccessKey = new GridData();
        this.fdAccessKey.widthHint = 150;
        this.wAccessKey.setLayoutData((Object)this.fdAccessKey);
        this.wAccessKey.setText(Encr.decryptPasswordOptionallyEncrypted((String)Props.getInstance().getCustomParameter("S3VfsFileChooserDialog.AccessKey", "")));
        this.wAccessKey.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                S3VfsFileChooserDialog.this.handleConnectionButton();
            }
        });
        this.wPlaceHolderLabel = new Label(textFieldPanel, 131072);
        this.wPlaceHolderLabel.setText("");
        this.fdlPlaceHolderLabel = new GridData();
        this.fdlPlaceHolderLabel.widthHint = 75;
        this.wPlaceHolderLabel.setLayoutData((Object)this.fdlPlaceHolderLabel);
        this.wlSecretKey = new Label(textFieldPanel, 131072);
        this.wlSecretKey.setText(BaseMessages.getString(PKG, (String)"S3VfsFileChooserDialog.SecretKey.Label", (String[])new String[0]));
        this.fdlSecretKey = new GridData();
        this.fdlSecretKey.widthHint = 75;
        this.wlSecretKey.setLayoutData((Object)this.fdlSecretKey);
        this.wSecretKey = new TextVar(this.getVariableSpace(), textFieldPanel, 0x404804);
        this.fdSecretKey = new GridData();
        this.fdSecretKey.widthHint = 300;
        this.wSecretKey.setLayoutData((Object)this.fdSecretKey);
        this.wSecretKey.setText(Encr.decryptPasswordOptionallyEncrypted((String)Props.getInstance().getCustomParameter("S3VfsFileChooserDialog.SecretKey", "")));
        this.wSecretKey.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                S3VfsFileChooserDialog.this.handleConnectionButton();
            }
        });
        this.wConnectionButton = new Button(textFieldPanel, 0x1000000);
        this.fdConnectionButton = new GridData();
        this.fdConnectionButton.widthHint = 75;
        this.wConnectionButton.setLayoutData((Object)this.fdConnectionButton);
        this.wConnectionButton.setText(BaseMessages.getString(PKG, (String)"S3VfsFileChooserDialog.ConnectionButton.Label", (String[])new String[0]));
        this.wConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    AmazonS3Client s3Client = new AmazonS3Client(new AWSCredentials(){

                        public String getAWSSecretKey() {
                            return Encr.decryptPasswordOptionallyEncrypted((String)S3VfsFileChooserDialog.this.environmentSubstitute(S3VfsFileChooserDialog.this.wSecretKey.getText()));
                        }

                        public String getAWSAccessKeyId() {
                            return Encr.decryptPasswordOptionallyEncrypted((String)S3VfsFileChooserDialog.this.environmentSubstitute(S3VfsFileChooserDialog.this.wAccessKey.getText()));
                        }
                    });
                    s3Client.getS3AccountOwner();
                    Props.getInstance().setCustomParameter("S3VfsFileChooserDialog.AccessKey", Encr.encryptPasswordIfNotUsingVariables((String)S3VfsFileChooserDialog.this.wAccessKey.getText()));
                    Props.getInstance().setCustomParameter("S3VfsFileChooserDialog.SecretKey", Encr.encryptPasswordIfNotUsingVariables((String)S3VfsFileChooserDialog.this.wSecretKey.getText()));
                    try {
                        FileObject root = S3VfsFileChooserDialog.this.rootFile;
                        root = S3VfsFileChooserDialog.this.resolveFile(S3VfsFileChooserDialog.this.buildS3FileSystemUrlString());
                        S3VfsFileChooserDialog.this.vfsFileChooserDialog.setSelectedFile(root);
                        S3VfsFileChooserDialog.this.vfsFileChooserDialog.setRootFile(root);
                        S3VfsFileChooserDialog.this.rootFile = root;
                    }
                    catch (FileSystemException e1) {
                        MessageBox box = new MessageBox(S3VfsFileChooserDialog.this.getShell());
                        box.setText(BaseMessages.getString((Class)PKG, (String)"S3VfsFileChooserDialog.error", (String[])new String[0]));
                        box.setMessage(e1.getMessage());
                        S3VfsFileChooserDialog.this.log.logError(e1.getMessage(), (Throwable)e1);
                        box.open();
                        return;
                    }
                }
                catch (AmazonS3Exception ex) {
                    MessageBox box = new MessageBox(S3VfsFileChooserDialog.this.getShell());
                    box.setText(BaseMessages.getString((Class)PKG, (String)"S3VfsFileChooserDialog.error", (String[])new String[0]));
                    box.setMessage(ex.getMessage());
                    S3VfsFileChooserDialog.this.log.logError(ex.getMessage(), (Throwable)ex);
                    box.open();
                    return;
                }
            }
        });
        textFieldPanel.setTabList(new Control[]{this.wAccessKey, this.wSecretKey, this.wConnectionButton});
    }

    private VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }

    private String environmentSubstitute(String str) {
        return this.getVariableSpace().environmentSubstitute(str);
    }

    public String buildS3FileSystemUrlString() {
        return "s3://s3/";
    }

    public void activate() {
        this.wAccessKey.setVariables(this.getVariableSpace());
        this.wSecretKey.setVariables(this.getVariableSpace());
        this.vfsFileChooserDialog.setRootFile(null);
        this.vfsFileChooserDialog.setInitialFile(null);
        this.vfsFileChooserDialog.openFileCombo.setText("s3://");
        this.vfsFileChooserDialog.vfsBrowser.fileSystemTree.removeAll();
        super.activate();
    }

    private void initializeConnectionPanel() {
        if (this.initialFile != null && this.initialFile instanceof S3FileObject) {
            try {
                GenericFileName genericFileName = (GenericFileName)this.initialFile.getFileSystem().getRoot().getName();
                this.wAccessKey.setText(genericFileName.getUserName() == null ? "" : genericFileName.getUserName());
                this.wSecretKey.setText(genericFileName.getPassword());
            }
            catch (FileSystemException fse) {
                this.showMessageAndLog("S3VfsFileChooserDialog.error", "S3VfsFileChooserDialog.FileSystem.error", fse.getMessage());
            }
        }
        this.handleConnectionButton();
    }

    private void showMessageAndLog(String title, String message, String messageToLog) {
        MessageBox box = new MessageBox(this.getShell());
        box.setText(BaseMessages.getString(PKG, (String)title, (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)message, (String[])new String[0]));
        this.log.logError(messageToLog);
        box.open();
    }

    private void handleConnectionButton() {
        if (!Const.isEmpty((String)this.wAccessKey.getText()) && !Const.isEmpty((String)this.wSecretKey.getText())) {
            this.accessKey = Encr.decryptPasswordOptionallyEncrypted((String)this.getVariableSpace().environmentSubstitute(this.wAccessKey.getText()));
            this.secretKey = Encr.decryptPasswordOptionallyEncrypted((String)this.getVariableSpace().environmentSubstitute(this.wSecretKey.getText()));
            this.wConnectionButton.setEnabled(true);
        } else {
            this.accessKey = null;
            this.secretKey = null;
            this.wConnectionButton.setEnabled(false);
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)this.getFileSystemOptions());
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public FileObject resolveFile(String fileUri, FileSystemOptions opts) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)opts);
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    protected FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        if (!Const.isEmpty((String)this.getAccessKey()) || !Const.isEmpty((String)this.getSecretKey())) {
            StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator(null, Encr.decryptPasswordOptionallyEncrypted((String)this.getVariableSpace().environmentSubstitute(this.getAccessKey())), Encr.decryptPasswordOptionallyEncrypted((String)this.getVariableSpace().environmentSubstitute(this.getSecretKey())));
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)userAuthenticator);
        }
        return opts;
    }
}

