/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.httpclient;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.http.HTTPMeta;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.step.ExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClientStepAnalyzer
extends ExternalResourceStepAnalyzer<HTTPMeta> {
    private Logger log = LoggerFactory.getLogger(HTTPClientStepAnalyzer.class);

    protected Set<StepField> getUsedFields(HTTPMeta stepMeta) {
        Object[] headerFields;
        Object[] parameterFields;
        HashSet<StepField> usedFields = new HashSet<StepField>();
        if (stepMeta.isUrlInField() && StringUtils.isNotEmpty((String)stepMeta.getUrlField())) {
            usedFields.addAll(this.createStepFields(stepMeta.getUrlField(), this.getInputs()));
        }
        if (ArrayUtils.isNotEmpty((Object[])(parameterFields = stepMeta.getArgumentField()))) {
            for (Object paramField : parameterFields) {
                usedFields.addAll(this.createStepFields((String)paramField, this.getInputs()));
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(headerFields = stepMeta.getHeaderField()))) {
            for (Object headerField : headerFields) {
                usedFields.addAll(this.createStepFields((String)headerField, this.getInputs()));
            }
        }
        return usedFields;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(HTTPMeta.class);
            }
        };
    }

    protected Map<String, RowMetaInterface> getInputRowMetaInterfaces(HTTPMeta meta) {
        return this.getInputFields((BaseStepMeta)meta);
    }

    public IMetaverseNode createResourceNode(IExternalResourceInfo resource) throws MetaverseException {
        MetaverseComponentDescriptor componentDescriptor = new MetaverseComponentDescriptor(resource.getName(), this.getResourceInputNodeType(), this.descriptor.getNamespace(), this.descriptor.getContext());
        IMetaverseNode node = this.createNodeFromDescriptor((IComponentDescriptor)componentDescriptor);
        return node;
    }

    public String getResourceInputNodeType() {
        return "Web Service";
    }

    public String getResourceOutputNodeType() {
        return null;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return true;
    }

    protected void setObjectFactory(IMetaverseObjectFactory objectFactory) {
        this.metaverseObjectFactory = objectFactory;
    }
}

