/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.calculator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.calculator.CalculatorMeta;
import org.pentaho.di.trans.steps.calculator.CalculatorMetaFunction;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.Operation;

public class CalculatorStepAnalyzer
extends StepAnalyzer<CalculatorMeta> {
    protected void customAnalyze(CalculatorMeta meta, IMetaverseNode rootNode) {
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> set = new HashSet<Class<? extends BaseStepMeta>>(1);
        set.add(CalculatorMeta.class);
        return set;
    }

    public Set<ComponentDerivationRecord> getChangeRecords(CalculatorMeta calculatorMeta) throws MetaverseAnalyzerException {
        HashSet<ComponentDerivationRecord> changeRecords = new HashSet<ComponentDerivationRecord>();
        for (CalculatorMetaFunction function : calculatorMeta.getCalculation()) {
            Set<ComponentDerivationRecord> changeRecord = this.buildChangeRecord(function);
            changeRecords.addAll(changeRecord);
        }
        return changeRecords;
    }

    protected Set<StepField> getUsedFields(CalculatorMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        for (CalculatorMetaFunction function : meta.getCalculation()) {
            if (StringUtils.isNotEmpty((String)function.getFieldA())) {
                usedFields.addAll(this.createStepFields(function.getFieldA(), this.getInputs()));
            }
            if (StringUtils.isNotEmpty((String)function.getFieldB())) {
                usedFields.addAll(this.createStepFields(function.getFieldB(), this.getInputs()));
            }
            if (!StringUtils.isNotEmpty((String)function.getFieldC())) continue;
            usedFields.addAll(this.createStepFields(function.getFieldC(), this.getInputs()));
        }
        return usedFields;
    }

    protected Set<ComponentDerivationRecord> buildChangeRecord(CalculatorMetaFunction function) {
        HashSet<ComponentDerivationRecord> changes = new HashSet<ComponentDerivationRecord>();
        String fieldA = function.getFieldA();
        String fieldB = function.getFieldB();
        String fieldC = function.getFieldC();
        String inputFields = (fieldA != null ? fieldA + ", " : "") + (fieldB != null ? fieldB + ", " : "") + (fieldC != null ? fieldC + ", " : "");
        ArrayList<String> fields = new ArrayList<String>();
        if (fieldA != null) {
            fields.add(fieldA);
        }
        if (fieldB != null) {
            fields.add(fieldB);
        }
        if (fieldC != null) {
            fields.add(fieldC);
        }
        for (String field : fields) {
            ComponentDerivationRecord changeRecord = new ComponentDerivationRecord(field, function.getFieldName(), ChangeType.DATA);
            changeRecord.addOperation(new Operation("calculation", ChangeType.DATA, "transforms", inputFields + "using " + function.getCalcTypeDesc() + " -> " + function.getFieldName()));
            changes.add(changeRecord);
        }
        return changes;
    }
}

