/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom.wrappers;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.wrappers.GenericDOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JaxpDOMParser
extends GenericDOMParser {
    private DocumentBuilder builder;

    public JaxpDOMParser() throws XOMException {
        this(false);
    }

    public JaxpDOMParser(boolean validating) throws XOMException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            try {
                factory.setAttribute("http://xml.org/sax/features/validation", new Boolean(validating));
                factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(validating));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XOMException(e, "Error creating parser");
        }
        catch (FactoryConfigurationError e) {
            throw new XOMException(e, "Error creating parser");
        }
        this.builder.setErrorHandler(this);
        this.document = this.builder.newDocument();
    }

    protected Document parseInputSource(InputSource in) throws XOMException {
        this.prepareParse();
        try {
            Document document = this.builder.parse(in);
            this.handleErrors();
            return document;
        }
        catch (SAXException e) {
            this.handleErrors();
            throw new XOMException(e, "Document parse failed");
        }
        catch (IOException e) {
            this.handleErrors();
            throw new XOMException(e, "Document parse failed");
        }
    }
}

