/*
* Copyright 2002 - 2013 Pentaho Corporation.  All rights reserved.
* 
* This software was developed by Pentaho Corporation and is provided under the terms
* of the Mozilla Public License, Version 1.1, or any later version. You may not use
* this file except in compliance with the license. If you need a copy of the license,
* please go to http://www.mozilla.org/MPL/MPL-1.1.txt. TThe Initial Developer is Pentaho Corporation.
*
* Software distributed under the Mozilla Public License is distributed on an "AS IS"
* basis, WITHOUT WARRANTY OF ANY KIND, either express or  implied. Please refer to
* the license for the specific language governing your rights and limitations.
*/

// ** I18N

// Calendar LV language
// Author: Juris Valdovskis, <juris@dc.lv>
// Encoding: cp1257
// Distributed under the same terms as the calendar itself.

// For translators: please use UTF-8 if possible.  We strongly believe that
// Unicode is the answer to a real internationalized world.  Also please
// include your contact information in the header, as can be seen above.

// full day names
Calendar._DN = new Array
("Svtdiena",
 "Pirmdiena",
 "Otrdiena",
 "Trediena",
 "Ceturdiena",
 "Piektdiena",
 "Sestdiena",
 "Svtdiena");

// Please note that the following array of short day names (and the same goes
// for short month names, _SMN) isn't absolutely necessary.  We give it here
// for exemplification on how one can customize the short day names, but if
// they are simply the first N letters of the full name you can simply say:
//
//   Calendar._SDN_len = N; // short day name length
//   Calendar._SMN_len = N; // short month name length
//
// If N = 3 then this is not needed either since we assume a value of 3 if not
// present, to be compatible with translation files that were written before
// this feature.

// short day names
Calendar._SDN = new Array
("Sv",
 "Pr",
 "Ot",
 "Tr",
 "Ce",
 "Pk",
 "Se",
 "Sv");

// full month names
Calendar._MN = new Array
("Janvris",
 "Februris",
 "Marts",
 "Aprlis",
 "Maijs",
 "Jnijs",
 "Jlijs",
 "Augusts",
 "Septembris",
 "Oktobris",
 "Novembris",
 "Decembris");

// short month names
Calendar._SMN = new Array
("Jan",
 "Feb",
 "Mar",
 "Apr",
 "Mai",
 "Jn",
 "Jl",
 "Aug",
 "Sep",
 "Okt",
 "Nov",
 "Dec");

// tooltips
Calendar._TT = {};
Calendar._TT["INFO"] = "Par kalendru";

Calendar._TT["ABOUT"] =
"DHTML Date/Time Selector\n" +
"(c) dynarch.com 2002-2005 / Author: Mihai Bazon\n" + // don't translate this this ;-)
"For latest version visit: http://www.dynarch.com/projects/calendar/\n" +
"Distributed under GNU LGPL.  See http://gnu.org/licenses/lgpl.html for details." +
"\n\n" +
"Datuma izvle:\n" +
"- Izmanto \xab, \xbb pogas, lai izvltos gadu\n" +
"- Izmanto " + String.fromCharCode(0x2039) + ", " + String.fromCharCode(0x203a) + "pogas, lai izvltos mnesi\n" +
"- Turi nospiestu peles pogu uz jebkuru no augstk mintajm pogm, lai patrintu izvli.";
Calendar._TT["ABOUT_TIME"] = "\n\n" +
"Laika izvle:\n" +
"- Uzklikini uz jebkuru no laika dam, lai palielintu to\n" +
"- vai Shift-klikis, lai samazintu to\n" +
"- vai noklikini un velc uz attiecgo virzienu lai maintu trk.";

Calendar._TT["PREV_YEAR"] = "Iepr. gads (turi izvlnei)";
Calendar._TT["PREV_MONTH"] = "Iepr. mnesis (turi izvlnei)";
Calendar._TT["GO_TODAY"] = "odien";
Calendar._TT["NEXT_MONTH"] = "Nkoais mnesis (turi izvlnei)";
Calendar._TT["NEXT_YEAR"] = "Nkoais gads (turi izvlnei)";
Calendar._TT["SEL_DATE"] = "Izvlies datumu";
Calendar._TT["DRAG_TO_MOVE"] = "Velc, lai prvietotu";
Calendar._TT["PART_TODAY"] = " (odien)";

// the following is to inform that "%s" is to be the first day of week
// %s will be replaced with the day name.
Calendar._TT["DAY_FIRST"] = "Attlot %s k pirmo";

// This may be locale-dependent.  It specifies the week-end days, as an array
// of comma-separated numbers.  The numbers are from 0 to 6: 0 means Sunday, 1
// means Monday, etc.
Calendar._TT["WEEKEND"] = "1,7";

Calendar._TT["CLOSE"] = "Aizvrt";
Calendar._TT["TODAY"] = "odien";
Calendar._TT["TIME_PART"] = "(Shift-)Klikis vai prvieto, lai maintu";

// date formats
Calendar._TT["DEF_DATE_FORMAT"] = "%d-%m-%Y";
Calendar._TT["TT_DATE_FORMAT"] = "%a, %e %b";

Calendar._TT["WK"] = "wk";
Calendar._TT["TIME"] = "Laiks:";
