/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.agilebi.modeler.propforms.GenericPropertiesForm;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.ui.xul.stereotype.Bindable;

public class DimensionMetaDataCollection
extends AbstractMetaDataModelNode<DimensionMetaData>
implements Serializable {
    private static final long serialVersionUID = -6327799582519270107L;
    private String name = "Dimensions";
    private static final String CLASSNAME = "pentaho-smallcategorybutton";
    private transient PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DimensionMetaDataCollection.this.fireCollectionChanged();
        }
    };

    public DimensionMetaDataCollection() {
        super(CLASSNAME);
        this.valid = false;
    }

    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public String getDisplayName() {
        return this.getName();
    }

    @Bindable
    public void setName(String name) {
        this.name = name;
    }

    @Bindable
    public boolean isUiExpanded() {
        return true;
    }

    @Override
    protected void fireCollectionChanged() {
        this.changeSupport.firePropertyChange("children", null, this);
    }

    @Override
    public void onAdd(DimensionMetaData child) {
        child.setParent(this);
        child.addPropertyChangeListener("name", this.nameListener);
        child.addPropertyChangeListener("valid", this.validListener);
        child.addPropertyChangeListener("children", this.childrenListener);
        this.validateNode();
    }

    @Override
    public void onRemove(DimensionMetaData child) {
        child.removePropertyChangeListener(this.validListener);
        child.removePropertyChangeListener(this.nameListener);
        child.removePropertyChangeListener(this.childrenListener);
        this.validateNode();
    }

    @Override
    @Bindable
    public String getValidImage() {
        return "images/sm_folder_icon.png";
    }

    @Override
    public void validate() {
        this.valid = true;
        this.validationMessages.clear();
        if (this.size() == 0) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.dimcollecion.REQUIRES_AT_LEAST_ONE_MEASURE", new String[0]));
            this.valid = false;
        }
        HashMap<String, DimensionMetaData> usedNames = new HashMap<String, DimensionMetaData>();
        for (DimensionMetaData dim : this.children) {
            this.valid &= dim.isValid();
            this.validationMessages.addAll(dim.getValidationMessages());
            if (usedNames.containsKey(dim.getName())) {
                DimensionMetaData d;
                this.valid = false;
                String msg = ModelerMessagesHolder.getMessages().getString("validation.dimcollection.DUPLICATE_DIMENSION_NAMES", dim.getName());
                this.validationMessages.add(msg);
                dim.invalidate();
                if (!dim.getValidationMessages().contains(msg)) {
                    dim.getValidationMessages().add(msg);
                }
                if (!(d = (DimensionMetaData)usedNames.get(dim.getName())).isValid()) continue;
                d.invalidate();
                if (d.getValidationMessages().contains(msg)) continue;
                d.getValidationMessages().add(msg);
                continue;
            }
            usedNames.put(dim.getName(), dim);
        }
        if (!this.suppressEvents) {
            this.firePropertyChange("valid", null, this.valid);
        }
    }

    @Bindable
    public boolean isEditingDisabled() {
        return true;
    }

    @Override
    public Class<? extends ModelerNodePropertiesForm> getPropertiesForm() {
        return GenericPropertiesForm.class;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(DimensionMetaDataCollection obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DimensionMetaDataCollection other = obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        return obj instanceof AvailableField || obj instanceof AvailableTable || obj instanceof LevelMetaData || obj instanceof DimensionMetaData;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        try {
            if (data instanceof AvailableTable) {
                AvailableTable tbl = (AvailableTable)data;
                DimensionMetaData dim = this.getWorkspace().createDimensionFromAvailableTable(tbl);
                return dim;
            }
            if (data instanceof AvailableField) {
                ColumnBackedNode node = this.getWorkspace().createColumnBackedNode((AvailableField)data, ModelerPerspective.ANALYSIS);
                return this.getWorkspace().createDimensionFromNode(node);
            }
            if (data instanceof MeasureMetaData) {
                return this.getWorkspace().createDimensionFromNode((MeasureMetaData)data);
            }
            if (data instanceof LevelMetaData) {
                return this.getWorkspace().createDimensionFromNode((LevelMetaData)data);
            }
            if (data instanceof DimensionMetaData) {
                return data;
            }
            throw new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0]));
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
    }
}

