/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.pentaho.agilebi.modeler.BaseModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.LocalizedString;

public class ModelerConversionUtil {
    public static double upConvertDomain(Domain domain) {
        int modelCount = domain.getLogicalModels().size();
        LogicalModel model = (LogicalModel)domain.getLogicalModels().get(0);
        String versionString = (String)model.getProperty("AGILE_BI_VERSION");
        String isAgileBiGenerated = (String)model.getProperty("AGILE_BI_GENERATED_SCHEMA");
        String mondrianCatRef = (String)model.getProperty("MondrianCatalogRef");
        String dualModelingMode = (String)model.getProperty("DUAL_MODELING_SCHEMA");
        double currentVersion = Double.parseDouble("3.0");
        if ("false".equals(dualModelingMode)) {
            return currentVersion;
        }
        if (modelCount > 1) {
            if (model.getLogicalTables().size() == ((LogicalModel)domain.getLogicalModels().get(1)).getLogicalTables().size()) {
                return currentVersion;
            }
        } else if (modelCount == 1 || isAgileBiGenerated != null && isAgileBiGenerated.equals("TRUE") || mondrianCatRef != null) {
            LogicalModel olapModel;
            double versionNumber = 1.0;
            boolean ignored = false;
            try {
                versionNumber = Double.parseDouble(versionString);
            }
            catch (NumberFormatException e) {
                ignored = true;
            }
            catch (NullPointerException npe) {
                ignored = true;
            }
            if (versionNumber < 2.0) {
                olapModel = ModelerConversionUtil.duplicateModelForOlap(model);
                domain.addLogicalModel(olapModel);
            } else if (versionNumber == 2.0) {
                olapModel = ModelerConversionUtil.upgradeAndSplitCombinedModel(model);
                domain.addLogicalModel(olapModel);
            }
            return versionNumber;
        }
        return 0.0;
    }

    protected static LogicalModel upgradeAndSplitCombinedModel(LogicalModel combinedModel) {
        LogicalModel olapModel = new LogicalModel();
        ModelerConversionUtil.duplicateProperties(combinedModel, olapModel);
        olapModel.setName(ModelerConversionUtil.appendOlap(combinedModel.getName()));
        olapModel.setDescription(ModelerConversionUtil.appendOlap(combinedModel.getName()));
        olapModel.setId(combinedModel.getId() + "_OLAP");
        olapModel.setPhysicalModel(combinedModel.getPhysicalModel());
        olapModel.setDomain(combinedModel.getDomain());
        if (combinedModel.getRowLevelSecurity() != null) {
            olapModel.setRowLevelSecurity(combinedModel.getRowLevelSecurity());
        }
        olapModel.setProperty("AGILE_BI_GENERATED_SCHEMA", (Object)"TRUE");
        olapModel.setProperty("MODELING_SCHEMA", (Object)"OLAP");
        olapModel.setProperty("DUAL_MODELING_SCHEMA", (Object)"true");
        olapModel.setProperty("visible", (Object)"false");
        ArrayList<LogicalTable> relationalTables = new ArrayList<LogicalTable>();
        ArrayList<LogicalTable> olapTables = new ArrayList<LogicalTable>();
        for (LogicalTable table : combinedModel.getLogicalTables()) {
            if (table.getId().endsWith("_OLAP")) {
                table.setLogicalModel(olapModel);
                olapTables.add(table);
                continue;
            }
            relationalTables.add(table);
        }
        combinedModel.getLogicalTables().clear();
        combinedModel.getLogicalTables().addAll(relationalTables);
        olapModel.getLogicalTables().addAll(olapTables);
        if (combinedModel.getLogicalRelationships().size() > 0) {
            ModelerConversionUtil.splitOlapRelationships(combinedModel, olapModel);
        }
        combinedModel.setProperty("AGILE_BI_VERSION", (Object)"3.0");
        olapModel.setProperty("AGILE_BI_VERSION", (Object)"3.0");
        combinedModel.removeChildProperty("olap_cubes");
        combinedModel.removeChildProperty("olap_dimensions");
        return olapModel;
    }

    protected static void splitOlapRelationships(LogicalModel relationalModel, LogicalModel olapModel) {
        ArrayList<LogicalRelationship> relationalRelationships = new ArrayList<LogicalRelationship>();
        ArrayList<LogicalRelationship> olapRelationships = new ArrayList<LogicalRelationship>();
        if (relationalModel.getLogicalRelationships() != null) {
            for (LogicalRelationship rel : relationalModel.getLogicalRelationships()) {
                if (ModelerConversionUtil.isOlap((Concept)rel.getFromColumn()) && ModelerConversionUtil.isOlap((Concept)rel.getToColumn()) && ModelerConversionUtil.isOlap((Concept)rel.getFromTable()) && ModelerConversionUtil.isOlap((Concept)rel.getToTable())) {
                    LogicalRelationship olapRel = ModelerConversionUtil.duplicateRelationshipForOlap(rel, olapModel);
                    olapRelationships.add(olapRel);
                    continue;
                }
                relationalRelationships.add(rel);
            }
            relationalModel.getLogicalRelationships().clear();
            relationalModel.getLogicalRelationships().addAll(relationalRelationships);
            olapModel.getLogicalRelationships().addAll(olapRelationships);
        }
    }

    private static boolean isOlap(Concept concept) {
        return concept.getId().endsWith("_OLAP");
    }

    protected static LogicalTable findCorrespondingOlapTable(LogicalTable relationalTable, LogicalModel olapModel) {
        for (LogicalTable table : olapModel.getLogicalTables()) {
            if (!table.getPhysicalTable().getId().equals(relationalTable.getPhysicalTable().getId())) continue;
            return table;
        }
        return null;
    }

    protected static LogicalColumn findCorrespondingOlapColumn(LogicalColumn relationalColumn, LogicalModel olapModel) {
        LogicalTable olapTable = ModelerConversionUtil.findCorrespondingOlapTable(relationalColumn.getLogicalTable(), olapModel);
        if (olapTable != null) {
            for (LogicalColumn col : olapTable.getLogicalColumns()) {
                if (!col.getPhysicalColumn().getId().equals(relationalColumn.getPhysicalColumn().getId())) continue;
                return col;
            }
        }
        return null;
    }

    public static LogicalModel duplicateModelForOlap(LogicalModel logicalModel) {
        LogicalModel olapModel = new LogicalModel();
        ModelerConversionUtil.duplicateProperties(logicalModel, olapModel);
        olapModel.setId(logicalModel.getId() + "_OLAP");
        olapModel.setName(ModelerConversionUtil.appendOlap(logicalModel.getName()));
        olapModel.setDescription(ModelerConversionUtil.appendOlap(logicalModel.getName()));
        olapModel.setPhysicalModel(logicalModel.getPhysicalModel());
        olapModel.setDomain(logicalModel.getDomain());
        if (logicalModel.getRowLevelSecurity() != null) {
            olapModel.setRowLevelSecurity(logicalModel.getRowLevelSecurity());
        }
        olapModel.setProperty("AGILE_BI_GENERATED_SCHEMA", (Object)"TRUE");
        olapModel.setProperty("MODELING_SCHEMA", (Object)"OLAP");
        olapModel.setProperty("DUAL_MODELING_SCHEMA", (Object)"true");
        olapModel.setProperty("visible", (Object)"false");
        for (LogicalTable table : logicalModel.getLogicalTables()) {
            LogicalTable copiedTable = (LogicalTable)table.clone();
            copiedTable.setId(copiedTable.getId() + "_OLAP");
            ArrayList<LogicalColumn> olapColumns = new ArrayList<LogicalColumn>();
            for (LogicalColumn col : table.getLogicalColumns()) {
                Iterator i$;
                LogicalColumn olapCol = new LogicalColumn();
                olapCol.setLogicalTable(copiedTable);
                olapCol.setPhysicalColumn(col.getPhysicalColumn());
                olapCol.setDataType(col.getDataType());
                if (col.getPhysicalColumn().getAggregationList() != null) {
                    olapCol.setAggregationList(col.getPhysicalColumn().getAggregationList());
                }
                if (col.getPhysicalColumn().getAggregationType() != null) {
                    olapCol.setAggregationType(col.getPhysicalColumn().getAggregationType());
                } else if (olapCol.getDataType().equals((Object)DataType.NUMERIC)) {
                    olapCol.setAggregationType(AggregationType.SUM);
                } else {
                    olapCol.setAggregationType(AggregationType.NONE);
                }
                if (col.getProperty("mask") != null) {
                    olapCol.setProperty("mask", col.getProperty("mask"));
                } else if (olapCol.getDataType().equals((Object)DataType.NUMERIC)) {
                    olapCol.setProperty("mask", (Object)"#");
                }
                LocalizedString newName = ModelerConversionUtil.appendOlap(col.getName());
                olapCol.setName(newName);
                String locale = "en_US";
                if (logicalModel.getName().getLocales() != null && logicalModel.getName().getLocales().size() > 0 && (i$ = logicalModel.getName().getLocales().iterator()).hasNext()) {
                    String l;
                    locale = l = (String)i$.next();
                }
                String colId = "LC_" + ModelerWorkspace.toId(table.getPhysicalTable().getName(locale)) + "_" + ModelerWorkspace.toId(col.getPhysicalColumn().getId()) + "_OLAP";
                colId = BaseModelerWorkspaceHelper.uniquify(colId, olapColumns);
                olapCol.setId(colId);
                olapColumns.add(olapCol);
            }
            copiedTable.getLogicalColumns().clear();
            copiedTable.getLogicalColumns().addAll(olapColumns);
            olapModel.addLogicalTable(copiedTable);
        }
        ModelerConversionUtil.duplicateRelationshipsForOlap(logicalModel, olapModel);
        olapModel.setProperty("AGILE_BI_VERSION", (Object)"3.0");
        logicalModel.removeChildProperty("olap_cubes");
        logicalModel.removeChildProperty("olap_dimensions");
        return olapModel;
    }

    private static void duplicateProperties(LogicalModel relationalModel, LogicalModel olapModel) {
        Map props = relationalModel.getProperties();
        olapModel.getProperties().clear();
        for (String key : props.keySet()) {
            olapModel.setProperty(key, props.get(key));
        }
    }

    public static void duplicateRelationshipsForOlap(LogicalModel relationalModel, LogicalModel olapModel) {
        if (olapModel.getLogicalRelationships() != null) {
            olapModel.getLogicalRelationships().clear();
        }
        if (relationalModel.getLogicalRelationships() != null) {
            for (LogicalRelationship rel : relationalModel.getLogicalRelationships()) {
                olapModel.addLogicalRelationship(ModelerConversionUtil.duplicateRelationshipForOlap(rel, olapModel));
            }
        }
    }

    private static LogicalRelationship duplicateRelationshipForOlap(LogicalRelationship rel, LogicalModel olapModel) {
        LogicalTable olapFromTable = ModelerConversionUtil.findCorrespondingOlapTable(rel.getFromTable(), olapModel);
        LogicalTable olapToTable = ModelerConversionUtil.findCorrespondingOlapTable(rel.getToTable(), olapModel);
        LogicalColumn olapFromCol = ModelerConversionUtil.findCorrespondingOlapColumn(rel.getFromColumn(), olapModel);
        LogicalColumn olapToCol = ModelerConversionUtil.findCorrespondingOlapColumn(rel.getToColumn(), olapModel);
        LogicalRelationship olapRel = new LogicalRelationship(olapModel, olapFromTable, olapToTable, olapFromCol, olapToCol);
        olapRel.setComplex(rel.isComplex());
        olapRel.setRelationshipType(rel.getRelationshipType());
        olapRel.setJoinOrderKey(rel.getJoinOrderKey());
        olapRel.setComplexJoin(rel.getComplexJoin());
        olapRel.setRelationshipDescription(rel.getRelationshipDescription());
        return olapRel;
    }

    private static LocalizedString appendOlap(LocalizedString localizedString) {
        LocalizedString newString = new LocalizedString();
        for (String locale : localizedString.getLocaleStringMap().keySet()) {
            newString.setString(locale, localizedString.getString(locale) + "_OLAP");
        }
        return newString;
    }
}

