/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.io.StringWriter;
import java.io.Writer;

public class OServerCommandGetProfiler
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"GET|profiler/*", "POST|profiler/*"};

    public OServerCommandGetProfiler() {
        super("server.profiler");
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] parts = this.checkSyntax(iRequest.url, 2, "Syntax error: profiler/<command>/[<config>]|[<from>/<to>]");
        iRequest.data.commandInfo = "Profiler information";
        try {
            String command = parts[1];
            if (command.equalsIgnoreCase("start")) {
                Orient.instance().getProfiler().startRecording();
                iResponse.send(200, "OK", "text/plain", "Recording started", null);
            } else if (command.equalsIgnoreCase("stop")) {
                Orient.instance().getProfiler().stopRecording();
                iResponse.send(200, "OK", "text/plain", "Recording stopped", null);
            } else if (command.equalsIgnoreCase("configure")) {
                Orient.instance().getProfiler().configure(parts[2]);
                iResponse.send(200, "OK", "text/plain", "Profiler configured with: " + parts[2], null);
            } else if (command.equalsIgnoreCase("status")) {
                String status = Orient.instance().getProfiler().isRecording() ? "on" : "off";
                iResponse.send(200, "OK", "text/plain", status, null);
            } else if (command.equalsIgnoreCase("metadata")) {
                iResponse.send(200, "OK", "application/json", Orient.instance().getProfiler().metadataToJSON(), null);
            } else {
                String par1 = parts.length > 2 ? parts[2] : null;
                String par2 = parts.length > 3 ? parts[3] : null;
                StringWriter jsonBuffer = new StringWriter();
                OJSONWriter json = new OJSONWriter((Writer)jsonBuffer);
                json.append(Orient.instance().getProfiler().toJSON(command, par1, par2));
                iResponse.send(200, "OK", "application/json", jsonBuffer.toString(), null);
            }
        }
        catch (Exception e) {
            iResponse.send(400, "Bad request", "text/plain", e, null);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

