/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.util.ArrayList;

public class OServerCommandGetCluster
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|cluster/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: cluster/<database>/<cluster-name>[/<limit>]<br/>Limit is optional and is setted to 20 by default. Set expressely to 0 to have no limits.");
        iRequest.data.commandInfo = "Browse cluster";
        iRequest.data.commandDetail = urlParts[2];
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getClusterIdByName(urlParts[2]) == -1) {
                throw new IllegalArgumentException("Invalid cluster '" + urlParts[2] + "'");
            }
            int limit = urlParts.length > 3 ? Integer.parseInt(urlParts[3]) : 20;
            ArrayList<OIdentifiable> response = new ArrayList<OIdentifiable>();
            for (ORecord rec : db.browseCluster(urlParts[2])) {
                if (limit > 0 && response.size() >= limit) break;
                response.add((OIdentifiable)rec);
            }
            iResponse.writeRecords(response);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

