/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class OHttpResponseWrapper {
    private final OHttpResponse response;

    public OHttpResponse getResponse() {
        return this.response;
    }

    public OHttpResponseWrapper(OHttpResponse iResponse) {
        this.response = iResponse;
    }

    public String getHeader() {
        return this.response.headers;
    }

    public OHttpResponseWrapper setHeader(String iHeader) {
        this.response.setHeader(iHeader);
        return this;
    }

    public String getCharacterSet() {
        return this.response.characterSet;
    }

    public OHttpResponseWrapper setCharacterSet(String iCharacterSet) {
        this.response.characterSet = iCharacterSet;
        return this;
    }

    public String getHttpVersion() {
        return this.response.httpVersion;
    }

    public String[] getAdditionalResponseHeaders() {
        return this.response.additionalHeaders;
    }

    public OutputStream getOutputStream() {
        return this.response.getOutputStream();
    }

    public OHttpResponseWrapper writeStatus(int iHttpCode, String iReason) throws IOException {
        this.response.writeStatus(iHttpCode, iReason);
        return this;
    }

    public OHttpResponseWrapper writeHeaders(String iContentType) throws IOException {
        this.response.writeHeaders(iContentType);
        return this;
    }

    public OHttpResponseWrapper writeHeaders(String iContentType, boolean iKeepAlive) throws IOException {
        this.response.writeHeaders(iContentType, iKeepAlive);
        return this;
    }

    public OHttpResponseWrapper writeLine(String iContent) throws IOException {
        this.response.writeLine(iContent);
        return this;
    }

    public OHttpResponseWrapper writeContent(String iContent) throws IOException {
        this.response.writeContent(iContent);
        return this;
    }

    public OHttpResponseWrapper writeRecords(List<OIdentifiable> iRecords) throws IOException {
        this.response.writeRecords(iRecords);
        return this;
    }

    public OHttpResponseWrapper writeRecords(List<OIdentifiable> iRecords, String iFetchPlan) throws IOException {
        this.response.writeRecords(iRecords, iFetchPlan);
        return this;
    }

    public OHttpResponseWrapper writeRecord(ORecord<?> iRecord) throws IOException {
        this.response.writeRecord(iRecord);
        return this;
    }

    public OHttpResponseWrapper writeRecord(ORecord<?> iRecord, String iFetchPlan) throws IOException {
        this.response.writeRecord(iRecord, iFetchPlan, null);
        return this;
    }

    public OHttpResponseWrapper send(int iCode, String iReason, String iContentType, Object iContent) throws IOException {
        this.response.send(iCode, iReason, iContentType, iContent, null);
        return this;
    }

    public OHttpResponseWrapper send(int iCode, String iReason, String iContentType, Object iContent, String iHeaders) throws IOException {
        this.response.send(iCode, iReason, iContentType, iContent, iHeaders);
        return this;
    }

    public OHttpResponseWrapper send(int iCode, String iReason, String iContentType, Object iContent, String iHeaders, boolean iKeepAlive) throws IOException {
        this.response.send(iCode, iReason, iContentType, iContent, iHeaders, iKeepAlive);
        return this;
    }

    public OHttpResponseWrapper sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize) throws IOException {
        this.response.sendStream(iCode, iReason, iContentType, iContent, iSize);
        return this;
    }

    public OHttpResponseWrapper flush() throws IOException {
        this.response.flush();
        return this;
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }
}

