/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.Callable;

public abstract class OAbstractRemoteTask<T>
implements Callable<T>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private String nodeSource;
    protected String nodeDestination;
    protected String databaseName;
    protected long runId;
    protected long operationSerial;
    protected ODistributedServerManager.EXECUTION_MODE mode;
    protected boolean inheritedDatabase;
    protected transient OServer serverInstance;

    public OAbstractRemoteTask() {
    }

    public OAbstractRemoteTask(long iRunId, long iOperationId) {
        this.runId = iRunId;
        this.operationSerial = iOperationId;
    }

    public OAbstractRemoteTask(OServer iServer, ODistributedServerManager iDistributedSrvMgr, String databaseName, ODistributedServerManager.EXECUTION_MODE iMode) {
        this.serverInstance = iServer;
        this.setNodeSource(iDistributedSrvMgr.getLocalNodeId());
        this.databaseName = databaseName;
        this.mode = iMode;
        this.runId = iDistributedSrvMgr.getRunId();
        this.operationSerial = -1L;
    }

    public abstract String getName();

    public Object executeOnLocalNode() throws Exception {
        return this.call();
    }

    public void handleConflict(String iRemoteNode, Object localResult, Object remoteResult) {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getNodeSource());
        out.writeUTF(this.nodeDestination);
        out.writeUTF(this.databaseName);
        out.writeLong(this.runId);
        out.writeLong(this.operationSerial);
        out.writeByte(this.mode.ordinal());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setNodeSource(in.readUTF());
        this.nodeDestination = in.readUTF();
        this.serverInstance = OServer.getInstance(this.nodeDestination);
        this.databaseName = in.readUTF();
        this.runId = in.readLong();
        this.operationSerial = in.readLong();
        this.mode = ODistributedServerManager.EXECUTION_MODE.values()[in.readByte()];
    }

    public String getNodeSource() {
        return this.nodeSource;
    }

    public String getNodeDestination() {
        return this.nodeDestination;
    }

    public void setNodeDestination(String masterNodeId) {
        this.nodeDestination = masterNodeId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public long getOperationSerial() {
        return this.operationSerial;
    }

    public long getRunId() {
        return this.runId;
    }

    public ODistributedServerManager.EXECUTION_MODE getMode() {
        return this.mode;
    }

    public void setMode(ODistributedServerManager.EXECUTION_MODE iMode) {
        this.mode = iMode;
    }

    public void setNodeSource(String nodeSource) {
        this.nodeSource = nodeSource;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String toString() {
        return this.getName();
    }

    protected ODatabaseDocumentTx openDatabase() {
        this.inheritedDatabase = true;
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && db.getName().equals(this.databaseName) && !db.isClosed()) {
            if (db instanceof ODatabaseDocumentTx) {
                return (ODatabaseDocumentTx)db;
            }
            if (db.getDatabaseOwner() instanceof ODatabaseDocumentTx) {
                return (ODatabaseDocumentTx)db.getDatabaseOwner();
            }
        }
        this.inheritedDatabase = false;
        OServerUserConfiguration replicatorUser = this.serverInstance.getUser("replicator");
        return (ODatabaseDocumentTx)this.serverInstance.openDatabase("document", this.databaseName, replicatorUser.name, replicatorUser.password);
    }

    protected void closeDatabase(ODatabaseDocumentTx iDatabase) {
        if (!this.inheritedDatabase) {
            iDatabase.close();
        }
    }

    public OServer getServerInstance() {
        return this.serverInstance;
    }

    public void setServerInstance(OServer serverInstance) {
        this.serverInstance = serverInstance;
    }

    public OStorageSynchronizer getDatabaseSynchronizer() {
        return this.getDistributedServerManager().getDatabaseSynchronizer(this.databaseName);
    }

    public ODistributedServerManager getDistributedServerManager() {
        return this.serverInstance.getDistributedManager();
    }
}

