/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.org.jets3t.service.security;

import com.cloudera.org.jets3t.service.security.ProviderCredentials;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class AWSCredentials
extends ProviderCredentials {
    public AWSCredentials(String awsAccessKey, String awsSecretAccessKey) {
        super(awsAccessKey, awsSecretAccessKey);
    }

    public AWSCredentials(String awsAccessKey, String awsSecretAccessKey, String friendlyName) {
        super(awsAccessKey, awsSecretAccessKey, friendlyName);
    }

    protected String getTypeName() {
        return "regular";
    }

    public String getVersionPrefix() {
        return "jets3t AWS Credentials, version: ";
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            AWSCredentials.printHelp();
            System.exit(1);
        }
        String userName = args[0];
        File encryptedFile = new File(args[1]);
        String algorithm = "PBEWithMD5AndDES";
        if (args.length == 3) {
            algorithm = args[2];
        }
        try {
            FileOutputStream testFOS = new FileOutputStream(encryptedFile);
            testFOS.close();
        }
        catch (IOException e) {
            System.err.println("Unable to write to file: " + encryptedFile);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Please enter your AWS Credentials");
        System.out.print("Access Key: ");
        String awsAccessKey = reader.readLine();
        System.out.print("Secret Key: ");
        String awsSecretKey = reader.readLine();
        System.out.println("Please enter a password to protect your credentials file (may be empty)");
        System.out.print("Password: ");
        String password = reader.readLine();
        AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey, userName);
        awsCredentials.save(password, encryptedFile, algorithm);
        System.out.println("Successfully saved AWS Credentials to " + encryptedFile);
    }

    private static void printHelp() {
        System.out.println("AWSCredentials <User Name> <File Path> [algorithm]");
        System.out.println();
        System.out.println("User Name: A human-friendly name for the owner of the credentials, e.g. Horace.");
        System.out.println("File Path: Path and name for the encrypted file. Will be replaced if it already exists.");
        System.out.println("Algorithm: PBE encryption algorithm. Defaults to PBEWithMD5AndDES");
    }
}

