/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.org.jets3t.service.io;

import com.cloudera.org.jets3t.service.io.InputStreamWrapper;
import com.cloudera.org.jets3t.service.io.UnrecoverableIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepeatableFileInputStream
extends InputStream
implements InputStreamWrapper {
    private static final Log log = LogFactory.getLog(RepeatableFileInputStream.class);
    protected File file = null;
    protected FileInputStream fis = null;
    protected long bytesReadPastMarkPoint = 0L;
    protected long markPoint = 0L;

    public RepeatableFileInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.fis = new FileInputStream(file);
        this.file = file;
    }

    public long skip(long toSkip) throws IOException {
        long skipped = this.fis.skip(toSkip);
        this.bytesReadPastMarkPoint += skipped;
        return skipped;
    }

    public void reset() throws IOException {
        try {
            this.fis.close();
            this.fis = new FileInputStream(this.file);
            long skipped = 0L;
            for (long toSkip = this.markPoint; toSkip > 0L; toSkip -= skipped) {
                skipped = this.skip(toSkip);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reset to mark point " + this.markPoint + " after returning " + this.bytesReadPastMarkPoint + " bytes"));
            }
            this.bytesReadPastMarkPoint = 0L;
        }
        catch (IOException e) {
            throw new UnrecoverableIOException("Input stream is not repeatable: " + e.getMessage());
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readlimit) {
        this.markPoint += this.bytesReadPastMarkPoint;
        this.bytesReadPastMarkPoint = 0L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input stream marked at " + this.markPoint + " bytes"));
        }
    }

    public int available() throws IOException {
        return this.fis.available();
    }

    public void close() throws IOException {
        this.fis.close();
    }

    public int read() throws IOException {
        int byteRead = this.fis.read();
        if (byteRead != -1) {
            ++this.bytesReadPastMarkPoint;
            return byteRead;
        }
        return -1;
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int count = this.fis.read(arg0, arg1, arg2);
        this.bytesReadPastMarkPoint += (long)count;
        return count;
    }

    public InputStream getWrappedInputStream() {
        return this.fis;
    }
}

