/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.org.jets3t.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jets3tProperties
implements Serializable {
    public static final String JETS3T_PROPERTIES_ID = "com.cloudera.org.jets3t.service.JetS3tProperties";
    private static final long serialVersionUID = -822234326095333142L;
    private static final Log log = LogFactory.getLog(Jets3tProperties.class);
    private static final Hashtable<String, Jets3tProperties> propertiesHashtable = new Hashtable();
    private final Properties properties = new Properties();
    private boolean loaded = false;

    public static Jets3tProperties getInstance(InputStream inputStream, String propertiesIdentifer) throws IOException {
        Jets3tProperties jets3tProperties = null;
        if (propertiesHashtable.containsKey(propertiesIdentifer)) {
            jets3tProperties = propertiesHashtable.get(propertiesIdentifer);
        } else {
            jets3tProperties = new Jets3tProperties();
            propertiesHashtable.put(propertiesIdentifer, jets3tProperties);
        }
        jets3tProperties.loadAndReplaceProperties(inputStream, propertiesIdentifer);
        return jets3tProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Jets3tProperties getInstance(String propertiesFileName) {
        Jets3tProperties jets3tProperties = null;
        if (propertiesHashtable.containsKey(propertiesFileName)) {
            jets3tProperties = propertiesHashtable.get(propertiesFileName);
            return jets3tProperties;
        }
        jets3tProperties = new Jets3tProperties();
        propertiesHashtable.put(propertiesFileName, jets3tProperties);
        InputStream cpIS = jets3tProperties.getClass().getResourceAsStream("/" + propertiesFileName);
        if (cpIS != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading properties from resource in the classpath: " + propertiesFileName));
            }
            try {
                jets3tProperties.loadAndReplaceProperties(cpIS, "Resource '" + propertiesFileName + "' in classpath");
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Failed to load properties from resource in classpath: " + propertiesFileName), (Throwable)e);
                }
            }
            finally {
                try {
                    cpIS.close();
                }
                catch (Exception exception) {}
            }
        }
        return jets3tProperties;
    }

    public void setProperty(String propertyName, String propertyValue) {
        if (propertyValue == null) {
            this.clearProperty(propertyName);
        } else {
            this.properties.put(propertyName, Jets3tProperties.trim(propertyValue));
        }
    }

    public void clearProperty(String propertyName) {
        this.properties.remove(propertyName);
    }

    public void clearAllProperties() {
        this.properties.clear();
    }

    public void loadAndReplaceProperties(InputStream inputStream, String propertiesSource) throws IOException {
        Properties newProperties = new Properties();
        newProperties.load(inputStream);
        this.loadAndReplaceProperties(newProperties, propertiesSource);
    }

    public void loadAndReplaceProperties(Jets3tProperties properties, String propertiesSource) {
        Properties newProperties = properties.getProperties();
        this.loadAndReplaceProperties(newProperties, propertiesSource);
    }

    public void loadAndReplaceProperties(Properties newProperties, String propertiesSource) {
        for (Map.Entry<Object, Object> entry : newProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            String propertyValue = (String)entry.getValue();
            if (this.properties.containsKey(propertyName) && !this.properties.getProperty(propertyName).equals(propertyValue) && log.isDebugEnabled()) {
                log.debug((Object)("Over-riding jets3t property [" + propertyName + "=" + propertyValue + "] with value from properties source " + propertiesSource + ". New value: [" + propertyName + "=" + Jets3tProperties.trim(propertyValue) + "]"));
            }
            this.properties.put(propertyName, Jets3tProperties.trim(propertyValue));
        }
        this.loaded = true;
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    public String getStringProperty(String propertyName, String defaultValue) {
        String stringValue = Jets3tProperties.trim(this.properties.getProperty(propertyName, defaultValue));
        if (log.isDebugEnabled()) {
            log.debug((Object)(propertyName + "=" + stringValue));
        }
        return stringValue;
    }

    public long getLongProperty(String propertyName, long defaultValue) throws NumberFormatException {
        String longValue = Jets3tProperties.trim(this.properties.getProperty(propertyName, String.valueOf(defaultValue)));
        if (log.isDebugEnabled()) {
            log.debug((Object)(propertyName + "=" + longValue));
        }
        return Long.parseLong(longValue);
    }

    public int getIntProperty(String propertyName, int defaultValue) throws NumberFormatException {
        String intValue = Jets3tProperties.trim(this.properties.getProperty(propertyName, String.valueOf(defaultValue)));
        if (log.isDebugEnabled()) {
            log.debug((Object)(propertyName + "=" + intValue));
        }
        return Integer.parseInt(intValue);
    }

    public boolean getBoolProperty(String propertyName, boolean defaultValue) throws IllegalArgumentException {
        String boolValue = Jets3tProperties.trim(this.properties.getProperty(propertyName, String.valueOf(defaultValue)));
        if (log.isDebugEnabled()) {
            log.debug((Object)(propertyName + "=" + boolValue));
        }
        if ("true".equalsIgnoreCase(boolValue)) {
            return true;
        }
        if ("false".equalsIgnoreCase(boolValue)) {
            return false;
        }
        throw new IllegalArgumentException("Boolean value '" + boolValue + "' for jets3t property '" + propertyName + "' must be 'true' or 'false' (case-insensitive)");
    }

    public boolean containsKey(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private static String trim(String str) {
        if (str != null) {
            return str.trim();
        }
        return null;
    }
}

