/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import org.apache.hadoop.hive.metastore.api.CompactionType;

public class CompactionInfo {
    public long id;
    public String dbname;
    public String tableName;
    public String partName;
    public CompactionType type;
    public String runAs;
    public boolean tooManyAborts = false;
    private String fullPartitionName = null;
    private String fullTableName = null;

    public String getFullPartitionName() {
        if (this.fullPartitionName == null) {
            StringBuilder buf = new StringBuilder(this.dbname);
            buf.append('.');
            buf.append(this.tableName);
            if (this.partName != null) {
                buf.append('.');
                buf.append(this.partName);
            }
            this.fullPartitionName = buf.toString();
        }
        return this.fullPartitionName;
    }

    public String getFullTableName() {
        if (this.fullTableName == null) {
            StringBuilder buf = new StringBuilder(this.dbname);
            buf.append('.');
            buf.append(this.tableName);
            this.fullTableName = buf.toString();
        }
        return this.fullTableName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompactionInfo)) {
            return false;
        }
        CompactionInfo other = (CompactionInfo)o;
        if (!this.dbname.equals(other.dbname)) {
            return false;
        }
        if (!this.tableName.equals(other.tableName)) {
            return false;
        }
        if (this.partName != null) {
            return this.partName.equals(other.partName);
        }
        return other.partName == null;
    }

    public int hashCode() {
        int hash = this.dbname.hashCode() ^ this.tableName.hashCode();
        if (this.partName != null) {
            hash ^= this.partName.hashCode();
        }
        return hash;
    }
}

