/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import pt.webdetails.cpf.utils.CharsetHelper;
import pt.webdetails.cpf.web.CpfHttpSession;
import pt.webdetails.cpf.web.CpfRequestDispatcher;
import pt.webdetails.cpf.web.CpfServletContext;
import pt.webdetails.cpf.web.DelegatingServletInputStream;
import pt.webdetails.cpf.web.HeaderValueHolder;

public class CpfHttpServletRequest
implements HttpServletRequest {
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_SERVER_ADDR = "127.0.0.1";
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final int DEFAULT_SERVER_PORT = 8080;
    public static final String DEFAULT_REMOTE_ADDR = "127.0.0.1";
    public static final String DEFAULT_REMOTE_HOST = "localhost";
    private String protocol = "http";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 8080;
    private int localPort = 8080;
    private boolean secure = false;
    private int remotePort = 8080;
    private String localName = "localhost";
    private String localAddr = "127.0.0.1";
    private String remoteAddr = "127.0.0.1";
    private String remoteHost = "localhost";
    private final ServletContext servletContext;
    private String method;
    private String pathInfo;
    private String requestURI;
    private String contextPath = "";
    private final Vector<Locale> locales = new Vector();
    private String authType;
    private Cookie[] cookies;
    private final Hashtable<String, Object> headers = new Hashtable();
    private final Hashtable<String, Object> attributes = new Hashtable();
    private Map<String, String[]> parameters = null;
    private final Set<String> userRoles = new HashSet<String>();
    private boolean active = true;
    private String servletPath;
    private Principal userPrincipal;
    private String queryString;
    private HttpSession session;
    private boolean requestedSessionIdValid = true;
    private boolean requestedSessionIdFromCookie = true;
    private boolean requestedSessionIdFromURL = false;
    private String characterEncoding = CharsetHelper.getEncoding();
    private byte[] content;
    private String contentType;

    public CpfHttpServletRequest() {
        this(null, "", "");
    }

    public CpfHttpServletRequest(String method, String requestURI) {
        this(null, method, requestURI);
    }

    public CpfHttpServletRequest(ServletContext servletContext) {
        this(servletContext, "", "");
    }

    public CpfHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
        this.servletContext = servletContext != null ? servletContext : new CpfServletContext();
        this.method = method;
        this.requestURI = requestURI;
        this.locales.add(Locale.ENGLISH);
        this.parameters = new HashMap<String, String[]>();
    }

    protected void setParameterMap(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public boolean isActive() {
        return this.active;
    }

    public void close() {
        this.active = false;
    }

    public void invalidate() {
        this.close();
        this.clearAttributes();
    }

    protected void checkActive() throws IllegalStateException {
        if (!this.active) {
            throw new IllegalStateException("Request is not active anymore");
        }
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public void addHeader(String name, Object value) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        if (header == null) {
            header = new HeaderValueHolder();
            this.headers.put(name, header);
        }
        if (value instanceof Collection) {
            header.addValues((Collection)value);
        } else if (value.getClass().isArray()) {
            header.addValueArray(value);
        } else {
            header.addValue(value);
        }
    }

    public long getDateHeader(String name) {
        Object value;
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        Object object = value = header != null ? header.getValue() : null;
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value != null) {
            throw new IllegalArgumentException("Value for header '" + name + "' is neither a Date nor a Number: " + value);
        }
        return -1L;
    }

    public String getHeader(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return header != null ? header.getValue().toString() : null;
    }

    public Enumeration<Object> getHeaders(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return header != null ? header.getValues() : Collections.enumeration(Collections.emptyList());
    }

    public Enumeration<String> getHeaderNames() {
        return this.headers.keys();
    }

    public int getIntHeader(String name) {
        Object value;
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        Object object = value = header != null ? header.getValue() : null;
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value != null) {
            throw new NumberFormatException("Value for header '" + name + "' is not a Number: " + value);
        }
        return -1;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod() {
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathTranslated() {
        return this.pathInfo != null ? this.getRealPath(this.pathInfo) : null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRemoteUser() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRemoteUser(String remoteUser) {
    }

    public void addRole(String role) {
        this.addUserRole(role);
    }

    public void addUserRole(String role) {
        this.userRoles.add(role);
    }

    public boolean isUserInRole(String role) {
        return this.userRoles.contains(role);
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public String getRequestedSessionId() {
        HttpSession session = this.getSession();
        return session != null ? session.getId() : null;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(this.scheme);
        url.append("://").append(this.serverName).append(':').append(this.serverPort);
        url.append(this.getRequestURI());
        url.append('?');
        url.append(this.getQueryString());
        return url;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public HttpSession getSession(boolean create) {
        this.checkActive();
        if (this.session instanceof CpfHttpSession && ((CpfHttpSession)this.session).isInvalid()) {
            this.session = null;
        }
        if (this.session == null && create) {
            this.session = new CpfHttpSession(this.servletContext);
        }
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public void setSession(HttpSession session) {
        this.session = session;
        if (session instanceof CpfHttpSession) {
            CpfHttpSession cpfSession = (CpfHttpSession)session;
            cpfSession.access();
        }
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public void setRequestedSessionIdValid(boolean requestedSessionIdValid) {
        this.requestedSessionIdValid = requestedSessionIdValid;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public void setRequestedSessionIdFromURL(boolean requestedSessionIdFromURL) {
        this.requestedSessionIdFromURL = requestedSessionIdFromURL;
    }

    public Object getAttribute(String name) {
        this.checkActive();
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.attributes.keys();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding = characterEncoding;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public int getContentLength() {
        return this.content != null ? this.content.length : -1;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.content != null) {
            return new DelegatingServletInputStream(new ByteArrayInputStream(this.content));
        }
        return null;
    }

    public String getParameter(String name) {
        String[] arr = this.parameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        this.parameters.put(name, values);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public BufferedReader getReader() throws IOException {
        if (this.content != null) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.content);
            InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)sourceStream, this.characterEncoding) : new InputStreamReader(sourceStream);
            return new BufferedReader(sourceReader);
        }
        return null;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setAttribute(String name, Object value) {
        this.checkActive();
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        this.checkActive();
        this.attributes.remove(name);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void addPreferredLocale(Locale locale) {
        this.locales.add(0, locale);
    }

    public Locale getLocale() {
        return this.locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        return this.locales.elements();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new CpfRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }
}

