/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.store;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.Store;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.StoreStatusFilter;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.FetchDirection;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.jdbc.LRSSizeAlgorithm;
import org.apache.openjpa.persistence.jdbc.ResultSetType;

public class CoordinatorStore
extends Store {
    private final XLog log = XLog.getLog(this.getClass());
    private EntityManager entityManager = this.getEntityManager();
    private static final String INSTR_GROUP = "db";
    public static final int LOCK_TIMEOUT = 50000;
    private static final long DAY_IN_MS = 86400000L;

    public CoordinatorStore(boolean selectForUpdate) throws StoreException {
    }

    public CoordinatorStore(Store store, boolean selectForUpdate) throws StoreException {
        super(store);
    }

    public void insertCoordinatorJob(final CoordinatorJobBean coordinatorJob) throws StoreException {
        ParamChecker.notNull(coordinatorJob, "coordinatorJob");
        this.doOperation("insertCoordinatorJob", new Callable<Void>(){

            @Override
            public Void call() throws StoreException {
                CoordinatorStore.this.entityManager.persist((Object)coordinatorJob);
                return null;
            }
        });
    }

    public CoordinatorJobBean getCoordinatorJob(final String id, boolean locking) throws StoreException {
        ParamChecker.notEmpty(id, "CoordJobId");
        CoordinatorJobBean cjBean = this.doOperation("getCoordinatorJob", new Callable<CoordinatorJobBean>(){

            @Override
            public CoordinatorJobBean call() throws StoreException {
                Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_COORD_JOB");
                q.setParameter("id", (Object)id);
                List cjBeans = q.getResultList();
                if (cjBeans.size() > 0) {
                    return (CoordinatorJobBean)cjBeans.get(0);
                }
                throw new StoreException(ErrorCode.E0604, id);
            }
        });
        cjBean.setStatus(cjBean.getStatus());
        return cjBean;
    }

    public List<CoordinatorJobBean> getCoordinatorJobsToBeMaterialized(final Date d, final int limit) throws StoreException {
        ParamChecker.notNull(d, "Coord Job Materialization Date");
        List<CoordinatorJobBean> cjBeans = this.doOperation("getCoordinatorJobsToBeMaterialized", new Callable<List<CoordinatorJobBean>>(){

            @Override
            public List<CoordinatorJobBean> call() throws StoreException {
                ArrayList<CoordinatorJobBean> jobList = new ArrayList<CoordinatorJobBean>();
                try {
                    Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_COORD_JOBS_OLDER_THAN");
                    q.setParameter("matTime", (Object)new Timestamp(d.getTime()));
                    if (limit > 0) {
                        q.setMaxResults(limit);
                    }
                    List cjBeans = q.getResultList();
                    for (CoordinatorJobBean j : cjBeans) {
                        jobList.add(j);
                    }
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
                return jobList;
            }
        });
        return cjBeans;
    }

    public List<CoordinatorJobBean> getCoordinatorJobsOlderThanStatus(final long checkAgeSecs, final String status, final int limit, boolean locking) throws StoreException {
        ParamChecker.notNull(status, "Coord Job Status");
        List<CoordinatorJobBean> cjBeans = this.doOperation("getCoordinatorJobsOlderThanStatus", new Callable<List<CoordinatorJobBean>>(){

            @Override
            public List<CoordinatorJobBean> call() throws StoreException {
                ArrayList<CoordinatorJobBean> jobList = new ArrayList<CoordinatorJobBean>();
                try {
                    Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_COORD_JOBS_OLDER_THAN_STATUS");
                    Timestamp ts = new Timestamp(System.currentTimeMillis() - checkAgeSecs * 1000L);
                    q.setParameter("lastModTime", (Object)ts);
                    q.setParameter("status", (Object)status);
                    if (limit > 0) {
                        q.setMaxResults(limit);
                    }
                    List cjBeans = q.getResultList();
                    for (CoordinatorJobBean j : cjBeans) {
                        jobList.add(j);
                    }
                }
                catch (Exception e) {
                    throw new StoreException(ErrorCode.E0603, e.getMessage(), e);
                }
                return jobList;
            }
        });
        return cjBeans;
    }

    public CoordinatorActionBean getCoordinatorAction(final String id, boolean locking) throws StoreException {
        ParamChecker.notEmpty(id, "actionID");
        CoordinatorActionBean caBean = this.doOperation("getCoordinatorAction", new Callable<CoordinatorActionBean>(){

            @Override
            public CoordinatorActionBean call() throws StoreException {
                Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_COORD_ACTION");
                q.setParameter("id", (Object)id);
                OpenJPAQuery oq = OpenJPAPersistence.cast((Query)q);
                CoordinatorActionBean action = null;
                List actions = q.getResultList();
                if (actions.size() <= 0) {
                    throw new StoreException(ErrorCode.E0605, id);
                }
                action = (CoordinatorActionBean)actions.get(0);
                return CoordinatorStore.this.getBeanForRunningCoordAction(action);
            }
        });
        return caBean;
    }

    public List<CoordinatorActionBean> getCoordinatorActionsForJob(final String id, final int numResults, final String executionOrder) throws StoreException {
        ParamChecker.notEmpty(id, "jobID");
        List<CoordinatorActionBean> caBeans = this.doOperation("getCoordinatorActionsForJob", new Callable<List<CoordinatorActionBean>>(){

            @Override
            public List<CoordinatorActionBean> call() throws StoreException {
                Query q = executionOrder.equalsIgnoreCase("FIFO") ? CoordinatorStore.this.entityManager.createNamedQuery("GET_COORD_ACTIONS_FOR_JOB_FIFO") : CoordinatorStore.this.entityManager.createNamedQuery("GET_COORD_ACTIONS_FOR_JOB_LIFO");
                q.setParameter("jobId", (Object)id);
                if (executionOrder.equalsIgnoreCase("LAST_ONLY")) {
                    q.setMaxResults(1);
                } else if (numResults > 0) {
                    q.setMaxResults(numResults);
                }
                List caBeans = q.getResultList();
                return caBeans;
            }
        });
        return caBeans;
    }

    public int getCoordinatorRunningActionsCount(final String id) throws StoreException {
        ParamChecker.notEmpty(id, "jobID");
        Integer cnt = this.doOperation("getCoordinatorRunningActionsCount", new Callable<Integer>(){

            @Override
            public Integer call() throws SQLException {
                Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_COORD_RUNNING_ACTIONS_COUNT");
                q.setParameter("jobId", (Object)id);
                Long count = (Long)q.getSingleResult();
                return count.intValue();
            }
        });
        return cnt;
    }

    public void insertCoordinatorAction(final CoordinatorActionBean action) throws StoreException {
        ParamChecker.notNull(action, "CoordinatorActionBean");
        this.doOperation("insertCoordinatorAction", new Callable<Void>(){

            @Override
            public Void call() throws StoreException {
                CoordinatorStore.this.entityManager.persist((Object)action);
                return null;
            }
        });
    }

    public void updateCoordinatorAction(final CoordinatorActionBean action) throws StoreException {
        ParamChecker.notNull(action, "CoordinatorActionBean");
        this.doOperation("updateCoordinatorAction", new Callable<Void>(){

            @Override
            public Void call() throws StoreException {
                Query q = CoordinatorStore.this.entityManager.createNamedQuery("UPDATE_COORD_ACTION");
                q.setParameter("id", (Object)action.getId());
                CoordinatorStore.this.setActionQueryParameters(action, q);
                q.executeUpdate();
                return null;
            }
        });
    }

    public void updateCoordActionMin(final CoordinatorActionBean action) throws StoreException {
        ParamChecker.notNull(action, "CoordinatorActionBean");
        this.doOperation("updateCoordinatorAction", new Callable<Void>(){

            @Override
            public Void call() throws StoreException {
                Query q = CoordinatorStore.this.entityManager.createNamedQuery("UPDATE_COORD_ACTION_MIN");
                q.setParameter("id", (Object)action.getId());
                q.setParameter("missingDependencies", (Object)action.getMissingDependencies());
                q.setParameter("lastModifiedTime", (Object)new Date());
                q.setParameter("status", (Object)action.getStatus().toString());
                q.setParameter("actionXml", (Object)action.getActionXml());
                q.executeUpdate();
                return null;
            }
        });
    }

    public void updateCoordinatorJob(final CoordinatorJobBean job) throws StoreException {
        ParamChecker.notNull(job, "CoordinatorJobBean");
        this.doOperation("updateJob", new Callable<Void>(){

            @Override
            public Void call() throws StoreException {
                Query q = CoordinatorStore.this.entityManager.createNamedQuery("UPDATE_COORD_JOB");
                q.setParameter("id", (Object)job.getId());
                CoordinatorStore.this.setJobQueryParameters(job, q);
                q.executeUpdate();
                return null;
            }
        });
    }

    public void updateCoordinatorJobStatus(final CoordinatorJobBean job) throws StoreException {
        ParamChecker.notNull(job, "CoordinatorJobBean");
        this.doOperation("updateJobStatus", new Callable<Void>(){

            @Override
            public Void call() throws StoreException {
                Query q = CoordinatorStore.this.entityManager.createNamedQuery("UPDATE_COORD_JOB_STATUS");
                q.setParameter("id", (Object)job.getId());
                q.setParameter("status", (Object)job.getStatus().toString());
                q.setParameter("lastModifiedTime", (Object)new Date());
                q.executeUpdate();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V doOperation(String name, Callable<V> command) throws StoreException {
        try {
            V retVal;
            Instrumentation.Cron cron = new Instrumentation.Cron();
            cron.start();
            try {
                retVal = command.call();
            }
            finally {
                cron.stop();
            }
            Services.get().get(InstrumentationService.class).get().addCron(INSTR_GROUP, name, cron);
            return retVal;
        }
        catch (StoreException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new StoreException(ErrorCode.E0611, name, ex.getMessage(), ex);
        }
        catch (Exception e) {
            throw new StoreException(ErrorCode.E0607, name, e.getMessage(), e);
        }
    }

    private void setJobQueryParameters(CoordinatorJobBean jBean, Query q) {
        q.setParameter("appName", (Object)jBean.getAppName());
        q.setParameter("appPath", (Object)jBean.getAppPath());
        q.setParameter("concurrency", (Object)jBean.getConcurrency());
        q.setParameter("conf", (Object)jBean.getConf());
        q.setParameter("externalId", (Object)jBean.getExternalId());
        q.setParameter("frequency", (Object)jBean.getFrequency());
        q.setParameter("lastActionNumber", (Object)jBean.getLastActionNumber());
        q.setParameter("timeOut", (Object)jBean.getTimeout());
        q.setParameter("timeZone", (Object)jBean.getTimeZone());
        q.setParameter("createdTime", (Object)jBean.getCreatedTimestamp());
        q.setParameter("endTime", (Object)jBean.getEndTimestamp());
        q.setParameter("execution", (Object)jBean.getExecution());
        q.setParameter("jobXml", (Object)jBean.getJobXml());
        q.setParameter("lastAction", (Object)jBean.getLastActionTimestamp());
        q.setParameter("lastModifiedTime", (Object)new Date());
        q.setParameter("nextMaterializedTime", (Object)jBean.getNextMaterializedTimestamp());
        q.setParameter("origJobXml", (Object)jBean.getOrigJobXml());
        q.setParameter("slaXml", (Object)jBean.getSlaXml());
        q.setParameter("startTime", (Object)jBean.getStartTimestamp());
        q.setParameter("status", (Object)jBean.getStatus().toString());
        q.setParameter("timeUnit", (Object)jBean.getTimeUnitStr());
    }

    private void setActionQueryParameters(CoordinatorActionBean aBean, Query q) {
        q.setParameter("actionNumber", (Object)aBean.getActionNumber());
        q.setParameter("actionXml", (Object)aBean.getActionXml());
        q.setParameter("consoleUrl", (Object)aBean.getConsoleUrl());
        q.setParameter("createdConf", (Object)aBean.getCreatedConf());
        q.setParameter("errorCode", (Object)aBean.getErrorCode());
        q.setParameter("errorMessage", (Object)aBean.getErrorMessage());
        q.setParameter("externalStatus", (Object)aBean.getExternalStatus());
        q.setParameter("missingDependencies", (Object)aBean.getMissingDependencies());
        q.setParameter("runConf", (Object)aBean.getRunConf());
        q.setParameter("timeOut", (Object)aBean.getTimeOut());
        q.setParameter("trackerUri", (Object)aBean.getTrackerUri());
        q.setParameter("type", (Object)aBean.getType());
        q.setParameter("createdTime", (Object)aBean.getCreatedTimestamp());
        q.setParameter("externalId", (Object)aBean.getExternalId());
        q.setParameter("jobId", (Object)aBean.getJobId());
        q.setParameter("lastModifiedTime", (Object)new Date());
        q.setParameter("nominalTime", (Object)aBean.getNominalTimestamp());
        q.setParameter("slaXml", (Object)aBean.getSlaXml());
        q.setParameter("status", (Object)aBean.getStatus().toString());
    }

    public void purge(final long olderThanDays, final int limit) throws StoreException {
        this.doOperation("coord-purge", new Callable<Void>(){

            @Override
            public Void call() throws SQLException, StoreException, WorkflowException {
                Timestamp lastModTm = new Timestamp(System.currentTimeMillis() - olderThanDays * 86400000L);
                Query jobQ = CoordinatorStore.this.entityManager.createNamedQuery("GET_COMPLETED_COORD_JOBS_OLDER_THAN_STATUS");
                jobQ.setParameter("lastModTime", (Object)lastModTm);
                jobQ.setMaxResults(limit);
                List coordJobs = jobQ.getResultList();
                int actionDeleted = 0;
                if (coordJobs.size() != 0) {
                    for (CoordinatorJobBean coord : coordJobs) {
                        String jobId = coord.getId();
                        CoordinatorStore.this.entityManager.remove((Object)coord);
                        Query g = CoordinatorStore.this.entityManager.createNamedQuery("DELETE_COMPLETED_ACTIONS_FOR_COORDINATOR");
                        g.setParameter("jobId", (Object)jobId);
                        actionDeleted += g.executeUpdate();
                    }
                }
                XLog.getLog(this.getClass()).debug("ENDED Coord Purge deleted jobs :" + coordJobs.size() + " and actions " + actionDeleted);
                return null;
            }
        });
    }

    public void commit() throws StoreException {
    }

    public void close() throws StoreException {
    }

    public CoordinatorJobBean getCoordinatorJobs(String id) {
        return null;
    }

    public CoordinatorJobInfo getCoordinatorInfo(final Map<String, List<String>> filter, final int start, final int len) throws StoreException {
        CoordinatorJobInfo coordJobInfo = this.doOperation("getCoordinatorJobInfo", new Callable<CoordinatorJobInfo>(){

            @Override
            public CoordinatorJobInfo call() throws SQLException, StoreException {
                List resultList;
                ArrayList<String> orArray = new ArrayList<String>();
                ArrayList<String> colArray = new ArrayList<String>();
                ArrayList<String> valArray = new ArrayList<String>();
                StringBuilder sb = new StringBuilder("");
                StoreStatusFilter.filter(filter, orArray, colArray, valArray, sb, "Select w.id, w.appName, w.status, w.user, w.group, w.startTimestamp, w.endTimestamp, w.appPath, w.concurrency, w.frequency, w.lastActionTimestamp, w.nextMaterializedTimestamp, w.createdTimestamp, w.timeUnitStr, w.timeZone, w.timeOut from CoordinatorJobBean w", "Select count(w) from CoordinatorJobBean w");
                int realLen = 0;
                Query q = null;
                Query qTotal = null;
                if (orArray.size() == 0) {
                    q = CoordinatorStore.this.entityManager.createNamedQuery("GET_COORD_JOBS_COLUMNS");
                    q.setFirstResult(start - 1);
                    q.setMaxResults(len);
                    qTotal = CoordinatorStore.this.entityManager.createNamedQuery("GET_COORD_JOBS_COUNT");
                } else {
                    StringBuilder sbTotal = new StringBuilder(sb);
                    sb.append(" order by w.createdTimestamp desc ");
                    XLog.getLog(this.getClass()).debug("Created String is **** " + sb.toString());
                    q = CoordinatorStore.this.entityManager.createQuery(sb.toString());
                    q.setFirstResult(start - 1);
                    q.setMaxResults(len);
                    qTotal = CoordinatorStore.this.entityManager.createQuery(sbTotal.toString().replace("Select w.id, w.appName, w.status, w.user, w.group, w.startTimestamp, w.endTimestamp, w.appPath, w.concurrency, w.frequency, w.lastActionTimestamp, w.nextMaterializedTimestamp, w.createdTimestamp, w.timeUnitStr, w.timeZone, w.timeOut from CoordinatorJobBean w", "Select count(w) from CoordinatorJobBean w"));
                }
                for (int i = 0; i < orArray.size(); ++i) {
                    q.setParameter((String)colArray.get(i), valArray.get(i));
                    qTotal.setParameter((String)colArray.get(i), valArray.get(i));
                }
                OpenJPAQuery kq = OpenJPAPersistence.cast((Query)q);
                JDBCFetchPlan fetch = (JDBCFetchPlan)kq.getFetchPlan();
                fetch.setFetchBatchSize(20);
                fetch.setResultSetType(ResultSetType.SCROLL_INSENSITIVE);
                fetch.setFetchDirection(FetchDirection.FORWARD);
                fetch.setLRSSizeAlgorithm(LRSSizeAlgorithm.LAST);
                List objectArrList = resultList = q.getResultList();
                ArrayList<CoordinatorJobBean> coordBeansList = new ArrayList<CoordinatorJobBean>();
                for (Object[] arr : objectArrList) {
                    CoordinatorJobBean ww = CoordinatorStore.this.getBeanForCoordinatorJobFromArray(arr);
                    coordBeansList.add(ww);
                }
                realLen = ((Long)qTotal.getSingleResult()).intValue();
                return new CoordinatorJobInfo(coordBeansList, start, len, realLen);
            }
        });
        return coordJobInfo;
    }

    private CoordinatorJobBean getBeanForCoordinatorJobFromArray(Object[] arr) {
        CoordinatorJobBean bean = new CoordinatorJobBean();
        bean.setId((String)arr[0]);
        if (arr[1] != null) {
            bean.setAppName((String)arr[1]);
        }
        if (arr[2] != null) {
            bean.setStatus(Job.Status.valueOf((String)((String)arr[2])));
        }
        if (arr[3] != null) {
            bean.setUser((String)arr[3]);
        }
        if (arr[4] != null) {
            bean.setGroup((String)arr[4]);
        }
        if (arr[5] != null) {
            bean.setStartTime((Timestamp)arr[5]);
        }
        if (arr[6] != null) {
            bean.setEndTime((Timestamp)arr[6]);
        }
        if (arr[7] != null) {
            bean.setAppPath((String)arr[7]);
        }
        if (arr[8] != null) {
            bean.setConcurrency((Integer)arr[8]);
        }
        if (arr[9] != null) {
            bean.setFrequency((String)arr[9]);
        }
        if (arr[10] != null) {
            bean.setLastActionTime((Timestamp)arr[10]);
        }
        if (arr[11] != null) {
            bean.setNextMaterializedTime((Timestamp)arr[11]);
        }
        if (arr[13] != null) {
            bean.setTimeUnit(CoordinatorJob.Timeunit.valueOf((String)((String)arr[13])));
        }
        if (arr[14] != null) {
            bean.setTimeZone((String)arr[14]);
        }
        if (arr[15] != null) {
            bean.setTimeout((Integer)arr[15]);
        }
        return bean;
    }

    public Integer getActionsForCoordinatorJob(final String jobId, boolean locking) throws StoreException {
        ParamChecker.notEmpty(jobId, "CoordinatorJobID");
        Integer actionsCount = this.doOperation("getActionsForCoordinatorJob", new Callable<Integer>(){

            @Override
            public Integer call() throws StoreException {
                ArrayList actionList = new ArrayList();
                try {
                    Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_ACTIONS_FOR_COORD_JOB");
                    q.setParameter("jobId", (Object)jobId);
                    Long count = (Long)q.getSingleResult();
                    return count.intValue();
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
            }
        });
        return actionsCount;
    }

    public List<CoordinatorActionBean> getActionsSubsetForCoordinatorJob(final String jobId, final int start, final int len) throws StoreException {
        ParamChecker.notEmpty(jobId, "CoordinatorJobID");
        List<CoordinatorActionBean> actions = this.doOperation("getActionsForCoordinatorJob", new Callable<List<CoordinatorActionBean>>(){

            @Override
            public List<CoordinatorActionBean> call() throws StoreException {
                ArrayList<CoordinatorActionBean> actionList = new ArrayList<CoordinatorActionBean>();
                try {
                    Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_ACTIONS_FOR_COORD_JOB");
                    q.setParameter("jobId", (Object)jobId);
                    q.setFirstResult(start - 1);
                    q.setMaxResults(len);
                    List actions = q.getResultList();
                    for (CoordinatorActionBean a : actions) {
                        CoordinatorActionBean aa = CoordinatorStore.this.getBeanForRunningCoordAction(a);
                        actionList.add(aa);
                    }
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
                return actionList;
            }
        });
        return actions;
    }

    protected CoordinatorActionBean getBeanForRunningCoordAction(CoordinatorActionBean a) {
        if (a != null) {
            CoordinatorActionBean action = new CoordinatorActionBean();
            action.setId(a.getId());
            action.setActionNumber(a.getActionNumber());
            action.setActionXml(a.getActionXml());
            action.setConsoleUrl(a.getConsoleUrl());
            action.setCreatedConf(a.getCreatedConf());
            action.setExternalStatus(a.getExternalStatus());
            action.setMissingDependencies(a.getMissingDependencies());
            action.setRunConf(a.getRunConf());
            action.setTimeOut(a.getTimeOut());
            action.setTrackerUri(a.getTrackerUri());
            action.setType(a.getType());
            action.setCreatedTime(a.getCreatedTime());
            action.setExternalId(a.getExternalId());
            action.setJobId(a.getJobId());
            action.setLastModifiedTime(a.getLastModifiedTime());
            action.setNominalTime(a.getNominalTime());
            action.setSlaXml(a.getSlaXml());
            action.setStatus(a.getStatus());
            return action;
        }
        return null;
    }

    public CoordinatorActionBean getAction(String id, boolean b) {
        return null;
    }

    public List<CoordinatorActionBean> getRunningActionsForCoordinatorJob(final String jobId, boolean locking) throws StoreException {
        ParamChecker.notEmpty(jobId, "CoordinatorJobID");
        List<CoordinatorActionBean> actions = this.doOperation("getRunningActionsForCoordinatorJob", new Callable<List<CoordinatorActionBean>>(){

            @Override
            public List<CoordinatorActionBean> call() throws StoreException {
                try {
                    Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_RUNNING_ACTIONS_FOR_COORD_JOB");
                    q.setParameter("jobId", (Object)jobId);
                    List actions = q.getResultList();
                    return actions;
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
            }
        });
        return actions;
    }

    public List<CoordinatorActionBean> getRunningActionsOlderThan(final long checkAgeSecs, boolean locking) throws StoreException {
        List<CoordinatorActionBean> actions = this.doOperation("getRunningActionsOlderThan", new Callable<List<CoordinatorActionBean>>(){

            @Override
            public List<CoordinatorActionBean> call() throws StoreException {
                Timestamp ts = new Timestamp(System.currentTimeMillis() - checkAgeSecs * 1000L);
                try {
                    Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_RUNNING_ACTIONS_OLDER_THAN");
                    q.setParameter("lastModifiedTime", (Object)ts);
                    List actions = q.getResultList();
                    return actions;
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
            }
        });
        return actions;
    }

    public List<CoordinatorActionBean> getRecoveryActionsOlderThan(final long checkAgeSecs, boolean locking) throws StoreException {
        List<CoordinatorActionBean> actions = this.doOperation("getRunningActionsOlderThan", new Callable<List<CoordinatorActionBean>>(){

            @Override
            public List<CoordinatorActionBean> call() throws StoreException {
                try {
                    Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_COORD_ACTIONS_FOR_RECOVERY_OLDER_THAN");
                    Timestamp ts = new Timestamp(System.currentTimeMillis() - checkAgeSecs * 1000L);
                    q.setParameter("lastModifiedTime", (Object)ts);
                    List actions = q.getResultList();
                    return actions;
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
            }
        });
        return actions;
    }

    public List<CoordinatorActionBean> getCoordActionsForDates(final String jobId, final Date startDate, final Date endDate) throws StoreException {
        List<CoordinatorActionBean> actions = this.doOperation("getCoordActionsForDates", new Callable<List<CoordinatorActionBean>>(){

            @Override
            public List<CoordinatorActionBean> call() throws StoreException {
                try {
                    Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_ACTIONS_FOR_DATES");
                    q.setParameter("jobId", (Object)jobId);
                    q.setParameter("startTime", (Object)new Timestamp(startDate.getTime()));
                    q.setParameter("endTime", (Object)new Timestamp(endDate.getTime()));
                    List actions = q.getResultList();
                    ArrayList<CoordinatorActionBean> actionList = new ArrayList<CoordinatorActionBean>();
                    for (CoordinatorActionBean a : actions) {
                        CoordinatorActionBean aa = CoordinatorStore.this.getBeanForRunningCoordAction(a);
                        actionList.add(aa);
                    }
                    return actionList;
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
            }
        });
        return actions;
    }

    public CoordinatorActionBean getCoordActionForNominalTime(final String jobId, final Date nominalTime) throws StoreException {
        CoordinatorActionBean action = this.doOperation("getCoordActionForNominalTime", new Callable<CoordinatorActionBean>(){

            @Override
            public CoordinatorActionBean call() throws StoreException {
                Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_ACTION_FOR_NOMINALTIME");
                q.setParameter("jobId", (Object)jobId);
                q.setParameter("nominalTime", (Object)new Timestamp(nominalTime.getTime()));
                List actions = q.getResultList();
                CoordinatorActionBean action = null;
                if (actions.size() <= 0) {
                    throw new StoreException(ErrorCode.E0605, DateUtils.formatDateOozieTZ(nominalTime));
                }
                action = (CoordinatorActionBean)actions.get(0);
                return CoordinatorStore.this.getBeanForRunningCoordAction(action);
            }
        });
        return action;
    }

    public List<String> getRecoveryActionsGroupByJobId(final long checkAgeSecs) throws StoreException {
        List<String> jobids = this.doOperation("getRecoveryActionsGroupByJobId", new Callable<List<String>>(){

            @Override
            public List<String> call() throws StoreException {
                ArrayList<String> jobids = new ArrayList<String>();
                try {
                    Query q = CoordinatorStore.this.entityManager.createNamedQuery("GET_READY_ACTIONS_GROUP_BY_JOBID");
                    Timestamp ts = new Timestamp(System.currentTimeMillis() - checkAgeSecs * 1000L);
                    q.setParameter(1, (Object)ts);
                    List list = q.getResultList();
                    for (Object[] arr : list) {
                        if (arr == null || arr[0] == null) continue;
                        jobids.add((String)arr[0]);
                    }
                    return jobids;
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
            }
        });
        return jobids;
    }
}

