/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.client.event.message.SLAMessage;
import org.apache.oozie.event.messaging.MessageFactory;
import org.apache.oozie.event.messaging.MessageSerializer;
import org.apache.oozie.jms.ConnectionContext;
import org.apache.oozie.jms.JMSConnectionInfo;
import org.apache.oozie.service.JMSAccessorService;
import org.apache.oozie.service.JMSTopicService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.listener.SLAEventListener;
import org.apache.oozie.util.XLog;

public class JMSSLAEventListener
extends SLAEventListener {
    private JMSAccessorService jmsService = Services.get().get(JMSAccessorService.class);
    private JMSTopicService jmsTopicService = Services.get().get(JMSTopicService.class);
    private JMSConnectionInfo connInfo;
    private int jmsSessionOpts;
    private int jmsDeliveryMode;
    private int jmsExpirationDate;
    private ConnectionContext jmsContext;
    private static XLog LOG;

    @Override
    public void init(Configuration conf) throws Exception {
        String jmsProps = conf.get("oozie.jms.producer.connection.properties");
        this.connInfo = new JMSConnectionInfo(jmsProps);
        LOG = XLog.getLog(this.getClass());
        this.jmsSessionOpts = conf.getInt("oozie.jms.producer.session.opts", 1);
        this.jmsDeliveryMode = conf.getInt("oozie.jms.delivery.mode", 2);
        this.jmsExpirationDate = conf.getInt("oozie.jms.expiration.date", 0);
    }

    @Override
    public void onStartMiss(SLAEvent event) {
        this.sendSLANotification(event);
    }

    @Override
    public void onEndMiss(SLAEvent event) {
        this.sendSLANotification(event);
    }

    @Override
    public void onDurationMiss(SLAEvent event) {
        this.sendSLANotification(event);
    }

    @Override
    public void onStartMet(SLAEvent event) {
        this.sendSLANotification(event);
    }

    @Override
    public void onEndMet(SLAEvent event) {
        this.sendSLANotification(event);
    }

    @Override
    public void onDurationMet(SLAEvent event) {
        this.sendSLANotification(event);
    }

    protected void sendSLANotification(SLAEvent event) {
        SLAMessage slaMsg = MessageFactory.createSLAMessage(event);
        MessageSerializer serializer = MessageFactory.getMessageSerializer();
        String messageBody = serializer.getSerializedObject(slaMsg);
        String serializerMessageFormat = serializer.getMessageFormat();
        String topicName = this.getTopic(event);
        this.sendJMSMessage(slaMsg, messageBody, topicName, serializerMessageFormat);
    }

    protected void sendJMSMessage(SLAMessage slaMsg, String messageBody, String topicName, String messageFormat) {
        this.jmsContext = this.jmsService.createProducerConnectionContext(this.connInfo);
        if (this.jmsContext != null) {
            try {
                Session session = this.jmsContext.createThreadLocalSession(this.jmsSessionOpts);
                TextMessage textMessage = session.createTextMessage(messageBody);
                textMessage.setStringProperty("eventStatus", slaMsg.getEventStatus().toString());
                textMessage.setStringProperty("slaStatus", slaMsg.getSLAStatus().toString());
                textMessage.setStringProperty("appType", slaMsg.getAppType().toString());
                textMessage.setStringProperty("msgType", slaMsg.getMessageType().toString());
                textMessage.setStringProperty("appName", slaMsg.getAppName());
                textMessage.setStringProperty("user", slaMsg.getUser());
                textMessage.setStringProperty("msgFormat", messageFormat);
                LOG.trace("Event related JMS text body [{0}]", textMessage.getText());
                LOG.trace("Event related JMS message [{0}]", textMessage.toString());
                MessageProducer producer = this.jmsContext.createProducer(session, topicName);
                producer.setDeliveryMode(this.jmsDeliveryMode);
                producer.setTimeToLive((long)this.jmsExpirationDate);
                producer.send((Message)textMessage);
                producer.close();
            }
            catch (JMSException jmse) {
                LOG.error((Object)("Exception happened while sending event related jms message :" + messageBody), jmse);
            }
        } else {
            LOG.warn("No connection. Not sending message" + messageBody);
        }
    }

    public String getTopic(SLAEvent event) {
        if (this.jmsTopicService != null) {
            return this.jmsTopicService.getTopic(event.getAppType(), event.getUser(), event.getId(), event.getParentId());
        }
        throw new RuntimeException("JMSTopicService is not initialized");
    }

    @Override
    public void destroy() {
    }
}

