/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class WorkflowJobsGetFromParentIdJPAExecutor
implements JPAExecutor<List<String>> {
    private String parentId;
    private int limit;
    private int offset;

    public WorkflowJobsGetFromParentIdJPAExecutor(String parentId, int limit) {
        this(parentId, 0, limit);
    }

    public WorkflowJobsGetFromParentIdJPAExecutor(String parentId, int offset, int limit) {
        this.parentId = parentId;
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    public String getName() {
        return "WorkflowJobsGetFromParentIdJPAExecutor";
    }

    @Override
    public List<String> execute(EntityManager em) throws JPAExecutorException {
        List workflows = null;
        try {
            Query jobQ = em.createNamedQuery("GET_WORKFLOWS_WITH_PARENT_ID");
            jobQ.setParameter("parentId", (Object)this.parentId);
            jobQ.setMaxResults(this.limit);
            jobQ.setFirstResult(this.offset);
            workflows = jobQ.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return workflows;
    }
}

