/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordActionUpdateStatusJPAExecutor
implements JPAExecutor<Void> {
    private CoordinatorActionBean coordAction = null;

    public CoordActionUpdateStatusJPAExecutor(CoordinatorActionBean coordAction) {
        ParamChecker.notNull(coordAction, "coordAction");
        this.coordAction = coordAction;
    }

    @Override
    public Void execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("UPDATE_COORD_ACTION_STATUS_PENDING_TIME");
            q.setParameter("id", (Object)this.coordAction.getId());
            q.setParameter("status", (Object)this.coordAction.getStatus().toString());
            q.setParameter("pending", (Object)this.coordAction.getPending());
            q.setParameter("lastModifiedTime", (Object)new Date());
            q.executeUpdate();
            return null;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "CoordActionUpdateStatusJPAExecutor";
    }
}

