/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class BundleActionsGetStatusPendingJPAExecutor
implements JPAExecutor<List<BundleActionBean>> {
    private String bundleId = null;

    public BundleActionsGetStatusPendingJPAExecutor(String bundleId) {
        ParamChecker.notNull(bundleId, "bundleId");
        this.bundleId = bundleId;
    }

    @Override
    public String getName() {
        return "BundleActionsGetStatusPendingJPAExecutor";
    }

    @Override
    public List<BundleActionBean> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<BundleActionBean> baBeans = new ArrayList<BundleActionBean>();
        try {
            Query q = em.createNamedQuery("GET_BUNDLE_ACTION_STATUS_PENDING_FOR_BUNDLE");
            q.setParameter("bundleId", (Object)this.bundleId);
            List bundleActionList = q.getResultList();
            for (Object[] a : bundleActionList) {
                BundleActionBean bab = this.createBeanFromBundle(a);
                baBeans.add(bab);
            }
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return baBeans;
    }

    private BundleActionBean createBeanFromBundle(Object[] arr) {
        BundleActionBean bab = new BundleActionBean();
        if (arr[0] != null) {
            bab.setCoordId((String)arr[0]);
        }
        if (arr[1] != null) {
            bab.setStatus(Job.Status.valueOf((String)((String)arr[1])));
        }
        if (arr[2] != null) {
            bab.setPending((Integer)arr[2]);
        }
        return bab;
    }
}

