/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.rest;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonCoordinatorAction;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity
@Table(name="COORD_JOBS")
@DiscriminatorColumn(name="bean_type", discriminatorType=DiscriminatorType.STRING)
public class JsonCoordinatorJob
implements CoordinatorJob,
JsonBean,
PersistenceCapable {
    @Id
    private String id;
    @Basic
    @Column(name="app_path")
    private String appPath = null;
    @Basic
    @Column(name="app_name")
    private String appName = null;
    @Basic
    @Column(name="external_id")
    private String externalId = null;
    @Column(name="conf")
    @Lob
    private String conf = null;
    @Transient
    private Job.Status status = Job.Status.PREP;
    @Transient
    private CoordinatorJob.Execution executionOrder = CoordinatorJob.Execution.FIFO;
    @Transient
    private Date startTime;
    @Transient
    private Date endTime;
    @Transient
    private Date pauseTime;
    @Basic
    @Column(name="frequency")
    private String frequency = "0";
    @Basic
    @Column(name="time_zone")
    private String timeZone = null;
    @Basic
    @Column(name="concurrency")
    private int concurrency = 0;
    @Basic
    @Column(name="mat_throttling")
    private int matThrottling = 0;
    @Transient
    private CoordinatorJob.Timeunit timeUnit = CoordinatorJob.Timeunit.MINUTE;
    @Basic
    @Column(name="time_out")
    private int timeOut = 0;
    @Transient
    private Date lastAction;
    @Basic
    @Column(name="last_action_number")
    private int lastActionNumber;
    @Transient
    private Date nextMaterializedTime;
    @Basic
    @Column(name="user_name")
    private String user = null;
    @Basic
    @Column(name="group_name")
    private String group = null;
    @Basic
    @Column(name="bundle_id")
    private String bundleId = null;
    @Transient
    private String consoleUrl;
    @Transient
    private List<? extends JsonCoordinatorAction> actions = new ArrayList<JsonCoordinatorAction>();
    @Transient
    private int pending = 0;
    @Transient
    private int numActions = 0;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob;
    private transient Object pcDetachedState;

    @Override
    public JSONObject toJSONObject() {
        return this.toJSONObject("GMT");
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        JSONObject json = new JSONObject();
        json.put((Object)"coordJobPath", (Object)this.getAppPath());
        json.put((Object)"coordJobName", (Object)this.getAppName());
        json.put((Object)"coordJobId", (Object)this.getId());
        json.put((Object)"coordExternalId", (Object)this.getExternalId());
        json.put((Object)"bundleId", (Object)this.getBundleId());
        json.put((Object)"conf", (Object)this.getConf());
        json.put((Object)"status", (Object)this.getStatus().toString());
        json.put((Object)"executionPolicy", (Object)this.getExecutionOrder().toString());
        json.put((Object)"frequency", (Object)this.getFrequency());
        json.put((Object)"timeUnit", (Object)this.getTimeUnit().toString());
        json.put((Object)"timeZone", (Object)this.getTimeZone());
        json.put((Object)"concurrency", (Object)this.getConcurrency());
        json.put((Object)"timeOut", (Object)this.getTimeout());
        json.put((Object)"lastAction", (Object)JsonUtils.formatDateRfc822((Date)this.getLastActionTime(), (String)timeZoneId));
        json.put((Object)"nextMaterializedTime", (Object)JsonUtils.formatDateRfc822((Date)this.getNextMaterializedTime(), (String)timeZoneId));
        json.put((Object)"startTime", (Object)JsonUtils.formatDateRfc822((Date)this.getStartTime(), (String)timeZoneId));
        json.put((Object)"endTime", (Object)JsonUtils.formatDateRfc822((Date)this.getEndTime(), (String)timeZoneId));
        json.put((Object)"pauseTime", (Object)JsonUtils.formatDateRfc822((Date)this.getPauseTime(), (String)timeZoneId));
        json.put((Object)"user", (Object)this.getUser());
        json.put((Object)"group", (Object)this.getGroup());
        json.put((Object)"acl", (Object)this.getAcl());
        json.put((Object)"consoleUrl", (Object)this.getConsoleUrl());
        json.put((Object)"mat_throttling", (Object)this.getMatThrottling());
        json.put((Object)"actions", (Object)JsonCoordinatorAction.toJSONArray(this.actions, timeZoneId));
        json.put((Object)"toString", (Object)this.toString());
        json.put((Object)"total", (Object)this.numActions);
        return json;
    }

    public String getAppPath() {
        return JsonCoordinatorJob.pcGetappPath(this);
    }

    public void setAppPath(String appPath) {
        JsonCoordinatorJob.pcSetappPath(this, appPath);
    }

    public String getAppName() {
        return JsonCoordinatorJob.pcGetappName(this);
    }

    public void setAppName(String appName) {
        JsonCoordinatorJob.pcSetappName(this, appName);
    }

    public String getId() {
        return JsonCoordinatorJob.pcGetid(this);
    }

    public void setId(String id) {
        JsonCoordinatorJob.pcSetid(this, id);
    }

    public void setExternalId(String externalId) {
        JsonCoordinatorJob.pcSetexternalId(this, externalId);
    }

    public String getExternalId() {
        return JsonCoordinatorJob.pcGetexternalId(this);
    }

    public String getConf() {
        return JsonCoordinatorJob.pcGetconf(this);
    }

    public void setConf(String conf) {
        JsonCoordinatorJob.pcSetconf(this, conf);
    }

    public Job.Status getStatus() {
        return this.status;
    }

    public void setStatus(Job.Status status) {
        this.status = status;
    }

    public void setFrequency(String frequency) {
        JsonCoordinatorJob.pcSetfrequency(this, frequency);
    }

    public String getFrequency() {
        return JsonCoordinatorJob.pcGetfrequency(this);
    }

    public void setTimeUnit(CoordinatorJob.Timeunit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public CoordinatorJob.Timeunit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeZone(String timeZone) {
        JsonCoordinatorJob.pcSettimeZone(this, timeZone);
    }

    public String getTimeZone() {
        return JsonCoordinatorJob.pcGettimeZone(this);
    }

    public void setConcurrency(int concurrency) {
        JsonCoordinatorJob.pcSetconcurrency(this, concurrency);
    }

    public int getConcurrency() {
        return JsonCoordinatorJob.pcGetconcurrency(this);
    }

    public int getMatThrottling() {
        return JsonCoordinatorJob.pcGetmatThrottling(this);
    }

    public void setMatThrottling(int matThrottling) {
        JsonCoordinatorJob.pcSetmatThrottling(this, matThrottling);
    }

    public void setExecutionOrder(CoordinatorJob.Execution order) {
        this.executionOrder = order;
    }

    public CoordinatorJob.Execution getExecutionOrder() {
        return this.executionOrder;
    }

    public void setTimeout(int timeOut) {
        JsonCoordinatorJob.pcSettimeOut(this, timeOut);
    }

    public int getTimeout() {
        return JsonCoordinatorJob.pcGettimeOut(this);
    }

    public void setLastActionTime(Date lastAction) {
        this.lastAction = lastAction;
    }

    public Date getLastActionTime() {
        return this.lastAction;
    }

    public Date getNextMaterializedTime() {
        return this.nextMaterializedTime;
    }

    public void setNextMaterializedTime(Date nextMaterializedTime) {
        this.nextMaterializedTime = nextMaterializedTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getPauseTime() {
        return this.pauseTime;
    }

    public void setPauseTime(Date pauseTime) {
        this.pauseTime = pauseTime;
    }

    public String getUser() {
        return JsonCoordinatorJob.pcGetuser(this);
    }

    public void setUser(String user) {
        JsonCoordinatorJob.pcSetuser(this, user);
    }

    public String getGroup() {
        return JsonCoordinatorJob.pcGetgroup(this);
    }

    public String getAcl() {
        return this.getGroup();
    }

    public void setGroup(String group) {
        JsonCoordinatorJob.pcSetgroup(this, group);
    }

    public String getBundleId() {
        return JsonCoordinatorJob.pcGetbundleId(this);
    }

    public void setBundleId(String bundleId) {
        JsonCoordinatorJob.pcSetbundleId(this, bundleId);
    }

    public String getConsoleUrl() {
        return this.consoleUrl;
    }

    public void setConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
    }

    public String toString() {
        return MessageFormat.format("Coordinator application id[{0}] status[{1}]", this.getId(), this.getStatus());
    }

    public void setActions(List<? extends JsonCoordinatorAction> nodes) {
        this.actions = nodes != null ? nodes : new ArrayList();
    }

    public List<CoordinatorAction> getActions() {
        return this.actions;
    }

    public static JSONArray toJSONArray(List<? extends JsonCoordinatorJob> applications, String timeZoneId) {
        JSONArray array = new JSONArray();
        if (applications != null) {
            for (JsonCoordinatorJob jsonCoordinatorJob : applications) {
                array.add((Object)jsonCoordinatorJob.toJSONObject(timeZoneId));
            }
        }
        return array;
    }

    public int getLastActionNumber() {
        return JsonCoordinatorJob.pcGetlastActionNumber(this);
    }

    public void setLastActionNumber(int lastActionNumber) {
        JsonCoordinatorJob.pcSetlastActionNumber(this, lastActionNumber);
    }

    public void setPending() {
        this.pending = 1;
    }

    public void resetPending() {
        this.pending = 0;
    }

    public int getNumActions() {
        return this.numActions;
    }

    public void setNumActions(int numAction) {
        this.numActions = numAction;
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"appName", "appPath", "bundleId", "concurrency", "conf", "externalId", "frequency", "group", "id", "lastActionNumber", "matThrottling", "timeOut", "timeZone", "user"};
        Class[] classArray = new Class[14];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonCoordinatorJob.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonCoordinatorJob.class$("java.lang.String"));
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonCoordinatorJob.class$("java.lang.String"));
        classArray[3] = Integer.TYPE;
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonCoordinatorJob.class$("java.lang.String"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonCoordinatorJob.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonCoordinatorJob.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonCoordinatorJob.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonCoordinatorJob.class$("java.lang.String"));
        classArray[9] = Integer.TYPE;
        classArray[10] = Integer.TYPE;
        classArray[11] = Integer.TYPE;
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonCoordinatorJob.class$("java.lang.String"));
        classArray[13] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonCoordinatorJob.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz2 = class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob != null ? class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob : (class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob = JsonCoordinatorJob.class$("org.apache.oozie.client.rest.JsonCoordinatorJob"));
        PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JsonCoordinatorJob", (PersistenceCapable)new JsonCoordinatorJob());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.appName = null;
        this.appPath = null;
        this.bundleId = null;
        this.concurrency = 0;
        this.conf = null;
        this.externalId = null;
        this.frequency = null;
        this.group = null;
        this.id = null;
        this.lastActionNumber = 0;
        this.matThrottling = 0;
        this.timeOut = 0;
        this.timeZone = null;
        this.user = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JsonCoordinatorJob jsonCoordinatorJob = new JsonCoordinatorJob();
        if (bl) {
            jsonCoordinatorJob.pcClearFields();
        }
        jsonCoordinatorJob.pcStateManager = stateManager;
        jsonCoordinatorJob.pcCopyKeyFieldsFromObjectId(object);
        return jsonCoordinatorJob;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JsonCoordinatorJob jsonCoordinatorJob = new JsonCoordinatorJob();
        if (bl) {
            jsonCoordinatorJob.pcClearFields();
        }
        jsonCoordinatorJob.pcStateManager = stateManager;
        return jsonCoordinatorJob;
    }

    protected static int pcGetManagedFieldCount() {
        return 14;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.appPath = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.bundleId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.concurrency = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.conf = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.frequency = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.group = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.id = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.lastActionNumber = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.matThrottling = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.timeOut = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.timeZone = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.user = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appName);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appPath);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.bundleId);
                return;
            }
            case 3: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.concurrency);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.conf);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.frequency);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.group);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 9: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.lastActionNumber);
                return;
            }
            case 10: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.matThrottling);
                return;
            }
            case 11: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.timeOut);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.timeZone);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.user);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JsonCoordinatorJob jsonCoordinatorJob, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = jsonCoordinatorJob.appName;
                return;
            }
            case 1: {
                this.appPath = jsonCoordinatorJob.appPath;
                return;
            }
            case 2: {
                this.bundleId = jsonCoordinatorJob.bundleId;
                return;
            }
            case 3: {
                this.concurrency = jsonCoordinatorJob.concurrency;
                return;
            }
            case 4: {
                this.conf = jsonCoordinatorJob.conf;
                return;
            }
            case 5: {
                this.externalId = jsonCoordinatorJob.externalId;
                return;
            }
            case 6: {
                this.frequency = jsonCoordinatorJob.frequency;
                return;
            }
            case 7: {
                this.group = jsonCoordinatorJob.group;
                return;
            }
            case 8: {
                this.id = jsonCoordinatorJob.id;
                return;
            }
            case 9: {
                this.lastActionNumber = jsonCoordinatorJob.lastActionNumber;
                return;
            }
            case 10: {
                this.matThrottling = jsonCoordinatorJob.matThrottling;
                return;
            }
            case 11: {
                this.timeOut = jsonCoordinatorJob.timeOut;
                return;
            }
            case 12: {
                this.timeZone = jsonCoordinatorJob.timeZone;
                return;
            }
            case 13: {
                this.user = jsonCoordinatorJob.user;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JsonCoordinatorJob jsonCoordinatorJob = (JsonCoordinatorJob)object;
        if (jsonCoordinatorJob.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jsonCoordinatorJob, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(8 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.id = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob != null ? class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob : (class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob = JsonCoordinatorJob.class$("org.apache.oozie.client.rest.JsonCoordinatorJob"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob != null ? class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob : (class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob = JsonCoordinatorJob.class$("org.apache.oozie.client.rest.JsonCoordinatorJob"));
        return new StringId(clazz, this.id);
    }

    private static final String pcGetappName(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.appName;
        }
        int n = pcInheritedFieldCount + 0;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.appName;
    }

    private static final void pcSetappName(JsonCoordinatorJob jsonCoordinatorJob, String string) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.appName = string;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingStringField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 0, jsonCoordinatorJob.appName, string, 0);
    }

    private static final String pcGetappPath(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.appPath;
        }
        int n = pcInheritedFieldCount + 1;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.appPath;
    }

    private static final void pcSetappPath(JsonCoordinatorJob jsonCoordinatorJob, String string) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.appPath = string;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingStringField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 1, jsonCoordinatorJob.appPath, string, 0);
    }

    private static final String pcGetbundleId(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.bundleId;
        }
        int n = pcInheritedFieldCount + 2;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.bundleId;
    }

    private static final void pcSetbundleId(JsonCoordinatorJob jsonCoordinatorJob, String string) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.bundleId = string;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingStringField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 2, jsonCoordinatorJob.bundleId, string, 0);
    }

    private static final int pcGetconcurrency(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.concurrency;
        }
        int n = pcInheritedFieldCount + 3;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.concurrency;
    }

    private static final void pcSetconcurrency(JsonCoordinatorJob jsonCoordinatorJob, int n) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.concurrency = n;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingIntField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 3, jsonCoordinatorJob.concurrency, n, 0);
    }

    private static final String pcGetconf(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.conf;
        }
        int n = pcInheritedFieldCount + 4;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.conf;
    }

    private static final void pcSetconf(JsonCoordinatorJob jsonCoordinatorJob, String string) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.conf = string;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingStringField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 4, jsonCoordinatorJob.conf, string, 0);
    }

    private static final String pcGetexternalId(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.externalId;
        }
        int n = pcInheritedFieldCount + 5;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.externalId;
    }

    private static final void pcSetexternalId(JsonCoordinatorJob jsonCoordinatorJob, String string) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.externalId = string;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingStringField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 5, jsonCoordinatorJob.externalId, string, 0);
    }

    private static final String pcGetfrequency(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.frequency;
        }
        int n = pcInheritedFieldCount + 6;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.frequency;
    }

    private static final void pcSetfrequency(JsonCoordinatorJob jsonCoordinatorJob, String string) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.frequency = string;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingStringField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 6, jsonCoordinatorJob.frequency, string, 0);
    }

    private static final String pcGetgroup(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.group;
        }
        int n = pcInheritedFieldCount + 7;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.group;
    }

    private static final void pcSetgroup(JsonCoordinatorJob jsonCoordinatorJob, String string) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.group = string;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingStringField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 7, jsonCoordinatorJob.group, string, 0);
    }

    private static final String pcGetid(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.id;
        }
        int n = pcInheritedFieldCount + 8;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.id;
    }

    private static final void pcSetid(JsonCoordinatorJob jsonCoordinatorJob, String string) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.id = string;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingStringField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 8, jsonCoordinatorJob.id, string, 0);
    }

    private static final int pcGetlastActionNumber(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.lastActionNumber;
        }
        int n = pcInheritedFieldCount + 9;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.lastActionNumber;
    }

    private static final void pcSetlastActionNumber(JsonCoordinatorJob jsonCoordinatorJob, int n) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.lastActionNumber = n;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingIntField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 9, jsonCoordinatorJob.lastActionNumber, n, 0);
    }

    private static final int pcGetmatThrottling(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.matThrottling;
        }
        int n = pcInheritedFieldCount + 10;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.matThrottling;
    }

    private static final void pcSetmatThrottling(JsonCoordinatorJob jsonCoordinatorJob, int n) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.matThrottling = n;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingIntField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 10, jsonCoordinatorJob.matThrottling, n, 0);
    }

    private static final int pcGettimeOut(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.timeOut;
        }
        int n = pcInheritedFieldCount + 11;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.timeOut;
    }

    private static final void pcSettimeOut(JsonCoordinatorJob jsonCoordinatorJob, int n) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.timeOut = n;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingIntField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 11, jsonCoordinatorJob.timeOut, n, 0);
    }

    private static final String pcGettimeZone(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.timeZone;
        }
        int n = pcInheritedFieldCount + 12;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.timeZone;
    }

    private static final void pcSettimeZone(JsonCoordinatorJob jsonCoordinatorJob, String string) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.timeZone = string;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingStringField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 12, jsonCoordinatorJob.timeZone, string, 0);
    }

    private static final String pcGetuser(JsonCoordinatorJob jsonCoordinatorJob) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            return jsonCoordinatorJob.user;
        }
        int n = pcInheritedFieldCount + 13;
        jsonCoordinatorJob.pcStateManager.accessingField(n);
        return jsonCoordinatorJob.user;
    }

    private static final void pcSetuser(JsonCoordinatorJob jsonCoordinatorJob, String string) {
        if (jsonCoordinatorJob.pcStateManager == null) {
            jsonCoordinatorJob.user = string;
            return;
        }
        jsonCoordinatorJob.pcStateManager.settingStringField((PersistenceCapable)jsonCoordinatorJob, pcInheritedFieldCount + 13, jsonCoordinatorJob.user, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

