/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.rest;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.oozie.client.BundleJob;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonCoordinatorJob;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity
@Table(name="BUNDLE_JOBS")
@DiscriminatorColumn(name="bean_type", discriminatorType=DiscriminatorType.STRING)
public class JsonBundleJob
implements BundleJob,
JsonBean,
PersistenceCapable {
    @Id
    private String id;
    @Basic
    @Column(name="app_path")
    private String appPath = null;
    @Basic
    @Column(name="app_name")
    private String appName = null;
    @Basic
    @Column(name="external_id")
    private String externalId = null;
    @Column(name="conf")
    @Lob
    private String conf = null;
    @Transient
    private Job.Status status = Job.Status.PREP;
    @Transient
    private Date kickoffTime;
    @Transient
    private Date startTime;
    @Transient
    private Date endTime;
    @Transient
    private Date pauseTime;
    @Transient
    private Date createdTime;
    @Transient
    private BundleJob.Timeunit timeUnit = BundleJob.Timeunit.MINUTE;
    @Basic
    @Column(name="time_out")
    private int timeOut = 0;
    @Basic
    @Column(name="user_name")
    private String user = null;
    @Basic
    @Column(name="group_name")
    private String group = null;
    @Transient
    private String consoleUrl;
    @Transient
    private int pending = 0;
    @Transient
    private List<? extends JsonCoordinatorJob> coordJobs = new ArrayList<JsonCoordinatorJob>();
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$oozie$client$rest$JsonBundleJob;
    private transient Object pcDetachedState;

    @Override
    public JSONObject toJSONObject() {
        return this.toJSONObject("GMT");
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        JSONObject json = new JSONObject();
        json.put((Object)"bundleJobPath", (Object)JsonBundleJob.pcGetappPath(this));
        json.put((Object)"bundleJobName", (Object)JsonBundleJob.pcGetappName(this));
        json.put((Object)"bundleJobId", (Object)JsonBundleJob.pcGetid(this));
        json.put((Object)"bundleExternalId", (Object)JsonBundleJob.pcGetexternalId(this));
        json.put((Object)"conf", (Object)JsonBundleJob.pcGetconf(this));
        json.put((Object)"status", (Object)this.getStatus().toString());
        json.put((Object)"timeUnit", (Object)this.getTimeUnit().toString());
        json.put((Object)"timeOut", (Object)JsonBundleJob.pcGettimeOut(this));
        json.put((Object)"kickoffTime", (Object)JsonUtils.formatDateRfc822((Date)this.getKickoffTime(), (String)timeZoneId));
        json.put((Object)"startTime", (Object)JsonUtils.formatDateRfc822((Date)this.getStartTime(), (String)timeZoneId));
        json.put((Object)"endTime", (Object)JsonUtils.formatDateRfc822((Date)this.getEndTime(), (String)timeZoneId));
        json.put((Object)"pauseTime", (Object)JsonUtils.formatDateRfc822((Date)this.getPauseTime(), (String)timeZoneId));
        json.put((Object)"createdTime", (Object)JsonUtils.formatDateRfc822((Date)this.getCreatedTime(), (String)timeZoneId));
        json.put((Object)"user", (Object)this.getUser());
        json.put((Object)"group", (Object)this.getGroup());
        json.put((Object)"acl", (Object)this.getAcl());
        json.put((Object)"consoleUrl", (Object)this.getConsoleUrl());
        json.put((Object)"bundleCoordJobs", (Object)JsonCoordinatorJob.toJSONArray(this.coordJobs, timeZoneId));
        json.put((Object)"toString", (Object)this.toString());
        return json;
    }

    public String getAppName() {
        return JsonBundleJob.pcGetappName(this);
    }

    public String getAppPath() {
        return JsonBundleJob.pcGetappPath(this);
    }

    public String getConf() {
        return JsonBundleJob.pcGetconf(this);
    }

    public String getConsoleUrl() {
        return this.consoleUrl;
    }

    public List<CoordinatorJob> getCoordinators() {
        return this.coordJobs;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    @Deprecated
    public String getGroup() {
        return JsonBundleJob.pcGetgroup(this);
    }

    public String getAcl() {
        return this.getGroup();
    }

    public String getId() {
        return JsonBundleJob.pcGetid(this);
    }

    public Date getKickoffTime() {
        return this.kickoffTime;
    }

    public Job.Status getStatus() {
        return this.status;
    }

    public BundleJob.Timeunit getTimeUnit() {
        return this.timeUnit;
    }

    public int getTimeout() {
        return JsonBundleJob.pcGettimeOut(this);
    }

    public String getUser() {
        return JsonBundleJob.pcGetuser(this);
    }

    public void setId(String id) {
        JsonBundleJob.pcSetid(this, id);
    }

    public void setAppPath(String bundlePath) {
        JsonBundleJob.pcSetappPath(this, bundlePath);
    }

    public void setAppName(String bundleName) {
        JsonBundleJob.pcSetappName(this, bundleName);
    }

    public String getExternalId() {
        return JsonBundleJob.pcGetexternalId(this);
    }

    public void setExternalId(String externalId) {
        JsonBundleJob.pcSetexternalId(this, externalId);
    }

    public void setConf(String conf) {
        JsonBundleJob.pcSetconf(this, conf);
    }

    public void setStatus(Job.Status status) {
        this.status = status;
    }

    public void setKickoffTime(Date kickoffTime) {
        this.kickoffTime = kickoffTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getPauseTime() {
        return this.pauseTime;
    }

    public void setPauseTime(Date pauseTime) {
        this.pauseTime = pauseTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public void setTimeUnit(BundleJob.Timeunit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setTimeOut(int timeOut) {
        JsonBundleJob.pcSettimeOut(this, timeOut);
    }

    public void setUser(String user) {
        JsonBundleJob.pcSetuser(this, user);
    }

    public void setGroup(String group) {
        JsonBundleJob.pcSetgroup(this, group);
    }

    public void setConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
    }

    public void setCoordJobs(List<? extends JsonCoordinatorJob> coordJobs) {
        this.coordJobs = coordJobs != null ? coordJobs : new ArrayList();
    }

    public static JSONArray toJSONArray(List<? extends JsonBundleJob> applications, String timeZoneId) {
        JSONArray array = new JSONArray();
        if (applications != null) {
            for (JsonBundleJob jsonBundleJob : applications) {
                array.add((Object)jsonBundleJob.toJSONObject(timeZoneId));
            }
        }
        return array;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setPending() {
        this.pending = 1;
    }

    public void resetPending() {
        this.pending = 0;
    }

    public String toString() {
        return MessageFormat.format("Bundle id[{0}] status[{1}]", this.getId(), this.getStatus());
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"appName", "appPath", "conf", "externalId", "group", "id", "timeOut", "user"};
        Class[] classArray = new Class[8];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonBundleJob.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonBundleJob.class$("java.lang.String"));
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonBundleJob.class$("java.lang.String"));
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonBundleJob.class$("java.lang.String"));
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonBundleJob.class$("java.lang.String"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonBundleJob.class$("java.lang.String"));
        classArray[6] = Integer.TYPE;
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonBundleJob.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz2 = class$Lorg$apache$oozie$client$rest$JsonBundleJob != null ? class$Lorg$apache$oozie$client$rest$JsonBundleJob : (class$Lorg$apache$oozie$client$rest$JsonBundleJob = JsonBundleJob.class$("org.apache.oozie.client.rest.JsonBundleJob"));
        PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JsonBundleJob", (PersistenceCapable)new JsonBundleJob());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.appName = null;
        this.appPath = null;
        this.conf = null;
        this.externalId = null;
        this.group = null;
        this.id = null;
        this.timeOut = 0;
        this.user = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JsonBundleJob jsonBundleJob = new JsonBundleJob();
        if (bl) {
            jsonBundleJob.pcClearFields();
        }
        jsonBundleJob.pcStateManager = stateManager;
        jsonBundleJob.pcCopyKeyFieldsFromObjectId(object);
        return jsonBundleJob;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JsonBundleJob jsonBundleJob = new JsonBundleJob();
        if (bl) {
            jsonBundleJob.pcClearFields();
        }
        jsonBundleJob.pcStateManager = stateManager;
        return jsonBundleJob;
    }

    protected static int pcGetManagedFieldCount() {
        return 8;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.appPath = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.conf = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.group = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.id = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.timeOut = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.user = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appName);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appPath);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.conf);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.group);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 6: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.timeOut);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.user);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JsonBundleJob jsonBundleJob, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = jsonBundleJob.appName;
                return;
            }
            case 1: {
                this.appPath = jsonBundleJob.appPath;
                return;
            }
            case 2: {
                this.conf = jsonBundleJob.conf;
                return;
            }
            case 3: {
                this.externalId = jsonBundleJob.externalId;
                return;
            }
            case 4: {
                this.group = jsonBundleJob.group;
                return;
            }
            case 5: {
                this.id = jsonBundleJob.id;
                return;
            }
            case 6: {
                this.timeOut = jsonBundleJob.timeOut;
                return;
            }
            case 7: {
                this.user = jsonBundleJob.user;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JsonBundleJob jsonBundleJob = (JsonBundleJob)object;
        if (jsonBundleJob.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jsonBundleJob, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(5 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.id = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonBundleJob != null ? class$Lorg$apache$oozie$client$rest$JsonBundleJob : (class$Lorg$apache$oozie$client$rest$JsonBundleJob = JsonBundleJob.class$("org.apache.oozie.client.rest.JsonBundleJob"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonBundleJob != null ? class$Lorg$apache$oozie$client$rest$JsonBundleJob : (class$Lorg$apache$oozie$client$rest$JsonBundleJob = JsonBundleJob.class$("org.apache.oozie.client.rest.JsonBundleJob"));
        return new StringId(clazz, this.id);
    }

    private static final String pcGetappName(JsonBundleJob jsonBundleJob) {
        if (jsonBundleJob.pcStateManager == null) {
            return jsonBundleJob.appName;
        }
        int n = pcInheritedFieldCount + 0;
        jsonBundleJob.pcStateManager.accessingField(n);
        return jsonBundleJob.appName;
    }

    private static final void pcSetappName(JsonBundleJob jsonBundleJob, String string) {
        if (jsonBundleJob.pcStateManager == null) {
            jsonBundleJob.appName = string;
            return;
        }
        jsonBundleJob.pcStateManager.settingStringField((PersistenceCapable)jsonBundleJob, pcInheritedFieldCount + 0, jsonBundleJob.appName, string, 0);
    }

    private static final String pcGetappPath(JsonBundleJob jsonBundleJob) {
        if (jsonBundleJob.pcStateManager == null) {
            return jsonBundleJob.appPath;
        }
        int n = pcInheritedFieldCount + 1;
        jsonBundleJob.pcStateManager.accessingField(n);
        return jsonBundleJob.appPath;
    }

    private static final void pcSetappPath(JsonBundleJob jsonBundleJob, String string) {
        if (jsonBundleJob.pcStateManager == null) {
            jsonBundleJob.appPath = string;
            return;
        }
        jsonBundleJob.pcStateManager.settingStringField((PersistenceCapable)jsonBundleJob, pcInheritedFieldCount + 1, jsonBundleJob.appPath, string, 0);
    }

    private static final String pcGetconf(JsonBundleJob jsonBundleJob) {
        if (jsonBundleJob.pcStateManager == null) {
            return jsonBundleJob.conf;
        }
        int n = pcInheritedFieldCount + 2;
        jsonBundleJob.pcStateManager.accessingField(n);
        return jsonBundleJob.conf;
    }

    private static final void pcSetconf(JsonBundleJob jsonBundleJob, String string) {
        if (jsonBundleJob.pcStateManager == null) {
            jsonBundleJob.conf = string;
            return;
        }
        jsonBundleJob.pcStateManager.settingStringField((PersistenceCapable)jsonBundleJob, pcInheritedFieldCount + 2, jsonBundleJob.conf, string, 0);
    }

    private static final String pcGetexternalId(JsonBundleJob jsonBundleJob) {
        if (jsonBundleJob.pcStateManager == null) {
            return jsonBundleJob.externalId;
        }
        int n = pcInheritedFieldCount + 3;
        jsonBundleJob.pcStateManager.accessingField(n);
        return jsonBundleJob.externalId;
    }

    private static final void pcSetexternalId(JsonBundleJob jsonBundleJob, String string) {
        if (jsonBundleJob.pcStateManager == null) {
            jsonBundleJob.externalId = string;
            return;
        }
        jsonBundleJob.pcStateManager.settingStringField((PersistenceCapable)jsonBundleJob, pcInheritedFieldCount + 3, jsonBundleJob.externalId, string, 0);
    }

    private static final String pcGetgroup(JsonBundleJob jsonBundleJob) {
        if (jsonBundleJob.pcStateManager == null) {
            return jsonBundleJob.group;
        }
        int n = pcInheritedFieldCount + 4;
        jsonBundleJob.pcStateManager.accessingField(n);
        return jsonBundleJob.group;
    }

    private static final void pcSetgroup(JsonBundleJob jsonBundleJob, String string) {
        if (jsonBundleJob.pcStateManager == null) {
            jsonBundleJob.group = string;
            return;
        }
        jsonBundleJob.pcStateManager.settingStringField((PersistenceCapable)jsonBundleJob, pcInheritedFieldCount + 4, jsonBundleJob.group, string, 0);
    }

    private static final String pcGetid(JsonBundleJob jsonBundleJob) {
        if (jsonBundleJob.pcStateManager == null) {
            return jsonBundleJob.id;
        }
        int n = pcInheritedFieldCount + 5;
        jsonBundleJob.pcStateManager.accessingField(n);
        return jsonBundleJob.id;
    }

    private static final void pcSetid(JsonBundleJob jsonBundleJob, String string) {
        if (jsonBundleJob.pcStateManager == null) {
            jsonBundleJob.id = string;
            return;
        }
        jsonBundleJob.pcStateManager.settingStringField((PersistenceCapable)jsonBundleJob, pcInheritedFieldCount + 5, jsonBundleJob.id, string, 0);
    }

    private static final int pcGettimeOut(JsonBundleJob jsonBundleJob) {
        if (jsonBundleJob.pcStateManager == null) {
            return jsonBundleJob.timeOut;
        }
        int n = pcInheritedFieldCount + 6;
        jsonBundleJob.pcStateManager.accessingField(n);
        return jsonBundleJob.timeOut;
    }

    private static final void pcSettimeOut(JsonBundleJob jsonBundleJob, int n) {
        if (jsonBundleJob.pcStateManager == null) {
            jsonBundleJob.timeOut = n;
            return;
        }
        jsonBundleJob.pcStateManager.settingIntField((PersistenceCapable)jsonBundleJob, pcInheritedFieldCount + 6, jsonBundleJob.timeOut, n, 0);
    }

    private static final String pcGetuser(JsonBundleJob jsonBundleJob) {
        if (jsonBundleJob.pcStateManager == null) {
            return jsonBundleJob.user;
        }
        int n = pcInheritedFieldCount + 7;
        jsonBundleJob.pcStateManager.accessingField(n);
        return jsonBundleJob.user;
    }

    private static final void pcSetuser(JsonBundleJob jsonBundleJob, String string) {
        if (jsonBundleJob.pcStateManager == null) {
            jsonBundleJob.user = string;
            return;
        }
        jsonBundleJob.pcStateManager.settingStringField((PersistenceCapable)jsonBundleJob, pcInheritedFieldCount + 7, jsonBundleJob.user, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

