/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.LibDocBundleBoot;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.metadata.writer.DocumentMetaDataWriter;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.LibRepositoryBoot;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.file.FileRepository;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipRepository;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class BundleUtilities {
    private static final Log logger = LogFactory.getLog(BundleUtilities.class);
    public static final String STICKY_FLAG = "sticky";
    public static final String HIDDEN_FLAG = "hidden";
    private static final String[] DATEFORMATS = new String[]{"yyyy-MM-dd'T'hh:mm:ss.SSS z", "yyyy-MM-dd'T'hh:mm:ss z", "yyyy-MM-dd'T'hh:mm:ss.SSS'Z'", "yyyy-MM-dd'T'hh:mm:ss'Z'", "yyyy-MM-dd'T'hh:mm:ss.SSS", "yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd zzz", "yyyy-MM-dd'Z'", "yyyy-MM-dd"};
    private static final long SECONDS = 1000L;
    private static final long MINUTES = 60000L;
    private static final long HOURS = 3600000L;

    private BundleUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInto(WriteableDocumentBundle bundle, String targetPath, ResourceKey dataKey, ResourceManager resourceManager) throws IOException, ResourceLoadingException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (targetPath == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        if (dataKey == null) {
            throw new NullPointerException();
        }
        ResourceData resourceData = resourceManager.load(dataKey);
        String contentType = (String)resourceData.getAttribute("content-type");
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        InputStream stream = resourceData.getResourceAsStream(resourceManager);
        try {
            OutputStream outStream = bundle.createEntry(targetPath, contentType);
            try {
                IOUtils.getInstance().copyStreams(stream, outStream);
            }
            finally {
                outStream.close();
            }
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBundleType(Repository repository) {
        if (repository == null) {
            throw new NullPointerException();
        }
        try {
            ContentEntity mimeTypeContentEntity = repository.getRoot().getEntry("mimetype");
            if (mimeTypeContentEntity instanceof ContentItem) {
                ContentItem mimeTypeItem = (ContentItem)mimeTypeContentEntity;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream in = mimeTypeItem.getInputStream();
                try {
                    IOUtils.getInstance().copyStreams(in, (OutputStream)bout);
                }
                finally {
                    in.close();
                }
                return bout.toString("ASCII");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getBundleMapping(String bundleType) {
        String defaultType = LibDocBundleBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.docbundle.bundleloader.mapping");
        if (bundleType == null) {
            return defaultType;
        }
        return LibDocBundleBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.docbundle.bundleloader.mapping." + bundleType, defaultType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAsZip(File target, DocumentBundle bundle) throws IOException, ContentIOException {
        if (target == null) {
            throw new NullPointerException();
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        FileOutputStream fout = new FileOutputStream(target);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        try {
            BundleUtilities.writeAsZip(bout, bundle);
        }
        finally {
            bout.close();
        }
    }

    public static void writeAsZip(OutputStream targetStream, DocumentBundle bundle) throws ContentIOException, IOException {
        if (targetStream == null) {
            throw new NullPointerException();
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        ZipRepository repository = new ZipRepository(targetStream);
        BundleUtilities.writeToRepository((Repository)repository, bundle);
        repository.close();
    }

    public static void writeToDirectory(File target, DocumentBundle bundle) throws ContentIOException, IOException {
        if (target == null) {
            throw new NullPointerException();
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        FileRepository repository = new FileRepository(target);
        BundleUtilities.writeToRepository((Repository)repository, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToRepository(Repository repository, DocumentBundle bundle) throws ContentIOException, IOException {
        if (repository == null) {
            throw new NullPointerException();
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        String bundleType = bundle.getEntryMimeType("/");
        if (bundleType == null) {
            logger.warn((Object)"Document-Bundle has no bundle-type declared.");
        } else {
            ContentItem contentItem = RepositoryUtilities.createItem((Repository)repository, (String[])RepositoryUtilities.splitPath((String)"mimetype", (String)"/"));
            contentItem.setAttribute("org.jfree.repository.zip", "method", (Object)LibRepositoryBoot.ZIP_METHOD_STORED);
            byte[] rawData = bundleType.getBytes("ASCII");
            OutputStream outputStream = contentItem.getOutputStream();
            try {
                outputStream.write(rawData);
            }
            finally {
                outputStream.close();
            }
        }
        DocumentMetaDataWriter metaDataWriter = new DocumentMetaDataWriter(bundle.getMetaData());
        ContentItem manifestItem = RepositoryUtilities.createItem((Repository)repository, (String[])RepositoryUtilities.splitPath((String)"META-INF/manifest.xml", (String)"/"));
        OutputStream manifestStream = manifestItem.getOutputStream();
        try {
            metaDataWriter.writeManifest(manifestStream);
        }
        finally {
            manifestStream.close();
        }
        ContentItem metaDataItem = RepositoryUtilities.createItem((Repository)repository, (String[])RepositoryUtilities.splitPath((String)"meta.xml", (String)"/"));
        OutputStream metaDataStream = metaDataItem.getOutputStream();
        try {
            metaDataWriter.writeMetaData(metaDataStream);
        }
        finally {
            metaDataStream.close();
        }
        DocumentMetaData bundleMetaData = bundle.getMetaData();
        Object[] entryNames = bundleMetaData.getManifestEntryNames();
        Arrays.sort(entryNames);
        for (int i = 0; i < entryNames.length; ++i) {
            Object entryName = entryNames[i];
            if ("/".equals(entryName) || "mimetype".equals(entryName) || "META-DATA/manifest.xml".equals(entryName) || "meta.xml".equals(entryName)) continue;
            logger.debug((Object)("Processing " + (String)entryName));
            String[] entityNameArray = RepositoryUtilities.splitPath((String)entryName, (String)"/");
            if (((String)entryName).length() > 0 && ((String)entryName).charAt(((String)entryName).length() - 1) == '/') {
                if (RepositoryUtilities.isExistsEntity((Repository)repository, (String[])entityNameArray)) continue;
                RepositoryUtilities.createLocation((Repository)repository, (String[])entityNameArray);
                continue;
            }
            ContentItem dataItem = RepositoryUtilities.createItem((Repository)repository, (String[])entityNameArray);
            OutputStream dataStream = dataItem.getOutputStream();
            try {
                InputStream inStream = bundle.getEntryAsStream((String)entryName);
                try {
                    IOUtils.getInstance().copyStreams(inStream, dataStream);
                    continue;
                }
                finally {
                    inStream.close();
                }
            }
            finally {
                dataStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInto(WriteableDocumentBundle targetBundle, DocumentBundle sourceBundle) throws IOException {
        if (targetBundle == null) {
            throw new NullPointerException();
        }
        if (sourceBundle == null) {
            throw new NullPointerException();
        }
        WriteableDocumentMetaData targetBundleMetaData = targetBundle.getWriteableDocumentMetaData();
        DocumentMetaData bundleMetaData = sourceBundle.getMetaData();
        targetBundleMetaData.setBundleType(bundleMetaData.getBundleType());
        String[] namespaces = bundleMetaData.getMetaDataNamespaces();
        for (int namespaceIdx = 0; namespaceIdx < namespaces.length; ++namespaceIdx) {
            String namespace = namespaces[namespaceIdx];
            String[] dataNames = bundleMetaData.getMetaDataNames(namespace);
            for (int dataNameIdx = 0; dataNameIdx < dataNames.length; ++dataNameIdx) {
                String dataName = dataNames[dataNameIdx];
                Object value = bundleMetaData.getBundleAttribute(namespace, dataName);
                targetBundleMetaData.setBundleAttribute(namespace, dataName, value);
            }
        }
        String[] entryNames = bundleMetaData.getManifestEntryNames();
        for (int i = 0; i < entryNames.length; ++i) {
            String entryName = entryNames[i];
            if ("/".equals(entryName) || "mimetype".equals(entryName) || "META-DATA/manifest.xml".equals(entryName) || "meta.xml".equals(entryName)) continue;
            logger.debug((Object)("Processing " + entryName));
            String entryMimeType = bundleMetaData.getEntryMimeType(entryName);
            if (entryMimeType == null) {
                throw new IllegalStateException("Found an entry with an invalid mime-type: " + entryName);
            }
            if (entryName.length() > 0 && entryName.charAt(entryName.length() - 1) == '/') {
                targetBundle.createDirectoryEntry(entryName, entryMimeType);
            } else {
                OutputStream dataStream = targetBundle.createEntry(entryName, entryMimeType);
                try {
                    InputStream inStream = sourceBundle.getEntryAsStream(entryName);
                    try {
                        IOUtils.getInstance().copyStreams(inStream, dataStream);
                    }
                    finally {
                        inStream.close();
                    }
                }
                finally {
                    dataStream.close();
                }
            }
            DocumentMetaData sourceMetaData = sourceBundle.getMetaData();
            String[] attributeNames = sourceMetaData.getEntryAttributeNames(entryName);
            for (int j = 0; j < attributeNames.length; ++j) {
                String attributeName = attributeNames[j];
                targetBundle.getWriteableDocumentMetaData().setEntryAttribute(entryName, attributeName, sourceMetaData.getEntryAttribute(entryName, attributeName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStickyInto(WriteableDocumentBundle targetBundle, DocumentBundle sourceBundle) throws IOException {
        if (targetBundle == null) {
            throw new NullPointerException();
        }
        if (sourceBundle == null) {
            throw new NullPointerException();
        }
        WriteableDocumentMetaData targetBundleMetaData = targetBundle.getWriteableDocumentMetaData();
        DocumentMetaData bundleMetaData = sourceBundle.getMetaData();
        targetBundleMetaData.setBundleType(bundleMetaData.getBundleType());
        String[] namespaces = bundleMetaData.getMetaDataNamespaces();
        for (int namespaceIdx = 0; namespaceIdx < namespaces.length; ++namespaceIdx) {
            String namespace = namespaces[namespaceIdx];
            String[] dataNames = bundleMetaData.getMetaDataNames(namespace);
            for (int dataNameIdx = 0; dataNameIdx < dataNames.length; ++dataNameIdx) {
                String dataName = dataNames[dataNameIdx];
                Object value = bundleMetaData.getBundleAttribute(namespace, dataName);
                targetBundleMetaData.setBundleAttribute(namespace, dataName, value);
            }
        }
        String[] entryNames = bundleMetaData.getManifestEntryNames();
        for (int i = 0; i < entryNames.length; ++i) {
            String entryName = entryNames[i];
            if ("/".equals(entryName) || "mimetype".equals(entryName) || "META-DATA/manifest.xml".equals(entryName) || "meta.xml".equals(entryName) || !"true".equals(bundleMetaData.getEntryAttribute(entryName, STICKY_FLAG))) continue;
            logger.debug((Object)("Processing " + entryName));
            String entryMimeType = bundleMetaData.getEntryMimeType(entryName);
            if (entryMimeType == null) {
                bundleMetaData.getEntryMimeType(entryName);
                throw new IllegalStateException("Found an entry with an invalid mime-type: " + entryName);
            }
            if (entryName.length() > 0 && entryName.charAt(entryName.length() - 1) == '/') {
                targetBundle.createDirectoryEntry(entryName, entryMimeType);
                continue;
            }
            OutputStream dataStream = targetBundle.createEntry(entryName, entryMimeType);
            try {
                InputStream inStream = sourceBundle.getEntryAsStream(entryName);
                try {
                    IOUtils.getInstance().copyStreams(inStream, dataStream);
                }
                finally {
                    inStream.close();
                }
            }
            finally {
                dataStream.close();
            }
            DocumentMetaData sourceMetaData = sourceBundle.getMetaData();
            String[] attributeNames = sourceMetaData.getEntryAttributeNames(entryName);
            for (int j = 0; j < attributeNames.length; ++j) {
                String attributeName = attributeNames[j];
                targetBundle.getWriteableDocumentMetaData().setEntryAttribute(entryName, attributeName, sourceMetaData.getEntryAttribute(entryName, attributeName));
            }
        }
    }

    public static void copyInto(WriteableDocumentBundle targetBundle, DocumentBundle sourceBundle, String[] files) throws IOException {
        BundleUtilities.copyInto(targetBundle, sourceBundle, files, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInto(WriteableDocumentBundle targetBundle, DocumentBundle sourceBundle, String[] files, boolean ignoreSticky) throws IOException {
        if (targetBundle == null) {
            throw new NullPointerException();
        }
        if (sourceBundle == null) {
            throw new NullPointerException();
        }
        if (files == null) {
            throw new NullPointerException();
        }
        HashSet<String> fileSet = new HashSet<String>(Arrays.asList(files));
        WriteableDocumentMetaData targetBundleMetaData = targetBundle.getWriteableDocumentMetaData();
        DocumentMetaData bundleMetaData = sourceBundle.getMetaData();
        targetBundleMetaData.setBundleType(bundleMetaData.getBundleType());
        String[] namespaces = bundleMetaData.getMetaDataNamespaces();
        for (int namespaceIdx = 0; namespaceIdx < namespaces.length; ++namespaceIdx) {
            String namespace = namespaces[namespaceIdx];
            String[] dataNames = bundleMetaData.getMetaDataNames(namespace);
            for (int dataNameIdx = 0; dataNameIdx < dataNames.length; ++dataNameIdx) {
                String dataName = dataNames[dataNameIdx];
                Object value = bundleMetaData.getBundleAttribute(namespace, dataName);
                targetBundleMetaData.setBundleAttribute(namespace, dataName, value);
            }
        }
        String[] entryNames = bundleMetaData.getManifestEntryNames();
        for (int i = 0; i < entryNames.length; ++i) {
            String entryName = entryNames[i];
            if ("/".equals(entryName) || "mimetype".equals(entryName) || "META-DATA/manifest.xml".equals(entryName) || "meta.xml".equals(entryName) || !fileSet.contains(entryName) || ignoreSticky && "true".equals(bundleMetaData.getEntryAttribute(entryName, STICKY_FLAG))) continue;
            logger.debug((Object)("Processing " + entryName));
            String entryMimeType = bundleMetaData.getEntryMimeType(entryName);
            if (entryMimeType == null) {
                bundleMetaData.getEntryMimeType(entryName);
                throw new IllegalStateException("Found an entry with an invalid mime-type: " + entryName);
            }
            if (entryName.length() > 0 && entryName.charAt(entryName.length() - 1) == '/') {
                targetBundle.createDirectoryEntry(entryName, entryMimeType);
                continue;
            }
            OutputStream dataStream = targetBundle.createEntry(entryName, entryMimeType);
            try {
                InputStream inStream = sourceBundle.getEntryAsStream(entryName);
                try {
                    IOUtils.getInstance().copyStreams(inStream, dataStream);
                }
                finally {
                    inStream.close();
                }
            }
            finally {
                dataStream.close();
            }
            DocumentMetaData sourceMetaData = sourceBundle.getMetaData();
            String[] attributeNames = sourceMetaData.getEntryAttributeNames(entryName);
            for (int j = 0; j < attributeNames.length; ++j) {
                String attributeName = attributeNames[j];
                targetBundle.getWriteableDocumentMetaData().setEntryAttribute(entryName, attributeName, sourceMetaData.getEntryAttribute(entryName, attributeName));
            }
        }
    }

    public static String getUniqueName(DocumentBundle bundle, String parent, String pattern) {
        String fullPattern = IOUtils.getInstance().getAbsolutePath(pattern, parent);
        return BundleUtilities.getUniqueName(bundle, fullPattern);
    }

    public static String getUniqueName(DocumentBundle bundle, String pattern) {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (pattern == null) {
            throw new NullPointerException();
        }
        MessageFormat message = new MessageFormat(pattern);
        Object[] objects = new Object[]{""};
        String plain = message.format(objects);
        if (!bundle.isEntryExists(plain)) {
            return plain;
        }
        Format[] formats = message.getFormats();
        if (formats.length == 0) {
            return null;
        }
        for (int count = 1; count < 2000000; ++count) {
            objects[0] = String.valueOf(count);
            String testFile = message.format(objects);
            if (bundle.isEntryExists(testFile)) continue;
            return testFile;
        }
        throw new IllegalStateException();
    }

    public static boolean isSameBundle(ResourceKey elementSource, ResourceKey attributeValue) {
        if (attributeValue == null) {
            throw new NullPointerException();
        }
        if (elementSource == null) {
            return false;
        }
        if (elementSource.getParent() != null && attributeValue.getParent() != null) {
            return ObjectUtilities.equal((Object)elementSource.getParent(), (Object)attributeValue.getParent());
        }
        return false;
    }

    public static DocumentBundle getBundle(File file) throws ResourceException {
        if (file == null) {
            throw new NullPointerException();
        }
        ResourceManager resManager = new ResourceManager();
        Resource directly = resManager.createDirectly((Object)file, DocumentBundle.class);
        return (DocumentBundle)directly.getResource();
    }

    public static Date parseDate(String date) {
        if (date.startsWith("PT")) {
            return BundleUtilities.parseDuration(date);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        dateFormat.setLenient(false);
        for (int i = 0; i < DATEFORMATS.length; ++i) {
            try {
                String dateformat = DATEFORMATS[i];
                dateFormat.applyPattern(dateformat);
                return dateFormat.parse(date);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    public static Date parseDuration(String duration) {
        if (!duration.startsWith("PT")) {
            return null;
        }
        double div = 1.0;
        long date = 0L;
        int item = 0;
        char[] chars = duration.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (c == 'T') {
                item = 0;
                div = 1.0;
                continue;
            }
            if (Character.isDigit(c)) {
                div *= 10.0;
                item = item * 10 + (c - 48);
                continue;
            }
            if (c == 'H') {
                date += (long)item * 3600000L;
                item = 0;
                div = 1.0;
                continue;
            }
            if (c == 'M') {
                date += (long)item * 60000L;
                item = 0;
                div = 1.0;
                continue;
            }
            if (c == 'S') {
                date += (long)item * 1000L;
                item = 0;
                div = 1.0;
                continue;
            }
            if (c == '.') {
                div = 1.0;
                continue;
            }
            return null;
        }
        date = (long)((double)date + (double)item / div * 1000.0);
        return new Date(date);
    }

    public static void copyMetaData(MemoryDocumentBundle memoryDocumentBundle, DocumentBundle bundle) {
        WriteableDocumentMetaData memMeta = memoryDocumentBundle.getWriteableDocumentMetaData();
        DocumentMetaData metaData = bundle.getMetaData();
        memMeta.setBundleType(metaData.getBundleType());
        String[] metaNamespaces = metaData.getMetaDataNamespaces();
        for (int i = 0; i < metaNamespaces.length; ++i) {
            String metaNamespace = metaNamespaces[i];
            String[] metaDataNames = metaData.getMetaDataNames(metaNamespace);
            for (int j = 0; j < metaDataNames.length; ++j) {
                String metaDataName = metaDataNames[j];
                Object value = metaData.getBundleAttribute(metaNamespace, metaDataName);
                memMeta.setBundleAttribute(metaNamespace, metaDataName, value);
            }
        }
    }
}

