/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle;

import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.util.IPdiContentProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class PdiContentProvider
implements IPdiContentProvider {
    private Log log = LogFactory.getLog(PdiContentProvider.class);
    IUnifiedRepository unifiedRepository;

    public PdiContentProvider() {
        this.unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
    }

    public PdiContentProvider(IUnifiedRepository unifiedRepository) {
        this.unifiedRepository = unifiedRepository;
    }

    public boolean hasUserParameters(String kettleFilePath) {
        String[] userParams = this.getUserParameters(kettleFilePath);
        return userParams != null && userParams.length > 0;
    }

    public String[] getUserParameters(String kettleFilePath) {
        ArrayList userParams = new ArrayList();
        if (!StringUtils.isEmpty((String)kettleFilePath)) {
            try {
                NamedParams np = this.getMeta(kettleFilePath);
                np = this.filterUserParameters(np);
                if (!this.isEmpty(np)) {
                    return np.listParameters();
                }
            }
            catch (KettleException e) {
                this.log.error((Object)e);
            }
        }
        return userParams.toArray(new String[0]);
    }

    private NamedParams filterUserParameters(NamedParams params) {
        NamedParamsDefault userParams = new NamedParamsDefault();
        if (!this.isEmpty(params)) {
            for (String paramName : params.listParameters()) {
                if (!this.isUserParameter(paramName)) continue;
                try {
                    userParams.addParameterDefinition(paramName, "", "");
                }
                catch (DuplicateParamException e) {
                    // empty catch block
                }
            }
        }
        return userParams;
    }

    private NamedParams getMeta(String kettleFilePath) throws KettleException {
        TransMeta meta = null;
        if (!StringUtils.isEmpty((String)kettleFilePath)) {
            String extension = FilenameUtils.getExtension((String)kettleFilePath);
            if ("ktr".equalsIgnoreCase(extension)) {
                meta = new TransMeta(kettleFilePath);
            } else if ("kjb".equalsIgnoreCase(extension)) {
                meta = new JobMeta(kettleFilePath, null);
            }
        }
        return meta;
    }

    private boolean isUserParameter(String paramName) {
        return StringUtils.isEmpty((String)paramName) || !paramName.startsWith("_");
    }

    private boolean isEmpty(NamedParams np) {
        return np == null || np.listParameters() == null || np.listParameters().length == 0;
    }
}

