/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.logging.LoggingBuffer;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandlerCache;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.action.ILoggingAction;
import org.pentaho.platform.api.action.IVarArgsAction;
import org.pentaho.platform.api.engine.ActionExecutionException;
import org.pentaho.platform.api.engine.ActionValidationException;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.kettle.KettleSystemListener;
import org.pentaho.platform.plugin.kettle.EngineMetaLoader;
import org.pentaho.platform.plugin.kettle.LoggingBufferAppender;
import org.pentaho.platform.plugin.kettle.messages.Messages;

public class PdiAction
implements IAction,
IVarArgsAction,
ILoggingAction,
RowListener {
    private static final String SINGLE_DI_SERVER_INSTANCE = "singleDiServerInstance";
    private MemoryResultSet transformationOutputRows;
    private IPentahoResultSet injectorRows;
    private MemoryResultSet transformationOutputErrorRows;
    private int transformationOutputRowsCount;
    private int transformationOutputErrorRowsCount;
    private String directory;
    private String transformation;
    private String job;
    private String monitorStep = null;
    private String injectorStep = null;
    private Map<String, Object> varArgs = new HashMap<String, Object>();
    private String repositoryName;
    private LoggingBuffer pdiUserAppender;
    private RowProducer rowInjector = null;
    Job localJob = null;
    Trans localTrans = null;
    private Log log = LogFactory.getLog(PdiAction.class);
    private Map<String, String> variables;
    private Map<String, String> parameters;
    private String[] arguments;
    private String logLevel;
    private String clearLog;
    private String runSafeMode;
    private String runClustered;

    public void setLogger(Log log) {
        this.log = log;
    }

    public void validate() throws ActionValidationException {
        if (this.directory == null) {
            throw new ActionValidationException(Messages.getInstance().getErrorString("PdiAction.ERROR_0001_DIR_NOT_SET"));
        }
        if (this.transformation == null && this.job == null) {
            throw new ActionValidationException(Messages.getInstance().getErrorString("PdiAction.ERROR_0002_JOB_OR_TRANS_NOT_SET"));
        }
        if (this.injectorStep != null && this.injectorRows == null) {
            throw new ActionValidationException(Messages.getInstance().getErrorString("PdiAction.ERROR_0003_INJECTOR_ROWS_NOT_SET", this.injectorStep));
        }
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        block16: {
            IAuthorizationPolicy authorizationPolicy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class, (IPentahoSession)PentahoSessionHolder.getSession());
            if (!authorizationPolicy.isAllowed("org.pentaho.repository.execute")) {
                throw new IllegalStateException(Messages.getInstance().getErrorString("PdiAction.ERROR_0010_NO_PERMISSION_TO_EXECUTE"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_START"));
            }
            this.validate();
            TransMeta transMeta = null;
            JobMeta jobMeta = null;
            LogWriter logWriter = LogWriter.getInstance((String)"Kettle-pentaho", (boolean)false);
            KettleSystemListener.environmentInit((IPentahoSession)PentahoSessionHolder.getSession());
            this.pdiUserAppender = KettleLogStore.getAppender();
            Repository repository = this.connectToRepository(logWriter);
            LoggingBufferAppender loggingBufferAppender = new LoggingBufferAppender(this.pdiUserAppender);
            logWriter.addAppender((Appender)loggingBufferAppender);
            try {
                if (this.transformation != null) {
                    try {
                        transMeta = this.createTransMetaJCR(repository);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (transMeta == null) {
                        transMeta = this.createTransMeta(repository, logWriter);
                    }
                    if (transMeta == null) {
                        throw new IllegalStateException(Messages.getInstance().getErrorString("PdiAction.ERROR_0004_FAILED_TRANSMETA_CREATION"));
                    }
                    this.executeTransformation(transMeta, logWriter);
                    break block16;
                }
                if (this.job == null) break block16;
                try {
                    jobMeta = this.createJobMetaJCR(repository);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (jobMeta == null) {
                    jobMeta = this.createJobMeta(repository, logWriter);
                }
                if (jobMeta == null) {
                    throw new IllegalStateException(Messages.getInstance().getErrorString("PdiAction.ERROR_0005_FAILED_JOBMETA_CREATION"));
                }
                this.executeJob(jobMeta, repository, logWriter);
            }
            finally {
                logWriter.removeAppender((Appender)loggingBufferAppender);
                if (repository != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_DISCONNECTING"));
                    }
                    repository.disconnect();
                }
            }
        }
        XMLHandlerCache.getInstance().clear();
    }

    private TransMeta createTransMeta(Repository repository, LogWriter logWriter) throws ActionExecutionException {
        TransMeta transMeta;
        EngineMetaLoader engineMetaUtil = new EngineMetaLoader(repository);
        try {
            transMeta = engineMetaUtil.loadTransMeta(this.directory, this.transformation);
        }
        catch (FileNotFoundException e) {
            throw new ActionExecutionException(Messages.getInstance().getErrorString("PdiAction.ERROR_0006_FAILED_TRANSMETA_CREATION", this.directory, this.transformation), (Throwable)e);
        }
        if (this.arguments != null) {
            transMeta.setArguments(this.arguments);
        }
        if (this.logLevel != null) {
            transMeta.setLogLevel(LogLevel.getLogLevelForCode((String)this.logLevel));
        }
        this.populateInputs((NamedParams)transMeta, (VariableSpace)transMeta);
        return transMeta;
    }

    private TransMeta createTransMetaJCR(Repository repository) throws ActionExecutionException {
        TransMeta transMeta = new TransMeta();
        try {
            IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, null);
            RepositoryFile transFile = unifiedRepository.getFile(this.idTopath(this.transformation));
            transMeta = repository.loadTransformation((ObjectId)new StringObjectId((String)((Object)transFile.getId())), null);
        }
        catch (Throwable e) {
            throw new ActionExecutionException(Messages.getInstance().getErrorString("PdiAction.ERROR_0006_FAILED_TRANSMETA_CREATION", this.directory, this.transformation), e);
        }
        if (this.arguments != null) {
            transMeta.setArguments(this.arguments);
        }
        if (this.logLevel != null) {
            transMeta.setLogLevel(LogLevel.getLogLevelForCode((String)this.logLevel));
        }
        this.populateInputs((NamedParams)transMeta, (VariableSpace)transMeta);
        return transMeta;
    }

    private JobMeta createJobMeta(Repository repository, LogWriter logWriter) throws ActionExecutionException {
        JobMeta jobMeta;
        EngineMetaLoader engineMetaUtil = new EngineMetaLoader(repository);
        try {
            jobMeta = engineMetaUtil.loadJobMeta(this.directory, this.job);
        }
        catch (FileNotFoundException e) {
            throw new ActionExecutionException(Messages.getInstance().getErrorString("PdiAction.ERROR_0007_FAILED_JOBMETA_CREATION", this.directory, this.job), (Throwable)e);
        }
        if (this.arguments != null) {
            jobMeta.setArguments(this.arguments);
        }
        if (this.logLevel != null) {
            jobMeta.setLogLevel(LogLevel.getLogLevelForCode((String)this.logLevel));
        }
        this.populateInputs((NamedParams)jobMeta, (VariableSpace)jobMeta);
        return jobMeta;
    }

    private JobMeta createJobMetaJCR(Repository repository) throws ActionExecutionException {
        JobMeta jobMeta = new JobMeta();
        try {
            IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, null);
            RepositoryFile jobFile = unifiedRepository.getFile(this.idTopath(this.job));
            jobMeta = repository.loadJob((ObjectId)new StringObjectId((String)((Object)jobFile.getId())), null);
        }
        catch (Throwable e) {
            throw new ActionExecutionException(Messages.getInstance().getErrorString("PdiAction.ERROR_0006_FAILED_TRANSMETA_CREATION", this.directory, this.transformation), e);
        }
        if (this.arguments != null) {
            jobMeta.setArguments(this.arguments);
        }
        if (this.logLevel != null) {
            jobMeta.setLogLevel(LogLevel.getLogLevelForCode((String)this.logLevel));
        }
        this.populateInputs((NamedParams)jobMeta, (VariableSpace)jobMeta);
        return jobMeta;
    }

    private String idTopath(String id) {
        String path = id.replace(":", "/");
        if (path != null && path.length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        return path;
    }

    private void populateInputs(NamedParams paramHolder, VariableSpace varSpace) {
        if (this.parameters != null) {
            for (String string : this.parameters.keySet()) {
                try {
                    paramHolder.setParameterValue(string, this.parameters.get(string));
                }
                catch (UnknownParamException upe) {
                    this.log.warn((Object)upe);
                }
            }
        }
        if (this.variables != null) {
            for (String string : this.variables.keySet()) {
                varSpace.setVariable(string, this.variables.get(string));
            }
        }
        for (Map.Entry entry : this.varArgs.entrySet()) {
            varSpace.setVariable((String)entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : null);
        }
    }

    protected boolean customizeTrans(Trans trans, LogWriter logWriter) {
        return true;
    }

    protected String getJobName(String carteObjectId) {
        return this.job;
    }

    protected String getTransformationName(String carteObjectId) {
        return this.transformation;
    }

    protected void executeTransformation(TransMeta transMeta, LogWriter logWriter) throws ActionExecutionException {
        this.localTrans = null;
        if (transMeta != null) {
            TransExecutionConfiguration transExConfig = new TransExecutionConfiguration();
            if (this.logLevel != null) {
                transExConfig.setLogLevel(LogLevel.getLogLevelForCode((String)this.logLevel));
            }
            if (this.clearLog != null) {
                transExConfig.setClearingLog(Boolean.valueOf(this.clearLog).booleanValue());
            }
            if (this.runSafeMode != null) {
                transExConfig.setSafeModeEnabled(Boolean.valueOf(this.runSafeMode).booleanValue());
            }
            try {
                this.localTrans = new Trans(transMeta);
                this.localTrans.setArguments(this.arguments);
                this.localTrans.shareVariablesWith((VariableSpace)transMeta);
                String carteObjectId = UUID.randomUUID().toString();
                this.localTrans.setContainerObjectId(carteObjectId);
                CarteSingleton.getInstance().getTransformationMap().addTransformation(this.getTransformationName(carteObjectId), carteObjectId, this.localTrans, new TransConfiguration(this.localTrans.getTransMeta(), transExConfig));
            }
            catch (Exception e) {
                throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0010_BAD_TRANSFORMATION_METADATA"), (Throwable)e);
            }
        }
        if (this.localTrans == null) {
            throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0010_BAD_TRANSFORMATION_METADATA"));
        }
        if (this.localTrans != null) {
            if (!this.customizeTrans(this.localTrans, logWriter)) {
                throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0028_CUSTOMIZATION_FUNCITON_FAILED"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_PREPARING_TRANSFORMATION"));
            }
            try {
                this.localTrans.setLogLevel(LogLevel.getLogLevelForCode((String)this.logLevel));
                this.localTrans.setSafeModeEnabled(Boolean.valueOf(this.runSafeMode).booleanValue());
                this.localTrans.prepareExecution(transMeta.getArguments());
            }
            catch (Exception e) {
                this.log.error((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0011_TRANSFORMATION_PREPARATION_FAILED"), (Throwable)e);
                return;
            }
            String stepName = null;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_FINDING_STEP_IMPORTER"));
                }
                if ((stepName = this.getMonitorStepName()) != null) {
                    this.registerAsStepListener(stepName, this.localTrans);
                }
            }
            catch (Exception e) {
                throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0012_ROW_LISTENER_CREATE_FAILED"), (Throwable)e);
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_FINDING_STEP_IMPORTER"));
                }
                if (this.injectorStep != null) {
                    this.registerAsProducer(this.injectorStep, this.localTrans);
                }
            }
            catch (Exception e) {
                throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0012_ROW_INJECTOR_CREATE_FAILED"), (Throwable)e);
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_STARTING_TRANSFORMATION"));
                }
                this.localTrans.startThreads();
            }
            catch (Exception e) {
                throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0013_TRANSFORMATION_START_FAILED"), (Throwable)e);
            }
            if (this.injectorRows != null) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Injecting rows"));
                    }
                    RowMeta rowMeta = new RowMeta();
                    RowMetaInterface rowMetaInterface = transMeta.getStepFields(this.injectorStep);
                    rowMeta.addRowMeta(rowMetaInterface);
                    Object[] row = this.injectorRows.next();
                    while (row != null) {
                        this.rowInjector.putRow((RowMetaInterface)rowMeta, row);
                        row = this.injectorRows.next();
                    }
                    this.rowInjector.finished();
                }
                catch (Exception e) {
                    throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Row injection failed"), (Throwable)e);
                }
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_TRANSFORMATION_RUNNING"));
                }
                this.localTrans.waitUntilFinished();
                this.localTrans.cleanup();
            }
            catch (Exception e) {
                int transErrors = this.localTrans.getErrors();
                throw new ActionExecutionException(Messages.getInstance().getErrorString("PdiAction.ERROR_0009_TRANSFORMATION_HAD_ERRORS", Integer.toString(transErrors)), (Throwable)e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.pdiUserAppender.getBuffer().toString());
            }
            if (this.transformationOutputRows != null) {
                this.transformationOutputRowsCount = this.transformationOutputRows.getRowCount();
            }
            if (this.transformationOutputErrorRows != null) {
                this.transformationOutputErrorRowsCount = this.transformationOutputErrorRows.getRowCount();
            }
        }
    }

    protected void registerAsStepListener(String stepName, Trans trans) throws KettleStepException {
        if (trans != null) {
            List stepList = trans.getSteps();
            for (StepMetaDataCombi step : stepList) {
                if (!step.stepname.equals(stepName)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_FOUND_STEP_IMPORTER"));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_GETTING_STEP_METADATA"));
                }
                RowMetaInterface row = trans.getTransMeta().getStepFields(stepName);
                String[] fieldNames = row.getFieldNames();
                Object[][] columns = new String[1][fieldNames.length];
                for (int column = 0; column < fieldNames.length; ++column) {
                    columns[0][column] = fieldNames[column];
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_CREATING_RESULTSET_METADATA"));
                }
                MemoryMetaData metaData = new MemoryMetaData(columns, (Object[][])null);
                this.transformationOutputRows = new MemoryResultSet((IPentahoMetaData)metaData);
                this.transformationOutputErrorRows = new MemoryResultSet((IPentahoMetaData)metaData);
                step.step.addRowListener((RowListener)this);
                break;
            }
        }
    }

    protected boolean registerAsProducer(String stepName, Trans trans) throws KettleException {
        if (trans != null) {
            this.rowInjector = trans.addRowProducer(stepName, 0);
            return true;
        }
        return false;
    }

    protected String getMonitorStepName() {
        String result = null;
        if (this.monitorStep != null) {
            result = this.monitorStep;
        }
        return result;
    }

    protected void executeJob(JobMeta jobMeta, Repository repository, LogWriter logWriter) throws ActionExecutionException {
        this.localJob = null;
        if (jobMeta != null) {
            JobExecutionConfiguration jobExConfig = new JobExecutionConfiguration();
            if (this.logLevel != null) {
                jobExConfig.setLogLevel(LogLevel.getLogLevelForCode((String)this.logLevel));
            }
            if (this.clearLog != null) {
                jobExConfig.setClearingLog(Boolean.valueOf(this.clearLog).booleanValue());
            }
            if (this.runSafeMode != null) {
                jobExConfig.setSafeModeEnabled(Boolean.valueOf(this.runSafeMode).booleanValue());
            }
            try {
                this.localJob = new Job(repository, jobMeta);
                this.localJob.setArguments(this.arguments);
                this.localJob.shareVariablesWith((VariableSpace)jobMeta);
                String carteObjectId = UUID.randomUUID().toString();
                this.localJob.setContainerObjectId(carteObjectId);
                CarteSingleton.getInstance().getJobMap().addJob(this.getJobName(carteObjectId), carteObjectId, this.localJob, new JobConfiguration(this.localJob.getJobMeta(), jobExConfig));
            }
            catch (Exception e) {
                throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0021_BAD_JOB_METADATA"), (Throwable)e);
            }
        }
        if (this.localJob == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.pdiUserAppender.getBuffer().toString());
            }
            throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0021_BAD_JOB_METADATA"));
        }
        if (this.localJob != null) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_STARTING_JOB"));
                }
                this.localJob.setLogLevel(LogLevel.getLogLevelForCode((String)this.logLevel));
                this.localJob.start();
            }
            catch (Throwable e) {
                throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0022_JOB_START_FAILED"), e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_JOB_RUNNING"));
            }
            this.localJob.waitUntilFinished();
            int jobErrors = this.localJob.getErrors();
            long jobResultErrors = this.localJob.getResult().getNrErrors();
            if (jobErrors > 0 || jobResultErrors > 0L) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)this.pdiUserAppender.getBuffer().toString());
                }
                throw new ActionExecutionException(Messages.getInstance().getErrorString("PdiAction.ERROR_0008_JOB_HAD_ERRORS", Integer.toString(jobErrors), Long.toString(jobResultErrors)));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.pdiUserAppender.getBuffer().toString());
            }
        }
    }

    protected Repository connectToRepository(LogWriter logWriter) throws KettleSecurityException, KettleException, ActionExecutionException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_META_REPOSITORY"));
        }
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_POPULATING_META"));
        }
        boolean singleDiServerInstance = "true".equals(PentahoSystem.getSystemSetting((String)SINGLE_DI_SERVER_INSTANCE, (String)"true"));
        try {
            if (singleDiServerInstance) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"singleDiServerInstance=true, loading default repository");
                }
                String repositoriesXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><repositories><repository><id>PentahoEnterpriseRepository</id><name>singleDiServerInstance</name><description>singleDiServerInstance</description><repository_location_url>" + PentahoSystem.getApplicationContext().getFullyQualifiedServerURL() + "</repository_location_url>" + "<version_comment_mandatory>N</version_comment_mandatory>" + "</repository>" + "</repositories>";
                ByteArrayInputStream sbis = new ByteArrayInputStream(repositoriesXml.getBytes("UTF8"));
                repositoriesMeta.readDataFromInputStream((InputStream)sbis);
            } else {
                repositoriesMeta.readData();
            }
        }
        catch (Exception e) {
            throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0018_META_REPOSITORY_NOT_POPULATED"), (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_FINDING_REPOSITORY"));
        }
        RepositoryMeta repositoryMeta = null;
        try {
            repositoryMeta = singleDiServerInstance ? repositoriesMeta.findRepository(SINGLE_DI_SERVER_INSTANCE) : repositoriesMeta.findRepository(this.repositoryName);
        }
        catch (Exception e) {
            throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0004_REPOSITORY_NOT_FOUND", new Object[]{this.repositoryName}), (Throwable)e);
        }
        if (repositoryMeta == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.pdiUserAppender.getBuffer().toString());
            }
            throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0004_REPOSITORY_NOT_FOUND", new Object[]{this.repositoryName}));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_GETTING_REPOSITORY"));
        }
        Repository repository = null;
        try {
            repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
            repository.init(repositoryMeta);
        }
        catch (Exception e) {
            throw new ActionExecutionException(org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0016_COULD_NOT_GET_REPOSITORY_INSTANCE"), (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_CONNECTING"));
        }
        repository.connect(PentahoSessionHolder.getSession().getName(), "password");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)org.pentaho.platform.plugin.action.messages.Messages.getInstance().getString("Kettle.DEBUG_FINDING_DIRECTORY"));
        }
        return repository;
    }

    public void rowReadEvent(RowMetaInterface row, Object[] values) {
    }

    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        this.processRow(this.transformationOutputRows, rowMeta, row);
    }

    public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        this.processRow(this.transformationOutputErrorRows, rowMeta, row);
    }

    public void processRow(MemoryResultSet memResults, RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        if (memResults == null) {
            return;
        }
        try {
            Object[] pentahoRow = new Object[memResults.getColumnCount()];
            block11: for (int columnNo = 0; columnNo < memResults.getColumnCount(); ++columnNo) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(columnNo);
                switch (valueMeta.getType()) {
                    case 6: {
                        pentahoRow[columnNo] = rowMeta.getBigNumber(row, columnNo);
                        continue block11;
                    }
                    case 4: {
                        pentahoRow[columnNo] = rowMeta.getBoolean(row, columnNo);
                        continue block11;
                    }
                    case 3: {
                        pentahoRow[columnNo] = rowMeta.getDate(row, columnNo);
                        continue block11;
                    }
                    case 5: {
                        pentahoRow[columnNo] = rowMeta.getInteger(row, columnNo);
                        continue block11;
                    }
                    case 0: {
                        pentahoRow[columnNo] = rowMeta.getString(row, columnNo);
                        continue block11;
                    }
                    case 1: {
                        pentahoRow[columnNo] = rowMeta.getNumber(row, columnNo);
                        continue block11;
                    }
                    case 2: {
                        pentahoRow[columnNo] = rowMeta.getString(row, columnNo);
                        continue block11;
                    }
                    default: {
                        pentahoRow[columnNo] = rowMeta.getString(row, columnNo);
                    }
                }
            }
            memResults.addRow(pentahoRow);
        }
        catch (KettleValueException e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setVarArgs(Map<String, Object> varArgs) {
        this.varArgs = varArgs;
    }

    public String getLog() {
        return this.pdiUserAppender.getBuffer().toString();
    }

    public MemoryResultSet getTransformationOutputRows() {
        return this.transformationOutputRows;
    }

    public MemoryResultSet getTransformationOutputErrorRows() {
        return this.transformationOutputErrorRows;
    }

    public int getTransformationOutputRowsCount() {
        return this.transformationOutputRowsCount;
    }

    public int getTransformationOutputErrorRowsCount() {
        return this.transformationOutputErrorRowsCount;
    }

    public void setInjectorRows(IPentahoResultSet injectorRows) {
        this.injectorRows = injectorRows;
    }

    public void setTransformation(String transformation) {
        this.transformation = transformation;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public void setMonitorStep(String monitorStep) {
        this.monitorStep = monitorStep;
    }

    public void setInjectorStep(String injectorStep) {
        this.injectorStep = injectorStep;
    }

    public String getStatus() {
        if (this.localTrans != null) {
            return this.localTrans.getStatus();
        }
        if (this.localJob != null) {
            return this.localJob.getStatus();
        }
        return org.pentaho.platform.plugin.action.messages.Messages.getInstance().getErrorString("Kettle.ERROR_0025_NOT_LOADED");
    }

    public int getResult() {
        if (this.localTrans != null) {
            return this.localTrans.getResult().getExitStatus();
        }
        if (this.localJob != null) {
            return this.localJob.getResult().getExitStatus();
        }
        return -1;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getClearLog() {
        return this.clearLog;
    }

    public void setClearLog(String clearLog) {
        this.clearLog = clearLog;
    }

    public String getRunSafeMode() {
        return this.runSafeMode;
    }

    public void setRunSafeMode(String runSafeMode) {
        this.runSafeMode = runSafeMode;
    }

    public String getRunClustered() {
        return this.runClustered;
    }

    public void setRunClustered(String runClustered) {
        this.runClustered = runClustered;
    }
}

