/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle;

import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.util.IPdiContentProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SimpleContentGenerator;
import org.pentaho.platform.plugin.kettle.ParametersBean;
import org.pentaho.util.messages.LocaleHelper;

public class ParameterContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = -5766894670107979596L;
    private static final String PATH = "path";
    private static final String FILE = "file";
    private Log log = LogFactory.getLog(ParameterContentGenerator.class);

    public void createContent(OutputStream out) throws Exception {
        IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get(PATH);
        IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
        RepositoryFile file = null;
        if (pathParams != null) {
            file = (RepositoryFile)pathParams.getParameter(FILE);
        } else {
            IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, null);
            String path = URLDecoder.decode(requestParams.getStringParameter(PATH, ""), "UTF-8");
            file = repo.getFile(this.idTopath(path));
        }
        IPdiContentProvider provider = (IPdiContentProvider)((IPluginManager)PentahoSystem.get(IPluginManager.class)).getBean(IPdiContentProvider.class.getSimpleName());
        String[] userParams = provider.getUserParameters(file.getPath());
        ParametersBean paramBean = new ParametersBean(userParams, this.requestParameterToStringMap(requestParams));
        String response = paramBean.getParametersXmlString();
        out.write(response.getBytes(LocaleHelper.getSystemEncoding()));
        out.flush();
    }

    public String getMimeType() {
        return "text/xml";
    }

    public Log getLogger() {
        return this.log;
    }

    protected String idTopath(String id) {
        String path = id.replace(":", "/");
        if (path != null && path.length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        return path;
    }

    private Map<String, String> requestParameterToStringMap(IParameterProvider requestParams) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (requestParams != null) {
            Iterator it = requestParams.getParameterNames();
            while (it.hasNext()) {
                String name = (String)it.next();
                String value = requestParams.hasParameter(name) ? requestParams.getParameter(name).toString() : "";
                paramMap.put(name, value);
            }
        }
        return paramMap;
    }
}

