/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class BlockInfoUnderConstruction
extends BlockInfo {
    private HdfsServerConstants.BlockUCState blockUCState;
    private List<ReplicaUnderConstruction> replicas;
    private int primaryNodeIndex = -1;
    private long blockRecoveryId = 0L;

    public BlockInfoUnderConstruction(Block blk, int replication) {
        this(blk, replication, HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
    }

    public BlockInfoUnderConstruction(Block blk, int replication, HdfsServerConstants.BlockUCState state, DatanodeDescriptor[] targets) {
        super(blk, replication);
        assert (this.getBlockUCState() != HdfsServerConstants.BlockUCState.COMPLETE) : "BlockInfoUnderConstruction cannot be in COMPLETE state";
        this.blockUCState = state;
        this.setExpectedLocations(targets);
    }

    BlockInfo convertToCompleteBlock() throws IOException {
        assert (this.getBlockUCState() != HdfsServerConstants.BlockUCState.COMPLETE) : "Trying to convert a COMPLETE block";
        return new BlockInfo(this);
    }

    public void setExpectedLocations(DatanodeDescriptor[] targets) {
        int numLocations = targets == null ? 0 : targets.length;
        this.replicas = new ArrayList<ReplicaUnderConstruction>(numLocations);
        for (int i = 0; i < numLocations; ++i) {
            this.replicas.add(new ReplicaUnderConstruction(this, targets[i], HdfsServerConstants.ReplicaState.RBW));
        }
    }

    public DatanodeDescriptor[] getExpectedLocations() {
        int numLocations = this.replicas == null ? 0 : this.replicas.size();
        DatanodeDescriptor[] locations = new DatanodeDescriptor[numLocations];
        for (int i = 0; i < numLocations; ++i) {
            locations[i] = this.replicas.get(i).getExpectedLocation();
        }
        return locations;
    }

    public int getNumExpectedLocations() {
        return this.replicas == null ? 0 : this.replicas.size();
    }

    @Override
    public HdfsServerConstants.BlockUCState getBlockUCState() {
        return this.blockUCState;
    }

    void setBlockUCState(HdfsServerConstants.BlockUCState s) {
        this.blockUCState = s;
    }

    public long getBlockRecoveryId() {
        return this.blockRecoveryId;
    }

    public void setGenerationStampAndVerifyReplicas(long genStamp) {
        this.setGenerationStamp(genStamp);
        if (this.replicas == null) {
            return;
        }
        for (ReplicaUnderConstruction r : this.replicas) {
            if (genStamp == r.getGenerationStamp()) continue;
            r.getExpectedLocation().removeBlock(this);
            NameNode.blockStateChangeLog.info((Object)("BLOCK* Removing stale replica from location: " + r.getExpectedLocation()));
        }
    }

    void commitBlock(Block block) throws IOException {
        if (this.getBlockId() != block.getBlockId()) {
            throw new IOException("Trying to commit inconsistent block: id = " + block.getBlockId() + ", expected id = " + this.getBlockId());
        }
        this.blockUCState = HdfsServerConstants.BlockUCState.COMMITTED;
        this.set(this.getBlockId(), block.getNumBytes(), block.getGenerationStamp());
        this.setGenerationStampAndVerifyReplicas(block.getGenerationStamp());
    }

    public void initializeBlockRecovery(long recoveryId) {
        int i;
        this.setBlockUCState(HdfsServerConstants.BlockUCState.UNDER_RECOVERY);
        this.blockRecoveryId = recoveryId;
        if (this.replicas.size() == 0) {
            NameNode.blockStateChangeLog.warn((Object)"BLOCK* BlockInfoUnderConstruction.initLeaseRecovery: No blocks found, lease removed.");
        }
        boolean allLiveReplicasTriedAsPrimary = true;
        for (i = 0; i < this.replicas.size(); ++i) {
            if (!this.replicas.get(i).isAlive()) continue;
            allLiveReplicasTriedAsPrimary = allLiveReplicasTriedAsPrimary && this.replicas.get(i).getChosenAsPrimary();
        }
        if (allLiveReplicasTriedAsPrimary) {
            for (i = 0; i < this.replicas.size(); ++i) {
                this.replicas.get(i).setChosenAsPrimary(false);
            }
        }
        long mostRecentLastUpdate = 0L;
        ReplicaUnderConstruction primary = null;
        this.primaryNodeIndex = -1;
        for (int i2 = 0; i2 < this.replicas.size(); ++i2) {
            if (!this.replicas.get(i2).isAlive() || this.replicas.get(i2).getChosenAsPrimary() || this.replicas.get(i2).getExpectedLocation().getLastUpdate() <= mostRecentLastUpdate) continue;
            primary = this.replicas.get(i2);
            this.primaryNodeIndex = i2;
            mostRecentLastUpdate = primary.getExpectedLocation().getLastUpdate();
        }
        if (primary != null) {
            primary.getExpectedLocation().addBlockToBeRecovered(this);
            primary.setChosenAsPrimary(true);
            NameNode.blockStateChangeLog.info((Object)("BLOCK* " + this + " recovery started, primary=" + primary));
        }
    }

    void addReplicaIfNotPresent(DatanodeDescriptor dn, Block block, HdfsServerConstants.ReplicaState rState) {
        for (ReplicaUnderConstruction r : this.replicas) {
            if (r.getExpectedLocation() != dn) continue;
            r.setGenerationStamp(block.getGenerationStamp());
            return;
        }
        this.replicas.add(new ReplicaUnderConstruction(block, dn, rState));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(100);
        this.appendStringTo(b);
        return b.toString();
    }

    @Override
    public void appendStringTo(StringBuilder sb) {
        super.appendStringTo(sb);
        this.appendUCParts(sb);
    }

    private void appendUCParts(StringBuilder sb) {
        sb.append("{blockUCState=").append((Object)this.blockUCState).append(", primaryNodeIndex=").append(this.primaryNodeIndex).append(", replicas=[");
        Iterator<ReplicaUnderConstruction> iter = this.replicas.iterator();
        if (iter.hasNext()) {
            iter.next().appendStringTo(sb);
            while (iter.hasNext()) {
                sb.append(", ");
                iter.next().appendStringTo(sb);
            }
        }
        sb.append("]}");
    }

    static class ReplicaUnderConstruction
    extends Block {
        private DatanodeDescriptor expectedLocation;
        private HdfsServerConstants.ReplicaState state;
        private boolean chosenAsPrimary;

        ReplicaUnderConstruction(Block block, DatanodeDescriptor target, HdfsServerConstants.ReplicaState state) {
            super(block);
            this.expectedLocation = target;
            this.state = state;
            this.chosenAsPrimary = false;
        }

        DatanodeDescriptor getExpectedLocation() {
            return this.expectedLocation;
        }

        HdfsServerConstants.ReplicaState getState() {
            return this.state;
        }

        boolean getChosenAsPrimary() {
            return this.chosenAsPrimary;
        }

        void setState(HdfsServerConstants.ReplicaState s) {
            this.state = s;
        }

        void setChosenAsPrimary(boolean chosenAsPrimary) {
            this.chosenAsPrimary = chosenAsPrimary;
        }

        boolean isAlive() {
            return this.expectedLocation.isAlive;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || super.equals(obj);
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder(50);
            this.appendStringTo(b);
            return b.toString();
        }

        @Override
        public void appendStringTo(StringBuilder sb) {
            sb.append("ReplicaUnderConstruction[").append(this.expectedLocation).append("|").append((Object)this.state).append("]");
        }
    }
}

