/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.jcr.jackrabbit;

import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.extensions.jcr.JcrSessionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class JackrabbitSessionFactory
extends JcrSessionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JackrabbitSessionFactory.class);
    private Resource[] nodeDefinitions;
    private String contentType = "text/xml";

    protected void registerNodeTypes() throws Exception {
        if (!ObjectUtils.isEmpty((Object[])this.nodeDefinitions)) {
            Workspace ws = this.getSession().getWorkspace();
            JackrabbitNodeTypeManager jackrabbitNodeTypeManager = (JackrabbitNodeTypeManager)ws.getNodeTypeManager();
            boolean debug = LOG.isDebugEnabled();
            for (int i = 0; i < this.nodeDefinitions.length; ++i) {
                Resource resource = this.nodeDefinitions[i];
                if (debug) {
                    LOG.debug("adding node type definitions from " + resource.getDescription());
                }
                try {
                    jackrabbitNodeTypeManager.registerNodeTypes(resource.getInputStream(), this.contentType);
                    continue;
                }
                catch (RepositoryException ex) {
                    LOG.error("Error registering nodetypes ", ex.getCause());
                }
            }
        }
    }

    public void setNodeDefinitions(Resource[] nodeDefinitions) {
        this.nodeDefinitions = nodeDefinitions;
    }

    public void setContentType(String contentType) {
        Assert.hasText((String)contentType, (String)"contentType is required");
        this.contentType = contentType;
    }
}

