/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.impl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpf.repository.IRepositoryFile;
import pt.webdetails.cpf.repository.IRepositoryFileFilter;

public class DefaultRepositoryFile
implements IRepositoryFile {
    private static Log log = LogFactory.getLog(DefaultRepositoryFile.class);
    private File file;

    public DefaultRepositoryFile(File file) {
        this.file = file;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public String getSolutionPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getSolution() {
        return this.file.getPath();
    }

    @Override
    public String getFullPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public IRepositoryFile[] listFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IRepositoryFile[] listFiles(IRepositoryFileFilter iff) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRoot() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IRepositoryFile retrieveParent() {
        return new DefaultRepositoryFile(this.file.getParentFile());
    }

    @Override
    public byte[] getData() {
        if (this.file != null && this.file.exists() && this.file.canRead()) {
            try {
                return FileUtils.readFileToByteArray((File)this.file);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public String getExtension() {
        return FilenameUtils.getExtension((String)this.file.getName());
    }
}

