/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.AbstractPrimitiveLazyObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyByteObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDateObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyFloatObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyShortObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyVoidObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.BaseTypeParams;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeSpec;

public final class LazyPrimitiveObjectInspectorFactory {
    public static final LazyBooleanObjectInspector LAZY_BOOLEAN_OBJECT_INSPECTOR = new LazyBooleanObjectInspector();
    public static final LazyByteObjectInspector LAZY_BYTE_OBJECT_INSPECTOR = new LazyByteObjectInspector();
    public static final LazyShortObjectInspector LAZY_SHORT_OBJECT_INSPECTOR = new LazyShortObjectInspector();
    public static final LazyIntObjectInspector LAZY_INT_OBJECT_INSPECTOR = new LazyIntObjectInspector();
    public static final LazyLongObjectInspector LAZY_LONG_OBJECT_INSPECTOR = new LazyLongObjectInspector();
    public static final LazyFloatObjectInspector LAZY_FLOAT_OBJECT_INSPECTOR = new LazyFloatObjectInspector();
    public static final LazyDoubleObjectInspector LAZY_DOUBLE_OBJECT_INSPECTOR = new LazyDoubleObjectInspector();
    public static final LazyVoidObjectInspector LAZY_VOID_OBJECT_INSPECTOR = new LazyVoidObjectInspector();
    public static final LazyDateObjectInspector LAZY_DATE_OBJECT_INSPECTOR = new LazyDateObjectInspector();
    public static final LazyTimestampObjectInspector LAZY_TIMESTAMP_OBJECT_INSPECTOR = new LazyTimestampObjectInspector();
    public static final LazyBinaryObjectInspector LAZY_BINARY_OBJECT_INSPECTOR = new LazyBinaryObjectInspector();
    public static final LazyHiveDecimalObjectInspector LAZY_BIG_DECIMAL_OBJECT_INSPECTOR = new LazyHiveDecimalObjectInspector();
    public static final LazyHiveVarcharObjectInspector LAZY_VARCHAR_OBJECT_INSPECTOR = new LazyHiveVarcharObjectInspector(PrimitiveObjectInspectorUtils.varcharTypeEntry);
    static HashMap<ArrayList<Object>, LazyStringObjectInspector> cachedLazyStringObjectInspector = new HashMap();
    static PrimitiveObjectInspectorUtils.ParameterizedObjectInspectorMap cachedParameterizedLazyObjectInspectors = new PrimitiveObjectInspectorUtils.ParameterizedObjectInspectorMap();

    public static LazyStringObjectInspector getLazyStringObjectInspector(boolean escaped, byte escapeChar) {
        ArrayList<Comparable<Boolean>> signature = new ArrayList<Comparable<Boolean>>();
        signature.add(Boolean.valueOf(escaped));
        signature.add(Byte.valueOf(escapeChar));
        LazyStringObjectInspector result = cachedLazyStringObjectInspector.get(signature);
        if (result == null) {
            result = new LazyStringObjectInspector(escaped, escapeChar);
            cachedLazyStringObjectInspector.put(signature, result);
        }
        return result;
    }

    public static PrimitiveObjectInspector getParameterizedObjectInspector(PrimitiveTypeSpec typeSpec) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeSpec.getPrimitiveCategory();
        BaseTypeParams typeParams = typeSpec.getTypeParams();
        PrimitiveObjectInspector poi = cachedParameterizedLazyObjectInspectors.getObjectInspector(typeSpec);
        if (poi == null) {
            switch (primitiveCategory) {
                case VARCHAR: {
                    PrimitiveObjectInspectorUtils.PrimitiveTypeEntry typeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeSpecs(primitiveCategory, typeParams);
                    poi = new LazyHiveVarcharObjectInspector(typeEntry);
                    poi.setTypeParams(typeParams);
                    cachedParameterizedLazyObjectInspectors.setObjectInspector(poi);
                    break;
                }
                default: {
                    throw new RuntimeException("Primitve type " + (Object)((Object)primitiveCategory) + " should not take parameters");
                }
            }
        }
        return poi;
    }

    public static AbstractPrimitiveLazyObjectInspector<?> getLazyObjectInspector(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, boolean escaped, byte escapeChar) {
        switch (primitiveCategory) {
            case BOOLEAN: {
                return LAZY_BOOLEAN_OBJECT_INSPECTOR;
            }
            case BYTE: {
                return LAZY_BYTE_OBJECT_INSPECTOR;
            }
            case SHORT: {
                return LAZY_SHORT_OBJECT_INSPECTOR;
            }
            case INT: {
                return LAZY_INT_OBJECT_INSPECTOR;
            }
            case LONG: {
                return LAZY_LONG_OBJECT_INSPECTOR;
            }
            case FLOAT: {
                return LAZY_FLOAT_OBJECT_INSPECTOR;
            }
            case DOUBLE: {
                return LAZY_DOUBLE_OBJECT_INSPECTOR;
            }
            case STRING: {
                return LazyPrimitiveObjectInspectorFactory.getLazyStringObjectInspector(escaped, escapeChar);
            }
            case VARCHAR: {
                return LAZY_VARCHAR_OBJECT_INSPECTOR;
            }
            case BINARY: {
                return LAZY_BINARY_OBJECT_INSPECTOR;
            }
            case VOID: {
                return LAZY_VOID_OBJECT_INSPECTOR;
            }
            case DATE: {
                return LAZY_DATE_OBJECT_INSPECTOR;
            }
            case TIMESTAMP: {
                return LAZY_TIMESTAMP_OBJECT_INSPECTOR;
            }
            case DECIMAL: {
                return LAZY_BIG_DECIMAL_OBJECT_INSPECTOR;
            }
        }
        throw new RuntimeException("Internal error: Cannot find ObjectInspector  for " + (Object)((Object)primitiveCategory));
    }

    public static AbstractPrimitiveLazyObjectInspector<?> getLazyObjectInspector(PrimitiveTypeSpec typeSpec, boolean escaped, byte escapeChar) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeSpec.getPrimitiveCategory();
        BaseTypeParams typeParams = typeSpec.getTypeParams();
        if (typeParams == null) {
            return LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector(primitiveCategory, escaped, escapeChar);
        }
        switch (primitiveCategory) {
            case VARCHAR: {
                LazyHiveVarcharObjectInspector oi = (LazyHiveVarcharObjectInspector)LazyPrimitiveObjectInspectorFactory.getParameterizedObjectInspector(typeSpec);
                return oi;
            }
        }
        throw new RuntimeException("Type " + (Object)((Object)primitiveCategory) + " does not take parameters");
    }

    private LazyPrimitiveObjectInspectorFactory() {
    }
}

