/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class XQueryConnectionAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.XQueryLookupRule";
    public static final String PREPARED_COMPONENT_ELEMENT = "prepared_component";
    public static final String DEFAULT_CONNECTION_NAME = "shared_xquery_connection";
    protected static final String[] EXPECTED_OUTPUTS = new String[]{"prepared_component"};

    public XQueryConnectionAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public XQueryConnectionAction() {
        super(COMPONENT_NAME);
    }

    public static boolean accepts(Element element) {
        boolean result = false;
        if (ActionDefinition.accepts(element) && XQueryConnectionAction.hasComponentName(element, COMPONENT_NAME)) {
            Element connectionOutput = (Element)element.selectSingleNode("action-outputs/prepared_component");
            result = connectionOutput != null && "xquery-connection".equals(connectionOutput.attributeValue("type"));
        }
        return result;
    }

    @Override
    public String[] getReservedInputNames() {
        return new String[0];
    }

    @Override
    public String[] getReservedOutputNames() {
        return EXPECTED_OUTPUTS;
    }

    @Override
    public String[] getReservedResourceNames() {
        return new String[0];
    }

    public void setOutputConnection(String publicOutputName) {
        this.setOutput(PREPARED_COMPONENT_ELEMENT, publicOutputName, "xquery-connection");
    }

    public IActionOutput getOutputConnection() {
        return this.getOutput(PREPARED_COMPONENT_ELEMENT);
    }

    @Override
    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateOutput(PREPARED_COMPONENT_ELEMENT);
        if (validationError != null) {
            if (validationError.errorCode == 4) {
                validationError.errorMsg = "Missing output connection name.";
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    @Override
    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setOutputConnection(DEFAULT_CONNECTION_NAME);
    }
}

