/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class JavascriptAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.JavascriptRule";
    public static final String SCRIPT_ELEMENT = "script";
    protected static final String[] EXPECTED_INPUTS = new String[]{"script"};

    public JavascriptAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public JavascriptAction() {
        super(COMPONENT_NAME);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && JavascriptAction.hasComponentName(element, COMPONENT_NAME);
    }

    @Override
    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public void setScript(IActionInputSource value) {
        this.setActionInputValue(SCRIPT_ELEMENT, value);
    }

    public IActionInput getScript() {
        return this.getInput(SCRIPT_ELEMENT);
    }

    @Override
    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(SCRIPT_ELEMENT);
        if (validationError != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing javascript input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Javascript input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Javascript input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if (this.getOutputs().length == 0) {
            validationError = new ActionSequenceValidationError();
            validationError.errorCode = 4;
            validationError.errorMsg = "Missing javascript output parameter.";
            validationError.actionDefinition = this;
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }
}

