/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.io.FileNotFoundException;
import java.net.URI;
import java.util.AbstractList;
import java.util.ArrayList;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionResource;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.ActionInputTypeFilter;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;
import org.pentaho.commons.connection.IPentahoStreamSource;

public class JFreeReportAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.jfree.JFreeReportComponent";
    public static final String JFREE_COMPONENT_SHORT_NAME = "JFreeReportComponent";
    public static final String JFREE_WIZ_COMPONENT_SHORT_NAME = "ReportWizardSpecComponent";
    public static final String OUTPUT_TYPE_ELEMENT = "output-type";
    public static final String REPORT_OUTPUT_ELEMENT = "report-output";
    public static final String DRIVER_ELEMENT = "driver";
    public static final String CONNECTION_ELEMENT = "connection";
    public static final String USER_ID_ELEMENT = "user-id";
    public static final String PASSWORD_ELEMENT = "password";
    public static final String LIVE_CONNECTION_ELEMENT = "live";
    public static final String JNDI_ELEMENT = "jndi";
    public static final String DATA_ELEMENT = "data";
    public static final String QUERY_ELEMENT = "query";
    public static final String XSL_ELEMENT = "xsl";
    public static final String REPORT_DEFINITION_ELEMENT = "report-definition";
    public static final String REPORT_WIZ_SPEC_ELEMENT = "report-spec";
    public static final String REPORT_DATA_SOURCE_ELEMENT = "source";
    public static final String REPORT_JAR_ELEMENT = "report-jar";
    public static final String REPORT_LOC_IN_JAR_ELEMENT = "report-location";
    public static final String MDX_DATA_SOURCE = "mdx";
    public static final String SQL_DATA_SOURCE = "sql";
    public static final String OUTPUT_REPORT = "output-report";
    public static final String REPORT_DATA_JAR_ELEMENT = "report-jar";
    public static final String RESOURCE_NAME_ELEMENT = "resource-name";
    public static final String REPORT_DATA_JAR_CLASS_ELEMENT = "class-location";
    public static final String CONFIG_PARAM_NAME = "name";
    private static final String REPORT_CONFIG_ELEMENT = "report_configuration_parameters";
    private static final String REPORT_CONFIG_INPUT_PARAM = "config_parameters";
    public static final String CREATE_PRIVATE_COPY_ELEMENT = "create_private_report";
    public static final String REPORT_GEN_PRIORITY_ELEMENT = "report-priority";
    public static final String PRINTER_NAME_ELEMENT = "printer-name";
    public static final String HTML_CONTENT_HANDLER_ELEMENT = "content-handler";
    public static final String REPORT_GEN_YIELD_RATE_ELEMENT = "yield-rate";
    private DataJar dataJar = new DataJar();
    private ReportDefinitionJar reportJar = new ReportDefinitionJar();
    private StaticReportConfig staticReportConfig = new StaticReportConfig();
    protected static final String[] EXPECTED_RESOURCES = new String[]{"report-definition", "report-spec"};
    protected static final String[] EXPECTED_INPUTS = new String[]{"data", "driver", "connection", "user-id", "password", "jndi", "query", "xsl", "output-type"};

    public JFreeReportAction(Element actionDefElement, IActionParameterMgr actionParameterMgr) {
        super(actionDefElement, actionParameterMgr);
    }

    public JFreeReportAction() {
        super(COMPONENT_NAME);
    }

    @Override
    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setComponentDefinition(OUTPUT_TYPE_ELEMENT, "html");
    }

    @Override
    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    @Override
    public String[] getReservedOutputNames() {
        IActionOutput[] actionOutputs;
        String expectedOutput = REPORT_OUTPUT_ELEMENT;
        if (this.getOutput(expectedOutput) == null && (actionOutputs = this.getOutputs("content")).length > 0) {
            expectedOutput = actionOutputs[0].getName();
        }
        return new String[]{expectedOutput};
    }

    @Override
    public String[] getReservedResourceNames() {
        return EXPECTED_RESOURCES;
    }

    public static boolean accepts(Element element) {
        boolean accepts = false;
        if (ActionDefinition.accepts(element)) {
            String elementComponentName = JFreeReportAction.getComponentName(element);
            int index = elementComponentName.lastIndexOf(".");
            if (index >= 0 && index < elementComponentName.length() - 1) {
                elementComponentName = elementComponentName.substring(index + 1);
            }
            accepts = elementComponentName.equals(JFREE_COMPONENT_SHORT_NAME) || elementComponentName.equals(JFREE_WIZ_COMPONENT_SHORT_NAME);
        }
        return accepts;
    }

    public void setConnection(IActionInputSource value) {
        this.setActionInputValue(CONNECTION_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
            this.setData(null);
            this.setDataComponent(null);
            this.getDataJar().setJar(null);
            this.getDataJar().setDataClass(null);
        }
    }

    public IActionInput getConnection() {
        return this.getInput(CONNECTION_ELEMENT);
    }

    public void setUserId(IActionInputSource value) {
        this.setActionInputValue(USER_ID_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
            this.setData(null);
            this.setDataComponent(null);
            this.getDataJar().setJar(null);
            this.getDataJar().setDataClass(null);
        }
    }

    public IActionInput getUserId() {
        return this.getInput(USER_ID_ELEMENT);
    }

    public void setDriver(IActionInputSource value) {
        this.setActionInputValue(DRIVER_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
            this.setData(null);
            this.setDataComponent(null);
            this.getDataJar().setJar(null);
            this.getDataJar().setDataClass(null);
        }
    }

    public IActionInput getDriver() {
        return this.getInput(DRIVER_ELEMENT);
    }

    public void setPassword(IActionInputSource value) {
        this.setActionInputValue(PASSWORD_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
            this.setData(null);
            this.setDataComponent(null);
            this.getDataJar().setJar(null);
            this.getDataJar().setDataClass(null);
        }
    }

    public IActionInput getPassword() {
        return this.getInput(PASSWORD_ELEMENT);
    }

    public void setJndi(IActionInputSource value) {
        this.setActionInputValue(JNDI_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setDriver(null);
            this.setConnection(null);
            this.setUserId(null);
            this.setPassword(null);
            this.setData(null);
            this.setDataComponent(null);
            this.getDataJar().setJar(null);
            this.getDataJar().setDataClass(null);
        }
    }

    public IActionInput getJndi() {
        return this.getInput(JNDI_ELEMENT);
    }

    public void setOutputType(IActionInputSource value) {
        this.setActionInputValue(OUTPUT_TYPE_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setPrinterName(null);
        }
    }

    public IActionInput getOutputType() {
        return this.getInput(OUTPUT_TYPE_ELEMENT);
    }

    public void setPrinterName(IActionInputSource value) {
        this.setActionInputValue(PRINTER_NAME_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setOutputType(null);
        }
    }

    public IActionInput getPrinterName() {
        return this.getInput(PRINTER_NAME_ELEMENT);
    }

    public IActionInput getData() {
        return this.getInput(DATA_ELEMENT);
    }

    public void setData(IActionInputSource value) {
        if (value instanceof ActionInputConstant) {
            throw new IllegalArgumentException();
        }
        this.setActionInputValue(DATA_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setDataComponent(null);
            this.getDataJar().setJar(null);
            this.getDataJar().setDataClass(null);
            this.setDriver(null);
            this.setConnection(null);
            this.setUserId(null);
            this.setPassword(null);
            this.setJndi(null);
            this.setQuery(null);
        }
    }

    public void setQuery(IActionInputSource value) {
        this.setActionInputValue(QUERY_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setData(null);
            this.setDataComponent(null);
            this.getDataJar().setJar(null);
            this.getDataJar().setDataClass(null);
        }
    }

    public IActionInput getQuery() {
        return this.getInput(QUERY_ELEMENT);
    }

    public void setOutputReport(String publicOutputName) {
        this.setOutput(REPORT_OUTPUT_ELEMENT, publicOutputName, "content");
        if (publicOutputName != null && publicOutputName.trim().length() > 0) {
            IActionOutput[] actionOutputs = this.getOutputs();
            for (int i = 0; i < actionOutputs.length; ++i) {
                if (!actionOutputs[i].getType().equals("content") || actionOutputs[i].getName().equals(REPORT_OUTPUT_ELEMENT)) continue;
                actionOutputs[i].delete();
            }
        }
    }

    public IActionOutput getOutputReport() {
        IActionOutput[] actionOutputs;
        String privateOutputName = REPORT_OUTPUT_ELEMENT;
        if (this.getOutput(privateOutputName) == null && (actionOutputs = this.getOutputs("content")).length > 0) {
            privateOutputName = actionOutputs[0].getName();
        }
        return this.getOutput(REPORT_OUTPUT_ELEMENT);
    }

    public ActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(DATA_ELEMENT);
        if (validationError != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing report data input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Report data input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Report data input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((validationError = this.validateResource(REPORT_DEFINITION_ELEMENT)) != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing report definition input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Report definition input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Report definition input parameter is unitialized.";
                }
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public IActionResource setReportDefinition(URI uri, String mimeType) {
        IActionResource actionResource = null;
        if (uri == null) {
            this.setResourceUri(REPORT_DEFINITION_ELEMENT, null, mimeType);
            this.setResourceUri(REPORT_WIZ_SPEC_ELEMENT, null, mimeType);
        } else {
            String componentName = JFREE_COMPONENT_SHORT_NAME;
            if (uri.getSchemeSpecificPart().indexOf(".xreportspec") >= 0) {
                componentName = JFREE_WIZ_COMPONENT_SHORT_NAME;
            }
            if (!this.getComponentName().endsWith(componentName)) {
                this.setComponentName(componentName);
            }
            if (JFREE_COMPONENT_SHORT_NAME.equals(componentName)) {
                this.setResourceUri(REPORT_WIZ_SPEC_ELEMENT, null, null);
                actionResource = this.setResourceUri(REPORT_DEFINITION_ELEMENT, uri, mimeType);
            } else if (JFREE_WIZ_COMPONENT_SHORT_NAME.equals(componentName)) {
                this.setResourceUri(REPORT_DEFINITION_ELEMENT, null, null);
                actionResource = this.setResourceUri(REPORT_WIZ_SPEC_ELEMENT, uri, mimeType);
            }
            this.setReportDefinition(null);
            this.getReportDefinitionJar().setJar(null);
            this.getReportDefinitionJar().setReportLocation(null);
        }
        return actionResource;
    }

    public Object getReportDefinition() {
        Object resourceName;
        IActionResource actionResource = null;
        if (this.getComponentName().endsWith(JFREE_COMPONENT_SHORT_NAME)) {
            actionResource = this.getResource(REPORT_DEFINITION_ELEMENT);
        } else if (this.getComponentName().endsWith(JFREE_WIZ_COMPONENT_SHORT_NAME)) {
            actionResource = this.getResource(REPORT_WIZ_SPEC_ELEMENT);
        }
        if (actionResource == null && (resourceName = this.getInput(RESOURCE_NAME_ELEMENT).getValue()) != null) {
            actionResource = this.getResource(resourceName.toString());
        }
        Object reportDefinition = actionResource == null ? this.getInput(REPORT_DEFINITION_ELEMENT) : actionResource;
        return reportDefinition;
    }

    public IPentahoStreamSource getReportDefinitionDataSource() throws FileNotFoundException {
        Object reportDefinition = this.getReportDefinition();
        return reportDefinition instanceof ActionResource ? ((ActionResource)reportDefinition).getDataSource() : null;
    }

    public void setReportDefinition(IActionInputVariable value) {
        if (value instanceof ActionInputConstant) {
            throw new IllegalArgumentException();
        }
        this.setActionInputValue(REPORT_DEFINITION_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)((Object)value)).getValue() != null) {
            if (!this.getComponentName().endsWith(JFREE_COMPONENT_SHORT_NAME)) {
                this.setComponentName(JFREE_COMPONENT_SHORT_NAME);
            }
            this.setReportDefinition(null, null);
            this.getReportDefinitionJar().setJar(null);
            this.getReportDefinitionJar().setReportLocation(null);
        }
    }

    public void setDataComponent(IActionInputSource value) {
        this.setActionInputValue(REPORT_DATA_SOURCE_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setData(null);
            this.getDataJar().setJar(null);
            this.getDataJar().setDataClass(null);
            this.setDriver(null);
            this.setConnection(null);
            this.setUserId(null);
            this.setPassword(null);
            this.setJndi(null);
            this.setQuery(null);
        }
    }

    public IActionInput getDataComponent() {
        return this.getInput(REPORT_DATA_SOURCE_ELEMENT);
    }

    public DataJar getDataJar() {
        return this.dataJar;
    }

    public ReportDefinitionJar getReportDefinitionJar() {
        return this.reportJar;
    }

    public void setReportConfig(IActionInputSource value) {
        if (value instanceof ActionInputConstant) {
            throw new IllegalArgumentException();
        }
        this.setActionInputValue(REPORT_CONFIG_INPUT_PARAM, value);
    }

    public IActionInput getReportConfig() {
        IActionInput reportConfig = this.getInput(REPORT_CONFIG_INPUT_PARAM);
        if (reportConfig.getValue() == null) {
            reportConfig = new ActionInputConstant(this.staticReportConfig, this.actionParameterMgr);
        }
        return reportConfig;
    }

    public void setCreatePrivateCopy(IActionInputSource value) {
        this.setActionInputValue(CREATE_PRIVATE_COPY_ELEMENT, value);
    }

    public IActionInput getCreatePrivateCopy() {
        return this.getInput(CREATE_PRIVATE_COPY_ELEMENT);
    }

    public void setReportGenerationPriority(IActionInputSource value) {
        this.setActionInputValue(REPORT_GEN_PRIORITY_ELEMENT, value);
    }

    public IActionInput getReportGenerationPriority() {
        return this.getInput(REPORT_GEN_PRIORITY_ELEMENT);
    }

    public void setHtmlContentHandlerUrlPattern(IActionInputSource value) {
        this.setActionInputValue(HTML_CONTENT_HANDLER_ELEMENT, value);
    }

    public IActionInput getHtmlContentHandlerUrlPattern() {
        return this.getInput(HTML_CONTENT_HANDLER_ELEMENT);
    }

    public void setReportGenerationYieldRate(IActionInputSource value) {
        this.setActionInputValue(REPORT_GEN_YIELD_RATE_ELEMENT, value);
    }

    public IActionInput getReportGenerationYieldRate() {
        IActionInput actionInput = this.getInput(REPORT_GEN_YIELD_RATE_ELEMENT);
        if (actionInput instanceof ActionInput) {
            actionInput = new YieldRateInput(((ActionInput)actionInput).getElement(), ((ActionInput)actionInput).getParameterMgr());
        }
        return actionInput;
    }

    public ActionInput[] getSubreportQueryParams() {
        ArrayList<IActionInput> subreportQueryParams = new ArrayList<IActionInput>();
        ActionInput mainReportData = (ActionInput)this.getData();
        IActionInput[] actionInputs = this.getInputs(new ActionInputTypeFilter(new String[]{"result-set", "mdx-query", "sql-query", "xquery", "hql-query"}));
        for (int i = 0; i < actionInputs.length; ++i) {
            if (actionInputs[i].equals(mainReportData)) continue;
            subreportQueryParams.add(actionInputs[i]);
        }
        return subreportQueryParams.toArray(new ActionInput[0]);
    }

    public void setSubReportQueryParams(IActionInputVariable[] subQueryVariables) {
        int i;
        ActionInput[] actionInputs = this.getSubreportQueryParams();
        for (i = 0; i < actionInputs.length; ++i) {
            actionInputs[i].delete();
        }
        if (subQueryVariables != null) {
            for (i = 0; i < subQueryVariables.length; ++i) {
                this.setActionInputValue(subQueryVariables[i].getVariableName(), subQueryVariables[i]);
            }
        }
    }

    public void setXsl(IActionInputSource value) {
        this.setActionInputValue(XSL_ELEMENT, value);
    }

    public IActionInput getXsl() {
        return this.getInput(XSL_ELEMENT);
    }

    public class ReportDefinitionJar {
        ReportDefinitionJar() {
        }

        public void setReportLocation(String location) {
            JFreeReportAction.this.setActionInputValue(JFreeReportAction.REPORT_LOC_IN_JAR_ELEMENT, new ActionInputConstant(location, null));
            if (location != null) {
                if (!JFreeReportAction.this.getComponentName().endsWith(JFreeReportAction.JFREE_COMPONENT_SHORT_NAME)) {
                    JFreeReportAction.this.setComponentName(JFreeReportAction.JFREE_COMPONENT_SHORT_NAME);
                }
                JFreeReportAction.this.setReportDefinition(null, null);
                JFreeReportAction.this.setReportDefinition(null);
            }
        }

        public String getReportLocation() {
            Object location = JFreeReportAction.this.getInput(JFreeReportAction.REPORT_LOC_IN_JAR_ELEMENT).getValue();
            if (location != null && JFreeReportAction.this.actionParameterMgr != null) {
                location = JFreeReportAction.this.actionParameterMgr.replaceParameterReferences(location.toString());
            }
            return location != null ? location.toString() : (String)location;
        }

        public void setReportLocationParam(IActionInputVariable variable) {
            JFreeReportAction.this.setActionInputValue(JFreeReportAction.REPORT_LOC_IN_JAR_ELEMENT, variable);
            if (variable != null) {
                if (!JFreeReportAction.this.getComponentName().endsWith(JFreeReportAction.JFREE_COMPONENT_SHORT_NAME)) {
                    JFreeReportAction.this.setComponentName(JFreeReportAction.JFREE_COMPONENT_SHORT_NAME);
                }
                JFreeReportAction.this.setReportDefinition(null, null);
                JFreeReportAction.this.setReportDefinition(null);
            }
        }

        public ActionInput getReportLocationParam() {
            return JFreeReportAction.this.getInputParam(JFreeReportAction.REPORT_LOC_IN_JAR_ELEMENT);
        }

        public IActionResource setJar(URI uri) {
            IActionResource actionResource = JFreeReportAction.this.setResourceUri("report-jar", uri, "application/java-archive");
            if (uri != null) {
                if (!JFreeReportAction.this.getComponentName().endsWith(JFreeReportAction.JFREE_COMPONENT_SHORT_NAME)) {
                    JFreeReportAction.this.setComponentName(JFreeReportAction.JFREE_COMPONENT_SHORT_NAME);
                }
                JFreeReportAction.this.setReportDefinition(null, null);
                JFreeReportAction.this.setReportDefinition(null);
            }
            return actionResource;
        }

        public IActionResource getJar() {
            return JFreeReportAction.this.getResource("report-jar");
        }
    }

    public class DataJar {
        DataJar() {
        }

        public void setDataClass(String className) {
            ActionInputConstant actConstant = new ActionInputConstant(className, null);
            JFreeReportAction.this.setActionInputValue(JFreeReportAction.REPORT_DATA_JAR_CLASS_ELEMENT, actConstant);
            if (className != null) {
                JFreeReportAction.this.setData(null);
                JFreeReportAction.this.setDataComponent(null);
                JFreeReportAction.this.setDriver(null);
                JFreeReportAction.this.setConnection(null);
                JFreeReportAction.this.setUserId(null);
                JFreeReportAction.this.setPassword(null);
                JFreeReportAction.this.setJndi(null);
                JFreeReportAction.this.setQuery(null);
            }
        }

        public String getDataClass() {
            Object className = JFreeReportAction.this.getInput(JFreeReportAction.REPORT_DATA_JAR_CLASS_ELEMENT).getValue();
            if (className != null && JFreeReportAction.this.actionParameterMgr != null) {
                className = JFreeReportAction.this.actionParameterMgr.replaceParameterReferences(className.toString());
            }
            return className != null ? className.toString() : (String)className;
        }

        public void setDataClassParam(IActionInputVariable variable) {
            JFreeReportAction.this.setActionInputValue(JFreeReportAction.REPORT_DATA_JAR_CLASS_ELEMENT, variable);
            if (variable != null) {
                JFreeReportAction.this.setData(null);
                JFreeReportAction.this.setDataComponent(null);
                JFreeReportAction.this.setDriver(null);
                JFreeReportAction.this.setConnection(null);
                JFreeReportAction.this.setUserId(null);
                JFreeReportAction.this.setPassword(null);
                JFreeReportAction.this.setJndi(null);
                JFreeReportAction.this.setQuery(null);
            }
        }

        public ActionInput getDataClassParam() {
            return JFreeReportAction.this.getInputParam(JFreeReportAction.REPORT_DATA_JAR_CLASS_ELEMENT);
        }

        public IActionResource setJar(URI uri) {
            IActionResource actionResource = JFreeReportAction.this.setResourceUri("report-jar", uri, "application/java-archive");
            if (uri != null) {
                JFreeReportAction.this.setData(null);
                JFreeReportAction.this.setDataComponent(null);
                JFreeReportAction.this.setDriver(null);
                JFreeReportAction.this.setConnection(null);
                JFreeReportAction.this.setUserId(null);
                JFreeReportAction.this.setPassword(null);
                JFreeReportAction.this.setJndi(null);
                JFreeReportAction.this.setQuery(null);
            }
            return actionResource;
        }

        public IActionResource getJar() {
            return JFreeReportAction.this.getResource("report-jar");
        }
    }

    public class StaticReportConfig
    extends AbstractList {
        public Object add(String paramName, String paramValue) {
            Element element = DocumentHelper.makeElement((Branch)JFreeReportAction.this.getElement(), (String)"component-definition/report_configuration_parameters");
            element.addElement(paramName);
            element.addAttribute(JFreeReportAction.CONFIG_PARAM_NAME, paramName);
            element.setText(paramValue);
            return new StaticReportConfigItem(element);
        }

        @Override
        public Object get(int i) {
            return new StaticReportConfigItem(JFreeReportAction.this.getComponentDefElements("report_configuration_parameters/*")[i]);
        }

        @Override
        public Object remove(int i) {
            StaticReportConfigItem staticReportConfigItem = (StaticReportConfigItem)this.get(i);
            staticReportConfigItem.delete();
            return staticReportConfigItem;
        }

        @Override
        public int size() {
            return JFreeReportAction.this.getComponentDefElements("report_configuration_parameters/*").length;
        }
    }

    public class StaticReportConfigItem {
        Element configurationElement;

        StaticReportConfigItem(Element configurationElement) {
            this.configurationElement = configurationElement;
        }

        public String getName() {
            return this.configurationElement.attributeValue(JFreeReportAction.CONFIG_PARAM_NAME);
        }

        public String getValue() {
            return this.configurationElement.getText();
        }

        public void setName(String name) {
            this.configurationElement.addAttribute(JFreeReportAction.CONFIG_PARAM_NAME, name);
        }

        public void setValue(String value) {
            this.configurationElement.setText(value);
        }

        public void delete() {
            this.configurationElement.detach();
        }
    }

    public class YieldRateInput
    extends ActionInput {
        YieldRateInput(Element element, IActionParameterMgr actionParameterMgr) {
            super(element, actionParameterMgr);
        }

        @Override
        public Integer getIntValue() {
            Integer intValue = null;
            Object value = this.getValue();
            if (value != null) {
                if (value instanceof Number) {
                    Number n = (Number)value;
                    if (n.intValue() > 0) {
                        intValue = n.intValue();
                    }
                } else {
                    try {
                        intValue = Integer.parseInt(value.toString());
                    }
                    catch (Exception ex) {
                        intValue = null;
                    }
                }
            }
            return intValue;
        }
    }
}

