/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.EmailAttachment;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class EmailAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.EmailComponent";
    public static final String TO_ELEMENT = "to";
    public static final String FROM_ELEMENT = "from";
    public static final String CC_ELEMENT = "cc";
    public static final String BCC_ELEMENT = "bcc";
    public static final String SUBJECT_ELEMENT = "subject";
    public static final String PLAIN_MSG_ELEMENT = "message-plain";
    public static final String HTML_MSG_ELEMENT = "message-html";
    protected static final String[] EXPECTED_INPUTS = new String[]{"to", "from", "cc", "bcc", "subject", "message-plain", "message-html"};

    public EmailAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public EmailAction() {
        super(COMPONENT_NAME);
    }

    @Override
    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && EmailAction.hasComponentName(element, COMPONENT_NAME);
    }

    public void setTo(IActionInputSource value) {
        this.setActionInputValue(TO_ELEMENT, value);
    }

    public IActionInput getTo() {
        HashMapInput hashMapInput;
        IActionInput actionInput = this.getInput(TO_ELEMENT);
        if (actionInput.getValue() instanceof HashMap && (hashMapInput = new HashMapInput(((ActionInput)actionInput).getElement(), ((ActionInput)actionInput).getParameterMgr(), TO_ELEMENT)).getValue() != null) {
            actionInput = hashMapInput;
        }
        return actionInput;
    }

    public void setFrom(IActionInputSource value) {
        this.setActionInputValue(FROM_ELEMENT, value);
    }

    public IActionInput getFrom() {
        return this.getInput(FROM_ELEMENT);
    }

    public void setCc(IActionInputSource value) {
        this.setActionInputValue(CC_ELEMENT, value);
    }

    public IActionInput getCc() {
        return this.getInput(CC_ELEMENT);
    }

    public void setBcc(IActionInputSource value) {
        this.setActionInputValue(BCC_ELEMENT, value);
    }

    public IActionInput getBcc() {
        return this.getInput(BCC_ELEMENT);
    }

    public void setMessageHtml(IActionInputSource value) {
        this.setActionInputValue(HTML_MSG_ELEMENT, value);
    }

    public IActionInput getMessageHtml() {
        IActionInput actInput = this.getInput(HTML_MSG_ELEMENT);
        if (actInput instanceof ActionInput) {
            actInput = new HTMLMsgInput(((ActionInput)actInput).getElement(), ((ActionInput)actInput).getParameterMgr());
        }
        return actInput;
    }

    public void setMessagePlain(IActionInputSource value) {
        this.setActionInputValue(PLAIN_MSG_ELEMENT, value);
    }

    public IActionInput getMessagePlain() {
        IActionInput actionInput = this.getInput(TO_ELEMENT);
        if (actionInput.getValue() instanceof HashMap) {
            if ((actionInput = new HashMapInput(((ActionInput)actionInput).getElement(), ((ActionInput)actionInput).getParameterMgr(), PLAIN_MSG_ELEMENT)).getValue() == null) {
                actionInput = null;
            }
        } else {
            actionInput = null;
        }
        if (actionInput == null) {
            actionInput = this.getInput(PLAIN_MSG_ELEMENT);
        }
        return actionInput;
    }

    public void setSubject(IActionInputSource subject) {
        this.setActionInputValue(SUBJECT_ELEMENT, subject);
    }

    public IActionInput getSubject() {
        IActionInput actionInput = this.getInput(TO_ELEMENT);
        if (actionInput.getValue() instanceof HashMap) {
            if ((actionInput = new HashMapInput(((ActionInput)actionInput).getElement(), ((ActionInput)actionInput).getParameterMgr(), SUBJECT_ELEMENT)).getValue() == null) {
                actionInput = null;
            }
        } else {
            actionInput = null;
        }
        if (actionInput == null) {
            actionInput = this.getInput(SUBJECT_ELEMENT);
        }
        return actionInput;
    }

    @Override
    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(TO_ELEMENT);
        if (validationError != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing input parameter for destination address.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Destination address is unavailable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Destination address is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((validationError = this.validateInput(SUBJECT_ELEMENT)) != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing input parameter for subject.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Subject input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Subject input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        ActionSequenceValidationError htmlError = this.validateInput(HTML_MSG_ELEMENT);
        ActionSequenceValidationError plainError = this.validateInput(PLAIN_MSG_ELEMENT);
        if (htmlError != null && plainError != null) {
            if (plainError.errorCode == 3) {
                plainError.errorMsg = "Email message input parameter is uninitialized.";
                errors.add(plainError);
            } else if (htmlError.errorCode == 3) {
                htmlError.errorMsg = "Email message input parameter is uninitialized.";
                errors.add(htmlError);
            } else if (plainError.errorCode == 2) {
                plainError.errorMsg = "Email message input parameter references unknown variable.";
                errors.add(plainError);
            } else if (htmlError.errorCode == 2) {
                htmlError.errorMsg = "Email message input parameter references unknown variable.";
                errors.add(htmlError);
            } else if (plainError.errorCode == 1) {
                plainError.errorMsg = "Missing input parameter for email message.";
                errors.add(plainError);
            } else if (htmlError.errorCode == 1) {
                htmlError.errorMsg = "Missing input parameter for email message.";
                errors.add(htmlError);
            } else {
                errors.add(plainError);
            }
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public EmailAttachment addAttachment(IActionInputVariable variable) {
        EmailAttachment[] emailAttachments = this.getAttachments();
        for (int i = 0; i < emailAttachments.length; ++i) {
            if (!emailAttachments[i].isDeprecatedAttachmentStyle()) continue;
            emailAttachments[i].convertToNewAttachmentStyle();
        }
        return new EmailAttachment(this, variable);
    }

    public EmailAttachment addAttachment(String name, URI uri, String mimeType) {
        EmailAttachment[] emailAttachments = this.getAttachments();
        for (int i = 0; i < emailAttachments.length; ++i) {
            if (!emailAttachments[i].isDeprecatedAttachmentStyle()) continue;
            emailAttachments[i].convertToNewAttachmentStyle();
        }
        return new EmailAttachment(this, name, uri, mimeType);
    }

    public EmailAttachment[] getAttachments() {
        Element[] elements = this.getComponentDefElements("attachment-ref");
        EmailAttachment[] emailAttachments = new EmailAttachment[elements.length];
        if (emailAttachments.length != 0) {
            for (int i = 0; i < elements.length; ++i) {
                emailAttachments[i] = new EmailAttachment(elements[i], this.actionParameterMgr);
            }
        } else if (this.getInput("attach").getValue() != null || this.getComponentDefElement("attach") != null) {
            emailAttachments = new EmailAttachment[]{new EmailAttachment(this)};
        }
        return emailAttachments;
    }

    public class HashMapInput
    extends ActionInput {
        String key;

        HashMapInput(Element element, IActionParameterMgr actionParameterMgr, String key) {
            super(element, actionParameterMgr);
            this.key = key;
        }

        @Override
        public Object getValue() {
            return ((HashMap)super.getValue()).get(this.key);
        }
    }

    public class HTMLMsgInput
    extends ActionInput {
        HTMLMsgInput(Element element, IActionParameterMgr actionParameterMgr) {
            super(element, actionParameterMgr);
        }

        @Override
        public Object getValue() {
            Object msg = super.getValue();
            if (msg instanceof InputStream) {
                InputStream is = (InputStream)msg;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                int numRead = 0;
                try {
                    while ((numRead = is.read(bytes)) != -1) {
                        if (numRead <= 0) continue;
                        baos.write(bytes, 0, numRead);
                    }
                    msg = baos.toString();
                }
                catch (Exception e) {
                    msg = "";
                }
            }
            return msg;
        }
    }
}

