/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.pentaho.actionsequence.dom.ActionControlStatement;
import org.pentaho.actionsequence.dom.ActionIfStatement;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionLoop;
import org.pentaho.actionsequence.dom.ActionOutput;
import org.pentaho.actionsequence.dom.ActionResource;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.ActionSequenceInput;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionControlStatement;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.IActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionSequenceResource;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.ImplicitActionResource;
import org.pentaho.actionsequence.dom.actions.IActionInputFilter;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;
import org.pentaho.actionsequence.dom.actions.VariableActionInputFilter;
import org.pentaho.actionsequence.dom.messages.Messages;

public class ActionDefinition
implements IActionDefinition {
    private static final IActionSequenceValidationError[] EMPTY_ARRAY = new ActionSequenceValidationError[0];
    Element actionDefElement;
    IActionParameterMgr actionParameterMgr;
    private static final String[] EXPECTED_INPUTS = new String[0];
    private static final String[] EXPECTED_OUTPUTS = new String[0];
    private static final String[] EXPECTED_RESOURCES = new String[0];

    public ActionDefinition() {
        this(Messages.getString("ActionDefinition.ENTER_CLASS_NAME"));
        this.setDescription(Messages.getString("ActionDefinition.CUSTOM_ACTION_TITLE"));
    }

    public ActionDefinition(Element actionDefElement, IActionParameterMgr actionParameterMgr) {
        this.actionDefElement = actionDefElement;
        this.actionParameterMgr = actionParameterMgr;
    }

    protected ActionDefinition(String componentName) {
        int i = componentName.lastIndexOf(".");
        if (i >= 0 && i < componentName.length() - 1) {
            componentName = componentName.substring(i + 1);
        }
        this.actionDefElement = new DefaultElement("action-definition");
        this.actionDefElement.addElement("component-name").setText(componentName);
        this.actionDefElement.addElement("component-definition");
        this.initNewActionDefinition();
    }

    @Override
    public IActionResource setResourceUri(String privateResourceName, URI uri, String mimeType) {
        IActionResource actionResource = this.getResource(privateResourceName);
        if (uri == null) {
            if (actionResource != null) {
                actionResource.setURI(null);
            }
            actionResource = null;
        } else {
            if (actionResource == null) {
                actionResource = this.addResource(privateResourceName);
            }
            actionResource.setURI(uri);
            actionResource.setMimeType(mimeType);
        }
        return actionResource;
    }

    protected void initNewActionDefinition() {
    }

    protected static boolean hasComponentName(Element actionDefinitionElement, String componentName) {
        String elementComponentName = ActionDefinition.getComponentName(actionDefinitionElement);
        int index = elementComponentName.lastIndexOf(".");
        if (index >= 0 && index < elementComponentName.length() - 1) {
            elementComponentName = elementComponentName.substring(index + 1);
        }
        if ((index = componentName.lastIndexOf(".")) >= 0 && index < componentName.length() - 1) {
            componentName = componentName.substring(index + 1);
        }
        return componentName.equals(elementComponentName);
    }

    public static boolean accepts(Element actionDefinitionElement) {
        return actionDefinitionElement.getName().equals("action-definition");
    }

    protected static String getComponentName(Element actionDefinitionElement) {
        Element componentClassElement = actionDefinitionElement.element("component-name");
        return componentClassElement == null ? null : componentClassElement.getText();
    }

    @Override
    public String getComponentName() {
        return ActionDefinition.getComponentName(this.actionDefElement);
    }

    @Override
    public void setComponentName(String name) {
        Element componentClassName = this.actionDefElement.element("component-name");
        if (componentClassName == null) {
            componentClassName = this.actionDefElement.addElement("component-name");
            componentClassName.setText(name);
            ActionSequenceDocument.fireActionRenamed(this);
        } else if (!componentClassName.getText().equals(name)) {
            componentClassName.setText(name);
            ActionSequenceDocument.fireActionRenamed(this);
        }
    }

    @Override
    public ActionInput addInput(String privateParamName, String inputType) {
        ActionInput input = this.getInputParam(privateParamName);
        if (input == null) {
            Element[] componentDefs = this.getComponentDefElements(privateParamName);
            for (int i = 0; i < componentDefs.length; ++i) {
                componentDefs[i].detach();
            }
            Element inputElement = DocumentHelper.makeElement((Branch)this.actionDefElement, (String)("action-inputs/" + privateParamName));
            inputElement.addAttribute("type", inputType);
            input = new ActionInput(inputElement, this.actionParameterMgr);
            ActionSequenceDocument.fireIoAdded(input);
        } else {
            input.setType(inputType);
        }
        return input;
    }

    public void setActionInputValue(String inputPrivateName, IActionInputSource value) {
        if (value == null || value instanceof ActionInputConstant) {
            this.setInputValue(inputPrivateName, value != null ? ((ActionInputConstant)value).getStringValue(false) : null);
        } else {
            this.setInputParam(inputPrivateName, (IActionInputVariable)value);
        }
    }

    public void setActionInputValue(String inputPrivateName, ActionInput actionInput) {
        this.setInputParam(inputPrivateName, actionInput.getReferencedVariableName(), actionInput.getType());
    }

    @Override
    public void setInputValue(String privateParamName, String value) {
        this.setInputValue(privateParamName, value, true);
    }

    @Override
    public IActionInput setInputParam(String privateParamName, String referencedVariableName, String type) {
        ActionInput actionInput = null;
        if (referencedVariableName == null) {
            actionInput = this.getInputParam(privateParamName);
            if (actionInput != null) {
                actionInput.delete();
            }
        } else {
            actionInput = this.addInput(privateParamName, type != null ? type : "string");
            actionInput.setMapping(referencedVariableName);
        }
        return actionInput;
    }

    @Override
    public void setInputValue(String privateParamName, String value, boolean useCData) {
        this.removeInput(privateParamName);
        if (value == null) {
            this.removeComponentDefinitions(privateParamName);
        } else {
            this.setComponentDefinition(privateParamName, value, useCData);
        }
    }

    @Override
    public IActionInput getInput(String privateParamName) {
        IActionInput inputParam = IActionInput.NULL_INPUT;
        IActionInput[] allInputs = this.getInputs();
        for (int i = 0; i < allInputs.length; ++i) {
            if (!allInputs[i].getName().equals(privateParamName)) continue;
            inputParam = allInputs[i];
            break;
        }
        return inputParam;
    }

    @Override
    public IActionResource addResource(String privateResourceName) {
        return this.addResource(privateResourceName, null);
    }

    @Override
    public IActionResource addResource(String privateResourceName, String referencedActionSequenceResource) {
        IActionResource resource = this.getResource(privateResourceName);
        if (resource == null) {
            Element resourceElement = DocumentHelper.makeElement((Branch)this.actionDefElement, (String)("action-resources/" + privateResourceName));
            resourceElement.addAttribute("type", "resource");
            resource = new ActionResource(resourceElement, this.actionParameterMgr);
            if (referencedActionSequenceResource != null && referencedActionSequenceResource.trim().length() > 0) {
                resource.setMapping(referencedActionSequenceResource);
            }
            ActionSequenceDocument.fireResourceAdded(resource);
        }
        return resource;
    }

    @Override
    public IActionResource[] getResources() {
        List resourcesList = this.actionDefElement.selectNodes("action-resources/*");
        IActionResource[] resources = new ActionResource[resourcesList.size()];
        int index = 0;
        Iterator iter = resourcesList.iterator();
        while (iter.hasNext()) {
            resources[index++] = new ActionResource((Element)iter.next(), this.actionParameterMgr);
        }
        return resources;
    }

    @Override
    public IActionResource getResource(String privateResourceName) {
        return this.getResource(privateResourceName, true);
    }

    @Override
    public IActionResource getResource(String privateResourceName, boolean includeImplicitResource) {
        Element inputElement = (Element)this.actionDefElement.selectSingleNode("action-resources/" + privateResourceName);
        ActionResource actionResource = null;
        if (inputElement == null) {
            IActionSequenceResource actionSequenceResource;
            IActionSequenceDocument document;
            if (includeImplicitResource && (document = this.getDocument()) != null && (actionSequenceResource = this.getDocument().getResource(privateResourceName)) != null) {
                actionResource = new ImplicitActionResource(this, privateResourceName, this.actionParameterMgr);
            }
        } else {
            actionResource = new ActionResource(inputElement, this.actionParameterMgr);
        }
        return actionResource;
    }

    public IActionInput[] getVariableInputs() {
        List inputElements = this.actionDefElement.selectNodes("action-inputs/*");
        IActionInput[] variableInputs = new ActionInput[inputElements.size()];
        int index = 0;
        Iterator iter = inputElements.iterator();
        while (iter.hasNext()) {
            variableInputs[index++] = new ActionInput((Element)iter.next(), this.actionParameterMgr);
        }
        return variableInputs;
    }

    protected ActionInputConstant[] getConstantInputs() {
        ArrayList<ActionInputConstant> constantInputs = new ArrayList<ActionInputConstant>();
        List componentDefElements = this.actionDefElement.selectNodes("component-definition/*");
        for (Element componentDefElement : componentDefElements) {
            if (componentDefElement.elements().size() != 0) continue;
            constantInputs.add(new ActionInputConstant(componentDefElement, this.actionParameterMgr));
        }
        return constantInputs.toArray(new ActionInputConstant[0]);
    }

    @Override
    public IActionInput[] getInputs() {
        return this.getInputs(null);
    }

    @Override
    public IActionInput[] getInputs(IActionInputFilter actionInputFilter) {
        ArrayList<IActionInput> inputs = new ArrayList<IActionInput>();
        IActionInput[] variableInputs = this.getVariableInputs();
        for (int i = 0; i < variableInputs.length; ++i) {
            if (actionInputFilter != null && !actionInputFilter.accepts(variableInputs[i])) continue;
            inputs.add(variableInputs[i]);
        }
        ActionInputConstant[] constants = this.getConstantInputs();
        for (int i = 0; i < constants.length; ++i) {
            if (actionInputFilter != null && !actionInputFilter.accepts(constants[i])) continue;
            inputs.add(constants[i]);
        }
        return inputs.toArray(new IActionInput[0]);
    }

    public ActionInput getInputParam(String privateInputName) {
        Element inputElement = (Element)this.actionDefElement.selectSingleNode("action-inputs/" + privateInputName);
        return inputElement == null ? null : new ActionInput(inputElement, this.actionParameterMgr);
    }

    @Override
    public IActionOutput addOutput(String privateParamName, String outputType) {
        IActionOutput output = this.getOutput(privateParamName);
        if (output == null) {
            Element outputElement = DocumentHelper.makeElement((Branch)this.actionDefElement, (String)("action-outputs/" + privateParamName));
            outputElement.addAttribute("type", outputType);
            output = new ActionOutput(outputElement, this.actionParameterMgr);
            ActionSequenceDocument.fireIoAdded(output);
        } else {
            output.setType(outputType);
        }
        return output;
    }

    @Override
    public IActionOutput[] getOutputs() {
        List outputsList = this.actionDefElement.selectNodes("action-outputs/*");
        IActionOutput[] outputs = new ActionOutput[outputsList.size()];
        int index = 0;
        Iterator iter = outputsList.iterator();
        while (iter.hasNext()) {
            outputs[index++] = new ActionOutput((Element)iter.next(), this.actionParameterMgr);
        }
        return outputs;
    }

    @Override
    public IActionOutput getOutput(String privateParamName) {
        Element outputElement = (Element)this.actionDefElement.selectSingleNode("action-outputs/" + privateParamName);
        return outputElement == null ? null : new ActionOutput(outputElement, this.actionParameterMgr);
    }

    @Override
    public IActionOutput[] getOutputs(String[] types) {
        IActionOutput[] allOutputs = this.getOutputs();
        ArrayList<IActionOutput> matchingOutputs = new ArrayList<IActionOutput>();
        if (types == null) {
            matchingOutputs.addAll(Arrays.asList(allOutputs));
        } else {
            block0: for (int outIdx = 0; outIdx < allOutputs.length; ++outIdx) {
                for (int typeIdx = 0; typeIdx < types.length; ++typeIdx) {
                    if (!types[typeIdx].equals(allOutputs[outIdx].getType())) continue;
                    matchingOutputs.add(allOutputs[outIdx]);
                    continue block0;
                }
            }
        }
        return matchingOutputs.toArray(new ActionOutput[0]);
    }

    @Override
    public IActionOutput[] getOutputs(String type) {
        return this.getOutputs(new String[]{type});
    }

    @Override
    public String getDescription() {
        Element descriptionElement = this.actionDefElement.element("action-type");
        return descriptionElement != null ? descriptionElement.getText() : "";
    }

    @Override
    public void setDescription(String description) {
        Element descriptionElement;
        if (description == null) {
            description = "";
        }
        if ((descriptionElement = this.actionDefElement.element("action-type")) == null) {
            descriptionElement = this.actionDefElement.addElement("action-type");
            descriptionElement.setText(description);
            ActionSequenceDocument.fireActionRenamed(this);
        } else if (!descriptionElement.getText().equals(description)) {
            descriptionElement.setText(description);
            ActionSequenceDocument.fireActionRenamed(this);
        }
    }

    @Override
    public boolean equals(Object arg0) {
        boolean result = false;
        if (arg0 instanceof ActionDefinition) {
            ActionDefinition actionDef = (ActionDefinition)arg0;
            result = actionDef.actionDefElement != null ? actionDef.actionDefElement.equals(this.actionDefElement) : actionDef == this;
        }
        return result;
    }

    @Override
    public IActionControlStatement getParent() {
        Element ancestorElement;
        ActionControlStatement controlStatement = null;
        if (this.actionDefElement != null && (ancestorElement = this.actionDefElement.getParent()) != null && ancestorElement.getName().equals("actions") && !ancestorElement.getPath().equals("/action-sequence/actions")) {
            controlStatement = ancestorElement.element("condition") != null ? new ActionIfStatement(ancestorElement, this.actionParameterMgr) : new ActionLoop(ancestorElement, this.actionParameterMgr);
        }
        return controlStatement;
    }

    @Override
    public Element getElement() {
        return this.actionDefElement;
    }

    @Override
    public void delete() {
        Document doc = this.actionDefElement.getDocument();
        if (doc != null) {
            this.actionDefElement.detach();
            ActionSequenceDocument.fireActionRemoved(new ActionSequenceDocument(doc, this.actionParameterMgr), this);
        }
    }

    @Override
    public IActionSequenceDocument getDocument() {
        ActionSequenceDocument doc = null;
        if (this.actionDefElement != null && this.actionDefElement.getDocument() != null) {
            doc = new ActionSequenceDocument(this.actionDefElement.getDocument(), this.actionParameterMgr);
        }
        return doc;
    }

    @Override
    public String getComponentDefinitionValue(String compDefXpath) {
        Element componentDef = this.getComponentDefElement(compDefXpath);
        return componentDef != null ? componentDef.getText() : null;
    }

    @Override
    public String[] getComponentDefinitionValues(String compDefXpath) {
        Element[] componentDefs = this.getComponentDefElements(compDefXpath);
        String[] values = new String[componentDefs.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = componentDefs[i].getText();
        }
        return values;
    }

    @Override
    public Element[] getComponentDefElements(String compDefXpath) {
        return this.actionDefElement.selectNodes("component-definition/" + compDefXpath).toArray(new Element[0]);
    }

    @Override
    public Element getComponentDefElement(String compDefXpath) {
        return this.actionDefElement == null ? null : (Element)this.actionDefElement.selectSingleNode("component-definition/" + compDefXpath);
    }

    @Override
    public Element getComponentDefElement() {
        return (Element)this.actionDefElement.selectSingleNode("component-definition");
    }

    @Override
    public void setComponentDefinition(String compDefXpath, String value) {
        this.setComponentDefinition(compDefXpath, value, false);
    }

    @Override
    public void setComponentDefinition(String compDefXpath, String[] values) {
        boolean changed = false;
        Element[] componentDefs = this.getComponentDefElements(compDefXpath);
        for (int i = 0; i < componentDefs.length; ++i) {
            componentDefs[i].detach();
        }
        if (componentDefs.length > 0) {
            changed = true;
        }
        if (values.length > 0) {
            Element componentDef = DocumentHelper.makeElement((Branch)this.actionDefElement, (String)("component-definition/" + compDefXpath));
            componentDef.setText(values[0]);
            Element parent = componentDef.getParent();
            for (int i = 1; i < values.length; ++i) {
                parent.addElement(componentDef.getName()).setText(values[i]);
            }
            changed = true;
        }
        if (changed) {
            ActionSequenceDocument.fireActionChanged(this);
        }
    }

    @Override
    public void setComponentDefinitionAttribute(String compDefXpath, String attributeName, String value) {
        Element componentDef = this.getComponentDefElement(compDefXpath);
        if (componentDef == null && value != null) {
            componentDef = DocumentHelper.makeElement((Branch)this.actionDefElement, (String)("component-definition/" + compDefXpath));
        }
        if (componentDef != null) {
            componentDef.addAttribute(attributeName, value);
            ActionSequenceDocument.fireActionChanged(this);
        }
    }

    @Override
    public void setComponentDefinition(String compDefXpath, String value, boolean useCData) {
        if (value == null) {
            Element[] componentDefs = this.getComponentDefElements(compDefXpath);
            for (int i = 0; i < componentDefs.length; ++i) {
                componentDefs[i].detach();
            }
            if (componentDefs.length > 0) {
                ActionSequenceDocument.fireActionChanged(this);
            }
        } else {
            Element componentDef = this.getComponentDefElement(compDefXpath);
            if (componentDef == null) {
                componentDef = DocumentHelper.makeElement((Branch)this.actionDefElement, (String)("component-definition/" + compDefXpath));
            }
            componentDef.clearContent();
            if (useCData) {
                componentDef.addCDATA(value);
            } else {
                componentDef.setText(value);
            }
            ActionSequenceDocument.fireActionChanged(this);
        }
    }

    public void removeOutput(String privateParamName) {
        IActionOutput actionOutput = this.getOutput(privateParamName);
        if (actionOutput != null) {
            actionOutput.delete();
        }
    }

    @Override
    public void removeInput(String privateParamName) {
        ActionInput actionInput = this.getInputParam(privateParamName);
        if (actionInput != null) {
            actionInput.delete();
        }
    }

    @Override
    public void renameInput(String oldName, String newName) {
        ActionInput actionInput;
        if (!oldName.equals(newName) && (actionInput = this.getInputParam(oldName)) != null) {
            Element componentDefElement = this.actionDefElement.element("component-definition");
            try {
                String xmlString;
                if (componentDefElement != null && (xmlString = componentDefElement.asXML()).indexOf("{" + oldName + "}") >= 0) {
                    xmlString = xmlString.replaceAll("\\{" + oldName + "\\}", "{" + newName + "}");
                    Document document = DocumentHelper.parseText((String)xmlString);
                    this.actionDefElement.remove(componentDefElement);
                    this.actionDefElement.add(document.getRootElement());
                }
                actionInput.setName(newName);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void removeResource(String privateResourceName) {
        IActionResource actionResource = this.getResource(privateResourceName);
        if (actionResource != null) {
            actionResource.delete();
        }
    }

    @Override
    public void deleteAllInputs() {
        IActionInput[] actionInputs = this.getInputs(new VariableActionInputFilter());
        for (int i = 0; i < actionInputs.length; ++i) {
            ((ActionInput)actionInputs[i]).delete();
        }
    }

    @Override
    public void deleteAllOutputs() {
        IActionOutput[] actionOutputs = this.getOutputs();
        for (int i = 0; i < actionOutputs.length; ++i) {
            actionOutputs[i].delete();
        }
    }

    @Override
    public void deleteAllResources() {
        IActionResource[] actionResources = this.getResources();
        for (int i = 0; i < actionResources.length; ++i) {
            actionResources[i].delete();
        }
    }

    @Override
    public void removeComponentDefinitions(String compDefXpath) {
        Element[] componentDefs = this.getComponentDefElements(compDefXpath);
        for (int i = 0; i < componentDefs.length; ++i) {
            componentDefs[i].detach();
        }
        if (componentDefs.length > 0) {
            ActionSequenceDocument.fireActionChanged(this);
        }
    }

    @Override
    public void removeComponentDefinitions() {
        List elements;
        Element componentDefElement;
        if (this.actionDefElement != null && (componentDefElement = this.actionDefElement.element("component-definition")) != null && (elements = componentDefElement.elements()).size() > 0) {
            elements.clear();
            ActionSequenceDocument.fireActionChanged(this);
        }
    }

    @Override
    public void setInputIndex(ActionInput actionInput, int index) {
        Element inputsParent;
        List inputs;
        int currentIndex;
        if (this.equals(actionInput.getActionDefinition()) && (currentIndex = (inputs = (inputsParent = this.actionDefElement.element("action-inputs")).elements()).indexOf(actionInput.getElement())) != index) {
            List elements = inputsParent.elements();
            elements.remove(currentIndex);
            if (index > elements.size() - 1) {
                elements.add(actionInput.getElement());
            } else {
                elements.add(index, actionInput.getElement());
            }
            ActionSequenceDocument.fireActionChanged(this);
        }
    }

    @Override
    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    @Override
    public String[] getReservedOutputNames() {
        return EXPECTED_OUTPUTS;
    }

    @Override
    public String[] getReservedResourceNames() {
        return EXPECTED_RESOURCES;
    }

    private IActionInput setInputParam(String privateParamName, IActionInputVariable referencedVariable) {
        IActionInput actionInput = null;
        if (referencedVariable != null) {
            actionInput = this.setInputParam(privateParamName, referencedVariable.getVariableName(), referencedVariable.getType());
        } else {
            this.removeInput(privateParamName);
        }
        return actionInput;
    }

    protected IActionOutput setOutput(String privateParamName, String publicParamName, String outputType) {
        IActionOutput actionOutput = null;
        if (publicParamName == null || publicParamName.trim().length() == 0) {
            this.removeOutput(privateParamName);
        } else {
            actionOutput = this.addOutput(privateParamName, outputType);
            actionOutput.setMapping(publicParamName);
        }
        return actionOutput;
    }

    protected String getPublicOutputName(String privateName) {
        String publicName = null;
        IActionOutput actionOutput = this.getOutput(privateName);
        if (actionOutput != null) {
            publicName = actionOutput.getPublicName();
        }
        return publicName;
    }

    protected ActionSequenceValidationError validateInput(String privateParamName) {
        int errorCode = 0;
        ActionInput actionInput = this.getInputParam(privateParamName);
        if (actionInput == null) {
            if (this.getComponentDefElement(privateParamName) == null) {
                errorCode = 1;
            }
        } else {
            IActionInputVariable[] availableInputVariables = this.getDocument().getAvailInputVariables((IActionDefinition)this, actionInput.getType());
            if (availableInputVariables.length == 0) {
                errorCode = 2;
            } else {
                errorCode = 3;
                for (int i = 0; i < availableInputVariables.length && errorCode == 3; ++i) {
                    if (availableInputVariables[i] instanceof ActionSequenceInput) {
                        ActionSequenceInput actionSequenceInput = (ActionSequenceInput)availableInputVariables[i];
                        if (actionSequenceInput.getDefaultValue() == null) continue;
                        errorCode = 0;
                        continue;
                    }
                    if (!(availableInputVariables[i] instanceof ActionOutput)) continue;
                    errorCode = 0;
                }
            }
        }
        ActionSequenceValidationError validationError = null;
        if (errorCode != 0) {
            validationError = new ActionSequenceValidationError();
            validationError.actionDefinition = this;
            validationError.errorCode = errorCode;
            validationError.parameterName = privateParamName;
            switch (errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing input.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Input references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Input is uninitialized.";
                }
            }
        }
        return validationError;
    }

    protected ActionSequenceValidationError validateResource(String privateResourceName) {
        ActionSequenceValidationError validationError = this.validateInput(privateResourceName);
        if (validationError != null) {
            validationError = null;
            int errorCode = 0;
            IActionResource actionResource = this.getResource(privateResourceName);
            errorCode = actionResource == null ? 1 : 2;
            if (errorCode != 0) {
                validationError = new ActionSequenceValidationError();
                validationError.actionDefinition = this;
                validationError.errorCode = errorCode;
                validationError.parameterName = privateResourceName;
                switch (errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing input.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Input references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Input is uninitialized.";
                    }
                }
            }
        }
        return validationError;
    }

    @Override
    public IActionSequenceValidationError[] validate() {
        return EMPTY_ARRAY;
    }

    protected ActionSequenceValidationError validateOutput(String privateParamName) {
        ActionSequenceValidationError validationError = null;
        if (this.getOutput(privateParamName) == null) {
            validationError = new ActionSequenceValidationError();
            validationError.actionDefinition = this;
            validationError.errorCode = 4;
            validationError.parameterName = privateParamName;
            validationError.errorMsg = "Missing output.";
        }
        return validationError;
    }

    @Override
    public IActionParameterMgr getActionParameterMgr() {
        return this.actionParameterMgr;
    }

    @Override
    public void setActionParameterMgr(IActionParameterMgr actionParameterMgr) {
        this.actionParameterMgr = actionParameterMgr;
    }

    public int hashCode() {
        return this.actionDefElement != null ? this.actionDefElement.hashCode() : super.hashCode();
    }
}

